/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.object;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativeSession;
import com.wewebu.ow.server.ecmimpl.opencmis.exception.OwCMISRuntimeException;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractNativeObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISRelationship;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISRelationshipClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.RelationshipType;
import org.apache.chemistry.opencmis.client.api.TransientRelationship;
import org.apache.log4j.Logger;

public class OwCMISRelationshipObject
extends OwCMISAbstractNativeObject<TransientRelationship, RelationshipType, OwCMISRelationshipClass>
implements OwCMISRelationship {
    private static final Logger LOG = OwLog.getLogger(OwCMISRelationshipObject.class);

    public OwCMISRelationshipObject(OwCMISNativeSession session_p, TransientRelationship nativeObject_p, OperationContext creationContext, OwCMISRelationshipClass class_p) throws OwException {
        super(session_p, nativeObject_p, creationContext, class_p);
    }

    public final OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    public final OwVersion getVersion() throws Exception {
        return null;
    }

    public void setContentCollection(OwContentCollection content_p) throws Exception {
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public OwObjectReference getTarget() {
        try {
            return (OwObjectReference)this.getProperty("cmis:targetId").getValue();
        }
        catch (OwException e) {
            LOG.warn((Object)"faild to get target as reference object", (Throwable)e);
            throw new OwCMISRuntimeException("faild to get target as reference object", (Throwable)e);
        }
    }

    public OwObjectReference getSource() {
        try {
            return (OwObjectReference)this.getProperty("cmis:sourceId").getValue();
        }
        catch (OwException e) {
            LOG.warn((Object)"faild to get source as reference object", (Throwable)e);
            throw new OwCMISRuntimeException("faild to get source as reference object", (Throwable)e);
        }
    }

    public OwObjectLinkRelation getRelation(OwObject obj) {
        String sourceId = (String)((TransientRelationship)this.getNativeObject()).getPropertyValue("cmis:sourceId");
        String targetId = (String)((TransientRelationship)this.getNativeObject()).getPropertyValue("cmis:targetId");
        String objId = OwObjectIDCodeUtil.decode((String)obj.getID());
        if (sourceId.equals(objId)) {
            if (targetId.equals(objId)) {
                return OwObjectLinkRelation.BOTH;
            }
            return OwObjectLinkRelation.OUTBOUND;
        }
        if (targetId.equals(objId)) {
            return OwObjectLinkRelation.INBOUND;
        }
        return OwObjectLinkRelation.NONE;
    }
}

