/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.propertyclass;

import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg;
import com.wewebu.ow.server.ecmimpl.opencmis.field.OwCMISFormat;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClassProxy;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISQualifiedName;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString2;
import java.util.List;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class OwCMISAbstractPropertyClass<V, C extends OwCMISObjectClass>
implements OwCMISPropertyClass<V> {
    private static final Logger LOG;
    private C objectClass;
    private String className;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        OwCMISAbstractPropertyClass.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISAbstractPropertyClass.class);
    }

    public OwCMISAbstractPropertyClass(String className, C objectClass) {
        this.objectClass = objectClass;
        this.className = className;
    }

    public String getCategory() {
        return "";
    }

    public final String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        return this.getFullQualifiedName().toString();
    }

    public boolean isEnum() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwEnumCollection myEnums = this.getEnums();
                bl = myEnums != null && !myEnums.isEmpty();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public Object getValueFromNode(Node node_p) throws OwException {
        Node node = node_p;
        try {
            Object object;
            block8: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    if (node_p == null) {
                        object = null;
                        break block8;
                    }
                    if (node_p.getNodeType() == 3) {
                        object = this.getValueFromString(node_p.getNodeValue());
                        break block8;
                    }
                    LOG.error((Object)("OwCMISAbstractPropertyClass.getValueFromNode(): Unsupported node type : " + node_p.getNodeType()));
                    throw new OwNotSupportedException(new OwString("opencmis.propertyclass.OwCMISAbstractPropertyClass.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return object;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)node));
            }
            throw cmisBaseException;
        }
    }

    public Object getValueFromString(String text_p) throws OwException {
        String string = text_p;
        try {
            Object object;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISFormat format = this.getFormat();
                if (format == null) {
                    String msg = "No OwFormat found for property class " + this.getClassName() + " @ java implementation " + this.getClass().getName();
                    LOG.error((Object)("OwCMISAbstractPropertyClass.getValueFromString():" + msg));
                    throw new OwInvalidOperationException((OwString)new OwString2("opencmis.propertyclass.OwCMISAbstractPropertyClass.noformat.error", "No OwFormat found for property class %1  @ java implementation %2", this.getClassName(), this.getClass().getName()));
                }
                object = format.parse(text_p, this.isArray());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return object;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public Node getNodeFromValue(Object value_p, Document doc_p) {
        return null;
    }

    public List<?> getComplexChildClasses() {
        return null;
    }

    public boolean isComplex() {
        return false;
    }

    public C getObjectClass() {
        return this.objectClass;
    }

    @Override
    public OwCMISQualifiedName getFullQualifiedName() {
        C objectClass = this.getObjectClass();
        String objectClassName = objectClass.getClassName();
        return new OwCMISQualifiedName(objectClassName, this.getNonQualifiedName());
    }

    @Override
    public OwCMISPropertyClass<V> createProxy(String className) {
        return new OwCMISPropertyClassProxy(className, this, this.getObjectClass());
    }

    protected abstract boolean isSystem() throws OwException;

    @Override
    public final boolean isSystemProperty() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISPreferredPropertyTypeCfg.PropertyType prefferedType = this.getPreferredPropertyType();
                bl = OwCMISPreferredPropertyTypeCfg.PropertyType.UNSET == prefferedType ? this.isSystem() : OwCMISPreferredPropertyTypeCfg.PropertyType.SYSTEM == prefferedType;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISPreferredPropertyTypeCfg.PropertyType getPreferredPropertyType() throws OwException {
        try {
            OwCMISPreferredPropertyTypeCfg.PropertyType propertyType;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                propertyType = this.objectClass.getPreferredPropertyType(this);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return propertyType;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAbstractPropertyClass.java", OwCMISAbstractPropertyClass.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnum", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractPropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValueFromNode", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractPropertyClass", "org.w3c.dom.Node", "node_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.Object"), 77);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValueFromString", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractPropertyClass", "java.lang.String", "text_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.Object"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isSystemProperty", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractPropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 153);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getPreferredPropertyType", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractPropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg$PropertyType"), 165);
    }
}

