/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.search;

import com.wewebu.ow.csqlc.OwCSQLCException;
import com.wewebu.ow.csqlc.OwCSQLCProcessor;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwComparisonOperator;
import com.wewebu.ow.csqlc.ast.OwCorrelatedTableName;
import com.wewebu.ow.csqlc.ast.OwFolderPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwFunctionFolderFormat;
import com.wewebu.ow.csqlc.ast.OwPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwSQLDateTimeLiteral;
import com.wewebu.ow.csqlc.ast.OwTextSearchPredicate;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISSQLDateTimeLiteral;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISCSQLCProcessor
extends OwCSQLCProcessor {
    private static final Logger LOG;
    private static final OwFolderPredicateFormat FOLDER_FORMAT;
    private static final OwPredicateFormat IN_FORMAT;
    private static final OwPredicateFormat QUANTIIFED_IN_FORMAT;
    private static final OwPredicateFormat QUANTIIFED_COPMARISON_FORMAT;
    private static final OwPredicateFormat LIKE_FORMAT;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        OwCMISCSQLCProcessor.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISCSQLCProcessor.class);
        FOLDER_FORMAT = new OwFunctionFolderFormat("IN_FOLDER", "IN_TREE");
        IN_FORMAT = new OwPredicateFormat(null, null, "IN", "NOT IN", null, null);
        QUANTIIFED_IN_FORMAT = new OwPredicateFormat("ANY", "ANY", "IN", "NOT IN", null, null);
        QUANTIIFED_COPMARISON_FORMAT = new OwPredicateFormat(null, "NOT", "= ANY", "= ANY", null, null);
        LIKE_FORMAT = new OwPredicateFormat(null, null, "LIKE", "NOT LIKE", null, null);
    }

    public OwCMISCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p) {
        super(entitiesResolver_p);
    }

    protected OwColumnQualifier createFromTableQualifier(String tableName_p, String typeName_p) {
        return new OwColumnQualifier(tableName_p, typeName_p);
    }

    protected OwColumnQualifier createColumnQualifier(String propertyName_p, String repositoryID_p) throws OwException {
        String string = propertyName_p;
        String string2 = repositoryID_p;
        try {
            OwColumnQualifier owColumnQualifier;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                int dotIndex = propertyName_p.indexOf(46);
                String tableNamePart = null;
                tableNamePart = dotIndex != -1 ? propertyName_p.substring(0, dotIndex) : propertyName_p;
                String tableName = this.m_entitiesResolver.resolveQueryTableName(tableNamePart, repositoryID_p);
                owColumnQualifier = tableName != null ? new OwColumnQualifier(tableName, tableNamePart) : null;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owColumnQualifier;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    protected OwColumnQualifier createQueryColumnQualifier(String tableName_p, String typeName_p) {
        return new OwColumnQualifier(tableName_p, typeName_p);
    }

    protected OwColumnQualifier createQueryFieldQualifier(OwFieldDefinition fieldDefinition_p, OwCSQLCProcessor.OwProcessContext context_p) throws OwException {
        OwFieldDefinition owFieldDefinition = fieldDefinition_p;
        OwCSQLCProcessor.OwProcessContext owProcessContext = context_p;
        try {
            OwColumnQualifier owColumnQualifier;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String fieldClassName = fieldDefinition_p.getClassName();
                int dotIndex = fieldClassName.indexOf(46);
                String tableNamePart = null;
                tableNamePart = dotIndex != -1 ? fieldClassName.substring(0, dotIndex) : fieldClassName;
                String tableName = this.m_entitiesResolver.resolveQueryTableName(tableNamePart, context_p.repositoryID);
                if (tableName == null) {
                    String message = "The filed definition " + fieldClassName + " is not qualifiable! ";
                    LOG.error((Object)("OwCMISSearchNodeSQLProcessor.createQueryFieldQualifier():" + message));
                    throw new OwInvalidOperationException((OwString)new OwString1("opencmis.search.OwCMISCSQLCProcessor.err.non.queryable.field", "Invalid search field. The field %1 can not be queried.", fieldClassName));
                }
                owColumnQualifier = new OwColumnQualifier(tableName, tableNamePart);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owColumnQualifier;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)owFieldDefinition, (Object)owProcessContext));
            }
            throw cmisBaseException;
        }
    }

    protected OwSQLDateTimeLiteral createLiteral(OwSearchCriteria criteria_p, Date date_p) throws OwCSQLCException {
        return new OwCMISSQLDateTimeLiteral(this.convertDate(date_p));
    }

    protected XMLGregorianCalendar convertDate(Date definedDate_p) throws OwCSQLCException {
        TimeZone from = this.m_entitiesResolver.getNetworkContext().getClientTimeZone();
        TimeZone to = TimeZone.getTimeZone("UTC");
        try {
            return OwDateTimeUtil.convertToXMLGregorianCalendar((Date)definedDate_p, (TimeZone)from, (TimeZone)to);
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn((Object)"Could not convert into XMLGregorianCalendar", (Throwable)e);
            throw new OwCSQLCException("XMLGregorianCalendar error.", (Throwable)e);
        }
    }

    protected String createJoinColumnName(OwColumnQualifier qualifier_p) {
        return "cmis:objectId";
    }

    protected OwPredicateFormat getInFormat() {
        return IN_FORMAT;
    }

    protected OwPredicateFormat getQuantifiedInFormat() {
        return QUANTIIFED_IN_FORMAT;
    }

    protected OwPredicateFormat getQuantifiedComparisonFormat() {
        return QUANTIIFED_COPMARISON_FORMAT;
    }

    protected OwFolderPredicateFormat getFolderPredicateFormat() {
        return FOLDER_FORMAT;
    }

    protected OwTextSearchPredicate createTextSearchPredicate(OwCharacterStringLiteral searchExpression_p, OwColumnReference columnReference_p) throws OwException {
        OwCharacterStringLiteral owCharacterStringLiteral = searchExpression_p;
        OwColumnReference owColumnReference = columnReference_p;
        try {
            OwTextSearchPredicate owTextSearchPredicate;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (columnReference_p != null) {
                    throw new OwInvalidOperationException("Property based text search predicates are not supported.");
                }
                owTextSearchPredicate = new OwTextSearchPredicate(searchExpression_p, null, new OwColumnQualifier(), null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owTextSearchPredicate;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)owCharacterStringLiteral, (Object)owColumnReference));
            }
            throw cmisBaseException;
        }
    }

    protected String joinType(OwCorrelatedTableName joinedTable_p) {
        return "";
    }

    protected OwPredicateFormat createLikeFormat() {
        return LIKE_FORMAT;
    }

    protected String escapeNativeWildCardRepresentation(String value_p, Collection<OwWildCardDefinition> wildCardDefs) {
        for (OwWildCardDefinition def : wildCardDefs) {
            value_p = OwString.replaceAll((String)value_p, (String)def.getNativeWildCard(), (String)("\\" + def.getNativeWildCard()));
        }
        return value_p;
    }

    protected boolean isMultipleTextSearchSyntax() {
        return false;
    }

    protected OwCSQLCProcessor.RangeLimits getBetweenPredicateRangeLimits(OwSearchCriteria criteria_p, boolean negate_p, OwCSQLCProcessor.OwProcessContext context_p) {
        OwSearchCriteria secondRangeCriteria = criteria_p.getSecondRangeCriteria();
        Object v1 = criteria_p.getValue();
        Object v2 = secondRangeCriteria.getValue();
        if (v1 instanceof Date && criteria_p.isIgnoreTime()) {
            v1 = OwDateTimeUtil.setBeginOfDayTime((Date)((Date)v1));
        }
        if (v2 instanceof Date && criteria_p.isIgnoreTime()) {
            v2 = OwDateTimeUtil.setBeginOfNextDayTime((Date)((Date)v2));
        }
        return new OwCSQLCProcessor.RangeLimits((OwCSQLCProcessor)this, v1, v2);
    }

    protected Object getLimitForComparisonPredicate(OwSearchCriteria criteria_p, OwComparisonOperator comparisonOperator_p, OwCSQLCProcessor.OwProcessContext context_p) {
        Object value = criteria_p.getValue();
        if (value instanceof Date && criteria_p.isIgnoreTime()) {
            int operator = criteria_p.getOperator();
            if (14 == operator || 8 == operator) {
                value = OwDateTimeUtil.setBeginOfNextDayTime((Date)((Date)value));
            } else if (12 == operator || 10 == operator) {
                value = OwDateTimeUtil.setBeginOfDayTime((Date)((Date)value));
            }
        }
        return value;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISCSQLCProcessor.java", OwCMISCSQLCProcessor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createColumnQualifier", "com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor", "java.lang.String:java.lang.String", "propertyName_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.csqlc.ast.OwColumnQualifier"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createQueryFieldQualifier", "com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor", "com.wewebu.ow.server.field.OwFieldDefinition:com.wewebu.ow.csqlc.OwCSQLCProcessor$OwProcessContext", "fieldDefinition_p:context_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.csqlc.ast.OwColumnQualifier"), 101);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createTextSearchPredicate", "com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor", "com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral:com.wewebu.ow.csqlc.ast.OwColumnReference", "searchExpression_p:columnReference_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.csqlc.ast.OwTextSearchPredicate"), 191);
    }
}

