/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.ui;

import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollection;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeEditorDocument;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwMenu;
import com.wewebu.ow.server.ui.OwView;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISAccessRightsModule
extends OwUIAccessRightsModul<OwCMISNetwork>
implements OwDialog.OwDialogListener {
    private static final Logger LOG;
    public static final String HEADER_PRINCIPAL = "Principal";
    public static final String HEADER_ACE = "Ace(s)";
    public static final String HEADER_ISDIRECT = "isDirect";
    protected static final List<String> DEFAULT_HEADERS;
    public static final String EDIT_ROW = "row";
    private boolean readOnly;
    private OwObject permObj;
    private OwCMISPermissionCollection permissions;
    private OwMenu menu;
    private boolean addDialog;
    private List<String> previousSelectedPrincipals;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        OwCMISAccessRightsModule.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISAccessRightsModule.class);
        DEFAULT_HEADERS = new LinkedList<String>();
        DEFAULT_HEADERS.add(HEADER_PRINCIPAL);
        DEFAULT_HEADERS.add(HEADER_ACE);
        DEFAULT_HEADERS.add(HEADER_ISDIRECT);
    }

    public OwCMISAccessRightsModule(OwObject object) throws OwException {
        this.permObj = object;
    }

    public void init() throws Exception {
        super.init();
        this.menu = new OwSubMenuView();
        this.addView((OwView)this.menu, null);
        this.createActions(this.menu);
        this.permissions = (OwCMISPermissionCollection)this.permObj.getPermissions();
    }

    public void setReadOnly(boolean readOnly_p) {
        this.readOnly = readOnly_p;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void onRender(Writer w_p) throws Exception {
        w_p.write("<div class=\"OwCMISAccessRightsModule OwUIAccessRightsModul\">");
        w_p.write("<table class=\"OwGeneralList_table\"><thead><tr>");
        List<String> headers = this.getHeaderList();
        OwNetworkContext nctx = ((OwCMISNetwork)this.getNetwork()).getContext();
        w_p.write("<th></th>");
        for (String header : headers) {
            w_p.write("<th>");
            w_p.write(nctx.localizeLabel(header));
            w_p.write("</th>");
        }
        w_p.write("</tr></thead>\n<tbody>");
        Iterator itSets = this.getPermissions().getAppliedPrivilegeSets().iterator();
        int rowIdx = 0;
        while (itSets.hasNext()) {
            OwPrivilegeSet set = (OwPrivilegeSet)itSets.next();
            w_p.write("<tr class=\"");
            w_p.write(rowIdx % 2 == 0 ? "EvenRow" : "OddRow");
            w_p.write("\">");
            w_p.write("<td>");
            this.renderSelectionColumn(w_p, set, rowIdx);
            w_p.write("</td>");
            int colIdx = 0;
            while (colIdx < headers.size()) {
                w_p.write("<td>");
                this.renderRowValue(w_p, set, headers.get(colIdx), colIdx, rowIdx);
                w_p.write("</td>");
                ++colIdx;
            }
            w_p.write("</tr>\n");
            ++rowIdx;
        }
        w_p.write("</tbody></table>");
        w_p.write("<div class=\"OwInlineMenu\" >");
        super.onRender(w_p);
        w_p.write("</div></div>");
    }

    protected void renderSelectionColumn(Writer w_p, OwPrivilegeSet set, int rowIdx) throws IOException {
        if (!this.isReadOnly() && set.getInheritanceDepth() == 0) {
            w_p.write("<input type=\"checkbox\" id=\"");
            w_p.write(EDIT_ROW);
            w_p.write("_");
            w_p.write(Integer.toString(rowIdx));
            w_p.write("\" name=\"");
            w_p.write(EDIT_ROW);
            w_p.write("\" value=\"");
            w_p.write(Integer.toString(rowIdx));
            w_p.write("\" />");
        }
    }

    protected void renderRowValue(Writer w_p, OwPrivilegeSet set, String header, int colIdx, int rowIdx) throws IOException {
        if (HEADER_ISDIRECT.equals(header)) {
            w_p.write("<input type=\"checkbox\" id=\"");
            w_p.write(header + "_" + rowIdx + "_" + colIdx);
            w_p.write("\" ");
            if (set.getInheritanceDepth() == 0) {
                w_p.write("checked");
            }
            w_p.write(" disabled />");
        } else if (HEADER_PRINCIPAL.equals(header)) {
            try {
                w_p.write(set.getPrincipal().getUserDisplayName());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not get Information of Principal object", (Throwable)e);
                w_p.write("Access to Principal object failed.");
            }
        } else if (HEADER_ACE.equals(header)) {
            for (OwPrivilege priv : set.getPrivileges()) {
                w_p.write(this.getContext().localize("owlabel." + priv.getName(), priv.getName()));
                w_p.write("<br />");
            }
        }
    }

    protected void createActions(OwMenu menu) throws Exception {
        if (!this.isReadOnly()) {
            menu.addFormMenuItem((OwEventTarget)this, this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.name.add", "Add"), "Add", this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.tooltip.add", "Add new entry"));
            menu.addFormMenuItem((OwEventTarget)this, this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.name.modify", "Modify"), "Modify", this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.tooltip.Modify", "Modify selected entry"));
            menu.addFormMenuItem((OwEventTarget)this, this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.name.delete", "Delete"), "Delete", this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.tooltip.delete", "Delete selected"));
            if (this.getObject().canSetPermissions()) {
                menu.addFormMenuItem((OwEventTarget)this, this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.name.save", "Save"), "Save", this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.btn.tooltip.save", "Save changes"));
            }
        }
    }

    public OwMenu getMenu() {
        return this.menu;
    }

    protected OwCMISPermissionCollection getPermissions() {
        return this.permissions;
    }

    protected OwObject getObject() {
        return this.permObj;
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected List<String> getHeaderList() {
        return new LinkedList<String>(DEFAULT_HEADERS);
    }

    public void onSave(HttpServletRequest req, Object reason) throws OwException {
        HttpServletRequest httpServletRequest = req;
        Object object = reason;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    this.permObj.setPermissions((OwPermissionCollection)this.getPermissions());
                    this.permissions = (OwCMISPermissionCollection)this.permObj.getPermissions();
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)"Could not save permission collection", (Throwable)e);
                    throw new OwServerException(this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.err.save", "Could not save permissions in object"), (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest, (Object)object));
            }
            throw cmisBaseException;
        }
    }

    public void onAdd(HttpServletRequest req, Object reason) throws OwException {
        HttpServletRequest httpServletRequest = req;
        Object object = reason;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    OwCMISPrivilegeSetEditor editorDlg = this.createEditor();
                    OwCMISPrivilegeEditorDocument doc = this.createEditorDocument(this.getPermissions(), null);
                    if (this.getPreviousSelectedPrincipals() != null) {
                        doc.setPrincipalSelection(this.getPreviousSelectedPrincipals());
                    }
                    editorDlg.setDocument(doc);
                    this.getContext().openDialog((OwDialog)editorDlg, (OwDialog.OwDialogListener)this);
                    this.addDialog = true;
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot open Dialog", (Throwable)e);
                    throw new OwServerException(this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.err.onAdd", "Could not open editor dialog"), (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest, (Object)object));
            }
            throw cmisBaseException;
        }
    }

    public void onModify(HttpServletRequest req, Object reason) throws OwException {
        HttpServletRequest httpServletRequest = req;
        Object object = reason;
        try {
            block11: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    String[] rows = req.getParameterValues(EDIT_ROW);
                    if (rows == null || rows.length <= 0) break block11;
                    List<String> selectedRows = Arrays.asList(rows);
                    LinkedList<OwPrivilegeSet> sets = new LinkedList<OwPrivilegeSet>();
                    Iterator itSets = this.getPermissions().getAppliedPrivilegeSets().iterator();
                    int rowIdx = 0;
                    while (itSets.hasNext()) {
                        OwPrivilegeSet set = (OwPrivilegeSet)itSets.next();
                        if (selectedRows.contains(Integer.toString(rowIdx))) {
                            sets.add(set);
                        }
                        ++rowIdx;
                    }
                    try {
                        OwCMISPrivilegeSetEditor editorDlg = this.createEditor();
                        editorDlg.setDocument(this.createEditorDocument(this.getPermissions(), sets));
                        this.getContext().openDialog((OwDialog)editorDlg, (OwDialog.OwDialogListener)this);
                    }
                    catch (OwException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot open Dialog", (Throwable)e);
                        throw new OwServerException(this.getContext().localize("opencmis.ui.OwCMISAccessRightsModule.err.onAdd", "Could not open editor dialog"), (Throwable)e);
                    }
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest, (Object)object));
            }
            throw cmisBaseException;
        }
    }

    public void onDelete(HttpServletRequest req, Object reason) throws OwException {
        HttpServletRequest httpServletRequest = req;
        Object object = reason;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String[] rows = req.getParameterValues(EDIT_ROW);
                if (rows != null && rows.length > 0) {
                    List<String> deletedRows = Arrays.asList(rows);
                    Iterator itSets = this.permissions.getAppliedPrivilegeSets().iterator();
                    int rowIdx = 0;
                    while (itSets.hasNext()) {
                        OwPrivilegeSet set = (OwPrivilegeSet)itSets.next();
                        if (deletedRows.contains(Integer.toString(rowIdx))) {
                            this.permissions.removePrivilegeSet(set);
                        }
                        ++rowIdx;
                    }
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest, (Object)object));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISPrivilegeSetEditor createEditor() {
        return new OwCMISPrivilegeSetEditor();
    }

    protected OwCMISPrivilegeEditorDocument createEditorDocument(OwCMISPermissionCollection perms, List<OwPrivilegeSet> modifySet) throws Exception {
        return new OwCMISPrivilegeEditorDocument(perms, modifySet);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        if (this.addDialog) {
            this.previousSelectedPrincipals = ((OwCMISPrivilegeEditorDocument)dialogView_p.getDocument()).getPrincipalSelection();
            this.addDialog = false;
        }
    }

    protected List<String> getPreviousSelectedPrincipals() {
        return this.previousSelectedPrincipals;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAccessRightsModule.java", OwCMISAccessRightsModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onSave", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISAccessRightsModule", "javax.servlet.http.HttpServletRequest:java.lang.Object", "req:reason", "com.wewebu.ow.server.exceptions.OwException", "void"), 264);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onAdd", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISAccessRightsModule", "javax.servlet.http.HttpServletRequest:java.lang.Object", "req:reason", "com.wewebu.ow.server.exceptions.OwException", "void"), 288);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onModify", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISAccessRightsModule", "javax.servlet.http.HttpServletRequest:java.lang.Object", "req:reason", "com.wewebu.ow.server.exceptions.OwException", "void"), 321);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onDelete", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISAccessRightsModule", "javax.servlet.http.HttpServletRequest:java.lang.Object", "req:reason", "com.wewebu.ow.server.exceptions.OwException", "void"), 362);
    }
}

