/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.users;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwGroup;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUser;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUserRepositoryException;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUserRole;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.GetPersonResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.ListGroupsResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.ListPeopleResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.OwRestException;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.dao.GroupInstance;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.dao.GroupsList;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.dao.Person;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.dao.PersonsList;
import com.wewebu.ow.server.ecmimpl.opencmis.users.info.OwCMISAlfrescoUserInfo;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.apache.log4j.Logger;

public class OwUsersRepositoryAlfresco
implements OwUsersRepository {
    private static final Logger LOG = OwLog.getLogger(OwUsersRepositoryAlfresco.class);
    private AlfrescoRESTFulFactory restFactory;

    public OwUsersRepositoryAlfresco(String baseURL, String userName, String password) {
    }

    public OwUsersRepositoryAlfresco(OwAuthenticationConfiguration conf, OwRestletAuthenticationHandler authHandler) {
        this.restFactory = new AlfrescoRESTFulFactory(conf, authHandler);
    }

    @Override
    public OwUserInfo findUserByID(String id) throws OwUserRepositoryException {
        try {
            GetPersonResource resource = this.restFactory.getPersonResource(id);
            Person result = resource.getPerson();
            return new OwCMISAlfrescoUserInfo(result, null, this);
        }
        catch (OwRestException restEx) {
            LOG.error((Object)("Could not get user by Id = " + id), (Throwable)((Object)restEx));
            throw new OwUserRepositoryException((Throwable)((Object)restEx));
        }
    }

    @Override
    public Set<OwGroup> findGroupsMatching(String pattern) throws OwUserRepositoryException {
        try {
            ListGroupsResource resource = this.restFactory.listGroupsResource(pattern);
            GroupsList result = resource.list();
            LinkedHashSet<OwGroup> groups = new LinkedHashSet<OwGroup>();
            GroupInstance[] groupInstanceArray = result.data;
            int n = result.data.length;
            int n2 = 0;
            while (n2 < n) {
                GroupInstance groupInstance = groupInstanceArray[n2];
                OwGroup group = new OwGroup(groupInstance.getFullName(), groupInstance.getDisplayName());
                groups.add(group);
                ++n2;
            }
            return groups;
        }
        catch (OwRestException restEx) {
            LOG.error((Object)"Could not fire group search", (Throwable)((Object)restEx));
            throw new OwUserRepositoryException((Throwable)((Object)restEx));
        }
    }

    @Override
    public Set<OwGroup> findGroupsForUserID(String id) throws OwUserRepositoryException {
        try {
            GetPersonResource resource = this.restFactory.getPersonResource(id);
            Person result = resource.getPerson();
            HashSet<OwGroup> groups = new HashSet<OwGroup>();
            Person.Group[] personGroups = result.getGroups();
            if (personGroups != null) {
                Person.Group[] groupArray = personGroups;
                int n = personGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    Person.Group personGroup = groupArray[n2];
                    groups.add(new OwGroup(personGroup.getItemName(), personGroup.getDisplayName()));
                    ++n2;
                }
            }
            return groups;
        }
        catch (OwRestException restEx) {
            LOG.error((Object)("Could not get Groups for user " + id), (Throwable)((Object)restEx));
            throw new OwUserRepositoryException((Throwable)((Object)restEx));
        }
    }

    @Override
    public OwObjectCollection findUsersMatching(String pattern) throws OwUserRepositoryException {
        try {
            Person[] persons;
            ArrayList<OwUser> users = new ArrayList<OwUser>();
            ListPeopleResource resource = this.restFactory.getPeopleResource(pattern);
            PersonsList result = resource.list();
            Person[] personArray = persons = result.people;
            int n = persons.length;
            int n2 = 0;
            while (n2 < n) {
                Person person = personArray[n2];
                users.add(new OwUser(person.getUserName(), String.valueOf(person.getFirstName()) + " " + person.getLastName(), this));
                ++n2;
            }
            OwStandardObjectCollection usersCollection = new OwStandardObjectCollection();
            usersCollection.addAll(users);
            return usersCollection;
        }
        catch (OwRestException restEx) {
            LOG.error((Object)("Could not find Users matching " + pattern), (Throwable)((Object)restEx));
            throw new OwUserRepositoryException((Throwable)((Object)restEx));
        }
    }

    @Override
    public Set<OwUserRole> findRolesMatching(String pattern) throws OwUserRepositoryException {
        LinkedHashSet<OwUserRole> roles = new LinkedHashSet<OwUserRole>();
        Set<OwGroup> groups = this.findGroupsMatching(pattern);
        for (OwGroup group : groups) {
            OwUserRole role = new OwUserRole(group.getId(), group.getName());
            roles.add(role);
        }
        return roles;
    }
}

