/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco;

import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.GetPersonResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.ListGroupsResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.ListPeopleResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.OwRestException;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.apache.log4j.Logger;
import org.restlet.resource.ClientResource;

public class AlfrescoRESTFulFactory {
    private static Logger LOG = OwLog.getLogger(AlfrescoRESTFulFactory.class);
    private String baseURL;
    private String findUserUri;
    private String findGroupsUri;
    private String userInfoUri;
    private OwRestletAuthenticationHandler authHandler;

    public AlfrescoRESTFulFactory(OwAuthenticationConfiguration conf, OwRestletAuthenticationHandler authHandler) {
        this.baseURL = conf.getConfiguration().getSafeTextValue("BaseURL", "");
        this.findGroupsUri = String.valueOf(this.baseURL) + conf.getConfiguration().getSafeTextValue("FindGroupsURI", "/service/api/groups?shortNameFilter=%s");
        this.findUserUri = String.valueOf(this.baseURL) + conf.getConfiguration().getSafeTextValue("FindUserURI", "/service/api/people?filter=%s");
        this.userInfoUri = String.valueOf(this.baseURL) + conf.getConfiguration().getSafeTextValue("UserInfoURI", "/service/api/people/%s?groups=true");
        this.authHandler = authHandler;
    }

    public ListGroupsResource listGroupsResource(String shortNameFilter) throws OwRestException {
        String resourceURI = String.format(this.findGroupsUri, this.encodeValue(shortNameFilter));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("listGroupsResource call = " + resourceURI));
        }
        return this.createResourceFor(resourceURI, ListGroupsResource.class);
    }

    public ListPeopleResource getPeopleResource(String filterQuery) throws OwRestException {
        String resourceURI = String.format(this.findUserUri, this.encodeValue(filterQuery));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPeopleResource call = " + resourceURI));
        }
        return this.createResourceFor(resourceURI, ListPeopleResource.class);
    }

    public GetPersonResource getPersonResource(String userName) throws OwRestException {
        String resourceURI = String.format(this.userInfoUri, this.encodeValue(userName));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPersonResource call = " + resourceURI));
        }
        return this.createResourceFor(resourceURI, GetPersonResource.class);
    }

    private String encodeValue(String aStringValue) throws OwRestException {
        String encodeValue = null;
        try {
            encodeValue = URLEncoder.encode(aStringValue, "UTF-8");
            encodeValue = encodeValue.replaceAll("[+]", "%20");
        }
        catch (UnsupportedEncodingException encEx) {
            throw new OwRestException("Could not encode the filter!", encEx);
        }
        return encodeValue;
    }

    private <T> T createResourceFor(String resourceURI, Class<T> wrappedClass) throws OwRestException {
        ClientResource cr = new ClientResource(resourceURI);
        this.authHandler.prepareCall(cr);
        cr.getConverterService().setEnabled(true);
        Object resource = cr.wrap(wrappedClass);
        return (T)resource;
    }
}

