/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.wd.service;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISRendition;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.service.rendition.impl.OwAbstractRenditionService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISRenditionService
extends OwAbstractRenditionService {
    private static final Logger LOG;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        OwCMISRenditionService.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISRenditionService.class);
    }

    public InputStream getRenditionStream(OwObject obj, String type) throws IOException, OwException {
        OwObject owObject = obj;
        String string = type;
        try {
            InputStream inputStream;
            block9: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    Set<String> parsedFilter = this.parseFilter(type);
                    List<OwCMISRendition> lst = this.getRenditions(obj, parsedFilter);
                    if (type != null) {
                        for (OwCMISRendition rendition : lst) {
                            for (String filterPart : parsedFilter) {
                                if (!filterPart.equals(rendition.getType()) && !filterPart.equals(rendition.getContentMIMEType()) && !filterPart.matches(rendition.getType())) continue;
                                inputStream = rendition.getContentStream();
                                break block9;
                            }
                        }
                    }
                    inputStream = lst.get(0).getContentStream();
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return inputStream;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)owObject, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public List<String> getRenditionMimeType(OwObject obj, String type) throws OwException {
        OwObject owObject = obj;
        String string = type;
        try {
            LinkedList<String> linkedList;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                List<OwCMISRendition> lst = this.getRenditions(obj, type);
                LinkedList<String> result = new LinkedList<String>();
                for (OwCMISRendition rendition : lst) {
                    result.add(rendition.getContentMIMEType());
                }
                linkedList = result;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return linkedList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)owObject, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public boolean hasRendition(OwObject obj, String type) {
        try {
            return !this.getRenditions(obj, type).isEmpty();
        }
        catch (OwException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Failed to retrieve Renditions for object", (Throwable)e);
            } else {
                LOG.warn((Object)"Failed to retrieve Renditions for object, return false (no renditions).");
            }
            return false;
        }
    }

    private List<OwCMISRendition> getRenditions(OwObject obj, String filter) throws OwException {
        OwObject owObject = obj;
        String string = filter;
        try {
            List<OwCMISRendition> list;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                list = this.getRenditions(obj, this.parseFilter(filter));
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return list;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)owObject, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    private List<OwCMISRendition> getRenditions(OwObject obj, Set<String> filter) throws OwException {
        OwObject owObject = obj;
        Set<String> set = filter;
        try {
            List<OwCMISRendition> list;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISNativeObject cmisObject = (OwCMISNativeObject)obj;
                list = cmisObject.retrieveRenditions(filter, false);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return list;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)owObject, set));
            }
            throw cmisBaseException;
        }
    }

    protected Set<String> parseFilter(String filter) {
        String[] arrFilter;
        if (filter == null) {
            filter = "*";
        }
        HashSet<String> thumbnailRenditions = new HashSet<String>();
        String[] stringArray = arrFilter = filter.split(",");
        int n = arrFilter.length;
        int n2 = 0;
        while (n2 < n) {
            String inFilter = stringArray[n2];
            thumbnailRenditions.add(inFilter);
            ++n2;
        }
        return thumbnailRenditions;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISRenditionService.java", OwCMISRenditionService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRenditionStream", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.lang.String", "obj:type", "java.io.IOException:com.wewebu.ow.server.exceptions.OwException", "java.io.InputStream"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRenditionMimeType", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.lang.String", "obj:type", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRenditions", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.lang.String", "obj:filter", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRenditions", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.util.Set", "obj:filter", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 97);
    }
}

