/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessImageResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;

public class OwAlfrescoBPMContentElement
implements OwContentElement {
    private File file = File.createTempFile("alfContent", ".png");
    private MediaType mediaType;

    public OwAlfrescoBPMContentElement(ProcessImageResource resource) throws IOException, OwException {
        this.file.deleteOnExit();
        new RestCallTemplate<ProcessImageResource, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void execWith(ProcessImageResource resource) throws OwException {
                try {
                    InputRepresentation obj = resource.getImage();
                    OwAlfrescoBPMContentElement.this.mediaType = obj.getMediaType();
                    try (FileOutputStream outputStream = new FileOutputStream(OwAlfrescoBPMContentElement.this.file);){
                        obj.write((OutputStream)outputStream);
                    }
                    return null;
                }
                catch (IOException ex) {
                    throw new OwServerException("Could not make local copy of workflow image.", (Throwable)ex);
                }
            }
        }.doCall(resource);
    }

    public String getContentFilePath() throws Exception {
        return this.file.getAbsolutePath();
    }

    public String getContentURL() throws Exception {
        return null;
    }

    public Object getContentObject() throws Exception {
        return null;
    }

    public int getContentRepresentation() throws Exception {
        return 2;
    }

    public boolean isInputStreamNative() {
        return true;
    }

    public InputStream getContentStream(OutputStream out_p) throws Exception {
        if (out_p == null) {
            return new FileInputStream(this.file);
        }
        FileInputStream in = new FileInputStream(this.file);
        IOUtils.copy((InputStream)in, (OutputStream)out_p);
        return null;
    }

    public int getPageNumber(int lPageIndex_p) throws Exception {
        return 0;
    }

    public String getMIMEType() throws Exception {
        return this.mediaType.toString();
    }

    public String getMIMEParameter() throws Exception {
        return null;
    }

    public void releaseResources() {
        this.file.delete();
    }
}

