/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactory;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import java.lang.reflect.Method;

public class OwAlfrescoBPMProperty
implements OwProperty,
Cloneable {
    private OwPropertyClass propertyClass;
    private Object nativeValue;
    private Object javaValue;
    private NativeValueConverterFactory converterFactory;

    public OwAlfrescoBPMProperty(Object nativeValue, OwPropertyClass propertyClass, NativeValueConverterFactory converterFactory) throws OwException {
        this.converterFactory = converterFactory;
        this.propertyClass = propertyClass;
        this.setNativeValue(nativeValue);
    }

    protected OwAlfrescoBPMProperty(Object javaValue, Object nativeValue, OwPropertyClass propertyClass, NativeValueConverterFactory converter) {
        this.converterFactory = converter;
        this.propertyClass = propertyClass;
        this.javaValue = javaValue;
        this.nativeValue = nativeValue;
    }

    private NativeValueConverter getConverter() throws OwException {
        return this.converterFactory.converterFor((OwFieldDefinition)this.propertyClass);
    }

    public Object getValue() throws Exception {
        return this.javaValue;
    }

    public void setValue(Object javaValue) throws Exception {
        if (null == javaValue) {
            this.nativeValue = null;
            this.javaValue = null;
        } else {
            this.nativeValue = this.getConverter().fromJava(javaValue);
            this.javaValue = javaValue;
        }
    }

    private void setNativeValue(Object nativeValue) throws OwException {
        if (null == nativeValue) {
            this.nativeValue = null;
            this.javaValue = null;
        } else {
            this.nativeValue = nativeValue;
            this.javaValue = this.getConverter().fromNative(this.nativeValue);
        }
    }

    public OwFieldDefinition getFieldDefinition() throws Exception {
        return this.propertyClass;
    }

    public OwPropertyClass getPropertyClass() throws Exception {
        return this.propertyClass;
    }

    public boolean isReadOnly(int iContext_p) throws Exception {
        return this.propertyClass.isReadOnly(iContext_p);
    }

    public boolean isHidden(int iContext_p) throws Exception {
        return this.propertyClass.isHidden(iContext_p);
    }

    public Object getNativeObject() throws Exception {
        return this.nativeValue;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OwAlfrescoBPMProperty(((Object[])this.nativeValue).clone(), this.propertyClass, this.converterFactory);
        }
        catch (Exception e) {
            try {
                Method method = this.nativeValue.getClass().getMethod("clone", new Class[0]);
                return new OwAlfrescoBPMProperty(method.invoke(this.nativeValue, new Object[0]), this.propertyClass, this.converterFactory);
            }
            catch (Exception exception) {
                return new OwAlfrescoBPMProperty(this.javaValue, this.nativeValue, this.propertyClass, this.converterFactory);
            }
        }
    }

    public int compareTo(Object obj_p) {
        Object myValue = null;
        Object value2 = null;
        try {
            myValue = this.getValue();
            value2 = ((OwProperty)obj_p).getValue();
            try {
                return ((String)myValue).compareToIgnoreCase((String)value2);
            }
            catch (ClassCastException e) {
                try {
                    return ((Comparable)myValue).compareTo(value2);
                }
                catch (ClassCastException e2) {
                    return myValue.toString().compareToIgnoreCase(value2.toString());
                }
            }
        }
        catch (Exception e) {
            if (myValue == null && value2 == null) {
                return 0;
            }
            return myValue == null ? 1 : -1;
        }
    }

    public String toString() {
        return "Alfresco BPM Property " + this.propertyClass.getClassName();
    }
}

