/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.collections.OwCollectionIterable;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMBaseContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMDMSID;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMGroupQueueContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMInboxContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMLaunchableWorkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMUnassignedContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMUserQueueContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections.ProcessDefinitionsPageFetcher;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstanceEntry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactoryRest;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.WorkflowDescriptionNameComparator;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.apache.log4j.Logger;

public class OwAlfrescoBPMRepository
implements OwWorkitemRepository<OwAlfrescoBPMWorkItem> {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMRepository.class);
    private static final String BASE_URL = "BaseURL";
    private OwNetwork network;
    private OwXMLUtil config;
    private String baseURL;
    private AlfrescoRESTFulFactory restFulFactory;
    private NativeValueConverterFactory valueConverterFactory;
    private Map<Integer, List<OwAlfrescoBPMBaseContainer>> containersByType = new HashMap<Integer, List<OwAlfrescoBPMBaseContainer>>();

    public OwAlfrescoBPMRepository(OwNetwork network_p, OwXMLUtil bpmConfig_p) throws OwConfigurationException {
        this.network = network_p;
        this.config = bpmConfig_p;
        this.init();
    }

    private void init() throws OwConfigurationException {
        OwRestletAuthenticationHandler authHandler;
        this.baseURL = this.config.getSafeTextValue(BASE_URL, null);
        if (null == this.baseURL) {
            throw new OwConfigurationException("Missing BaseURL configuration.");
        }
        try {
            authHandler = (OwRestletAuthenticationHandler)this.network.getInterface(OwRestletAuthenticationHandler.class.getCanonicalName(), null);
        }
        catch (Exception e1) {
            throw new OwConfigurationException("Problem configuring OwAlfrescoBPMRepository", (Throwable)e1);
        }
        if (authHandler == null) {
            throw new OwConfigurationException("Unable to retrieve OwRestletAuthenticationHandler for BPM");
        }
        try {
            TimeZone clientTimeZone = this.getNetwork().getContext().getClientTimeZone();
            this.valueConverterFactory = new NativeValueConverterFactoryRest(clientTimeZone);
            this.restFulFactory = new AlfrescoRESTFulFactory(this.baseURL, authHandler, this.network.getContext().getLocale(), this.valueConverterFactory);
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not create a RESTful factory instance.", (Throwable)e);
        }
        this.initUserQueues();
    }

    private void initUserQueues() {
        ArrayList<OwAlfrescoBPMUserQueueContainer> userQueues = new ArrayList<OwAlfrescoBPMUserQueueContainer>();
        userQueues.add(new OwAlfrescoBPMInboxContainer(this.network, this));
        userQueues.add(new OwAlfrescoBPMUnassignedContainer(this.network, this));
        this.containersByType.put(8226, userQueues);
        ArrayList<OwAlfrescoBPMGroupQueueContainer> groupQueues = new ArrayList<OwAlfrescoBPMGroupQueueContainer>();
        this.containersByType.put(8225, groupQueues);
        try {
            Collection myGroups = this.network.getCredentials().getUserInfo().getGroups();
            for (Object object : myGroups) {
                OwUserInfo groupInfo = (OwUserInfo)object;
                groupQueues.add(new OwAlfrescoBPMGroupQueueContainer(this.network, this, groupInfo));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not initialise Group Containers.", (Throwable)e);
        }
    }

    public void refreshStaticClassdescriptions() throws Exception {
    }

    public boolean canRefreshStaticClassdescriptions() throws Exception {
        return false;
    }

    public OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int iMaxSize_p, int iVersionSelection_p) throws Exception {
        throw new OwNotSupportedException("The Alfresco BPM repository does not suppport PageSearch.");
    }

    public OwObject getObjectFromDMSID(String strDMSID_p, boolean fRefresh_p) throws Exception {
        OwAlfrescoBPMDMSID alfrescoBPMID = new OwAlfrescoBPMDMSID(strDMSID_p);
        String nativeId = alfrescoBPMID.getId();
        TaskInstanceResource res = this.getRestFulFactory().taskInstanceResource(nativeId, null);
        OwAlfrescoBPMWorkItem workItem = (OwAlfrescoBPMWorkItem)new RestCallTemplate<TaskInstanceResource, OwAlfrescoBPMWorkItem>(){

            @Override
            protected OwAlfrescoBPMWorkItem execWith(TaskInstanceResource resource) throws OwException {
                TaskInstanceEntry task = resource.get();
                OwAlfrescoBPMWorkItem result = new OwAlfrescoBPMWorkItem((TaskInstance)task.getEntry(), null, OwAlfrescoBPMRepository.this);
                return result;
            }
        }.doCall(res);
        return workItem;
    }

    public OwObject getObjectFromPath(String strPath_p, boolean fRefresh_p) throws Exception {
        return null;
    }

    public OwObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws Exception {
        return null;
    }

    public Map getObjectClassNames(int[] iTypes_p, boolean fExcludeHiddenAndNonInstantiable_p, boolean fRootOnly_p, OwResource resource_p) throws Exception {
        return null;
    }

    public OwResource getResource(String strID_p) throws Exception {
        return null;
    }

    public Iterator getResourceIDs() throws Exception {
        return null;
    }

    public OwEventManager getEventManager() {
        return null;
    }

    public String getDMSPrefix() {
        return "bpm";
    }

    public void releaseResources() throws Exception {
        this.getRestFulFactory().release();
    }

    public boolean canBatch() {
        return false;
    }

    public OwBatch openBatch() throws OwException {
        return null;
    }

    public void closeBatch(OwBatch batch_p) throws OwException {
    }

    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws Exception, OwObjectNotFoundException {
        return null;
    }

    public Collection getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int iOp_p) throws Exception {
        return null;
    }

    public Collection getWorkitemContainerIDs(boolean fRefresh_p, int iType_p) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        List<OwAlfrescoBPMBaseContainer> containers = this.containersByType.get(iType_p);
        if (null != containers) {
            for (OwAlfrescoBPMBaseContainer container : containers) {
                ids.add(container.getID());
            }
        } else {
            LOG.warn((Object)("Unknown type definition provided. Will return empty Collection, unknown value = " + iType_p));
        }
        return ids;
    }

    public OwWorkitemContainer getWorkitemContainer(String sID_p, int iType_p) throws Exception {
        List<OwAlfrescoBPMBaseContainer> containers = this.containersByType.get(iType_p);
        for (OwAlfrescoBPMBaseContainer container : containers) {
            if (!sID_p.equals(container.getID())) continue;
            return container;
        }
        String msg = "Object not found, Type = " + iType_p + ", ID = " + sID_p;
        LOG.error((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    public String getWorkitemContainerName(String sID_p, int iType_p) throws Exception {
        return null;
    }

    public boolean hasContainer(int iType_p) throws Exception {
        return false;
    }

    public OwWorkitemRepository.OwProxyInfo createProxy() throws Exception, OwNotSupportedException {
        throw new OwNotSupportedException("Proxying is not supported with the Alfresco BPM adapter.");
    }

    public void setProxies(Collection proxies_p, String absentpersonID_p) throws Exception, OwNotSupportedException {
        throw new OwNotSupportedException("Proxying is not supported with the Alfresco BPM adapter.");
    }

    public Collection getProxies(String absentpersonID_p) throws Exception, OwNotSupportedException {
        throw new OwNotSupportedException("Proxying is not supported with the Alfresco BPM adapter.");
    }

    public boolean canProxy() {
        return false;
    }

    public Collection getLaunchableWorkflowDescriptions(Collection attachmentobjects_p) throws Exception {
        OwCollectionIterable<OwAlfrescoBPMWorkflowDescription> definitions = this.getDefaultWorkflowDescriptions();
        HashMap<String, OwAlfrescoBPMWorkflowDescription> definitionsByKey = new HashMap<String, OwAlfrescoBPMWorkflowDescription>();
        for (OwAlfrescoBPMWorkflowDescription definition : definitions) {
            String key = definition.getKey();
            OwAlfrescoBPMWorkflowDescription existingDef = (OwAlfrescoBPMWorkflowDescription)definitionsByKey.get(key);
            if (null == existingDef) {
                definitionsByKey.put(key, definition);
                continue;
            }
            if (existingDef.getVersion() >= definition.getVersion()) continue;
            definitionsByKey.put(key, definition);
        }
        ArrayList result = new ArrayList(definitionsByKey.values());
        Collections.sort(result, new WorkflowDescriptionNameComparator());
        return result;
    }

    private OwCollectionIterable<OwAlfrescoBPMWorkflowDescription> getDefaultWorkflowDescriptions() throws OwException {
        ProcessDefinitionsPageFetcher fetcher = new ProcessDefinitionsPageFetcher(this);
        OwCollectionIterable result = new OwCollectionIterable((OwAbstractPageFetcher)fetcher);
        return result;
    }

    public OwWorkitem createLaunchableItem(OwWorkflowDescription workflowDescription_p, Collection attachmentobjects_p) throws Exception {
        OwAlfrescoBPMLaunchableWorkitemContainer workitemContainer = new OwAlfrescoBPMLaunchableWorkitemContainer(this.network, this);
        OwAlfrescoBPMWorkflowDescription alfrescoWFDescription = (OwAlfrescoBPMWorkflowDescription)workflowDescription_p;
        return workitemContainer.createLaunchableWorkItem(alfrescoWFDescription, attachmentobjects_p);
    }

    public boolean canLaunch() {
        return true;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public OwNetworkContext getContext() {
        return this.network.getContext();
    }

    public AlfrescoRESTFulFactory getRestFulFactory() {
        return this.restFulFactory;
    }

    public OwNetwork getNetwork() {
        return this.network;
    }

    public NativeValueConverterFactory getValueConverterFactory() {
        return this.valueConverterFactory;
    }

    public OwIterable<OwAlfrescoBPMWorkItem> doSearch(OwSearchNode searchClause, OwLoadContext loadContext) throws OwException {
        throw new OwNotSupportedException("The Alfresco BPM repository does not suppport PageSearch.");
    }

    public boolean canPageSearch() {
        return false;
    }
}

