/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections;

import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstancesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Entry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Pagination;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstances;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.restlet.resource.ClientProxy;

public class ContainerChildrenPageFetcher
extends OwAbstractPageFetcher<OwObject> {
    private static final Logger LOG = OwLog.getLogger(ContainerChildrenPageFetcher.class);
    private ResourceProvider<TaskInstancesResource> resourceProvider;
    private OwAlfrescoBPMWorkitemContainer container;

    public ContainerChildrenPageFetcher(OwAlfrescoBPMWorkitemContainer container, long maxNumItems, ResourceProvider<TaskInstancesResource> resourceProvider) {
        super(maxNumItems);
        this.container = container;
        this.resourceProvider = resourceProvider;
    }

    protected OwPage<OwObject> fetchPage(long skipCount) {
        TaskInstancesResource res = this.resourceProvider.createResource(this.maxNumItems, skipCount);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Fetching a new page for %s from %d to %d.", this.container.getName(), skipCount, skipCount + this.maxNumItems));
            }
            return (OwPage)new RestCallTemplate<TaskInstancesResource, OwPage<OwObject>>(){

                @Override
                protected OwPage<OwObject> execWith(TaskInstancesResource resource) throws OwException {
                    TaskInstances tasks = (TaskInstances)resource.list();
                    ArrayList<OwAlfrescoBPMWorkItem> result = new ArrayList<OwAlfrescoBPMWorkItem>();
                    for (Entry instance : tasks.list.getEntries()) {
                        result.add(new OwAlfrescoBPMWorkItem((TaskInstance)instance.getEntry(), ContainerChildrenPageFetcher.this.container, ContainerChildrenPageFetcher.this.container.getBpmRepository()));
                    }
                    Pagination pagination = tasks.list.getPagination();
                    return new OwPage(result, pagination.getTotalItems(), pagination.isHasMoreItems());
                }
            }.doCall(res);
        }
        catch (OwException e) {
            throw new OwAlfrescoBPMException("Could not fetch page.", (Throwable)e);
        }
    }

    public OwAbstractPageFetcher<OwObject> newCopy(int maxNumItems) {
        ContainerChildrenPageFetcher newInstance = new ContainerChildrenPageFetcher(this.container, maxNumItems, this.resourceProvider);
        return newInstance;
    }

    public static interface ResourceProvider<R extends ClientProxy> {
        public R createResource(long var1, long var3);
    }
}

