/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections;

import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessInstanceItemsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Entry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Item;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Items;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Pagination;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ItemsPageFetcher
extends OwAbstractPageFetcher<Item> {
    private static final Logger LOG = OwLog.getLogger(ItemsPageFetcher.class);
    private OwAlfrescoBPMRepository repository;
    private TaskInstance taskInstance;

    public ItemsPageFetcher(OwAlfrescoBPMRepository repository, TaskInstance taskInstance) {
        this(repository, taskInstance, 100L);
    }

    private ItemsPageFetcher(OwAlfrescoBPMRepository repository, TaskInstance taskInstance, long maxNumItems) {
        super(maxNumItems);
        this.repository = repository;
        this.taskInstance = taskInstance;
    }

    protected OwPage<Item> fetchPage(long skipCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Fetching a new page of variables for task  %s, from index %d to %d.", this.taskInstance.getId(), skipCount, skipCount + this.maxNumItems));
        }
        AlfrescoRESTFulFactory restfulFactory = this.repository.getRestFulFactory();
        ProcessInstanceItemsResource resource = restfulFactory.processInstanceItems(this.taskInstance.getProcessId());
        try {
            return (OwPage)new RestCallTemplate<ProcessInstanceItemsResource, OwPage<Item>>(){

                @Override
                protected OwPage<Item> execWith(ProcessInstanceItemsResource resource) throws OwException {
                    try {
                        Items response = (Items)resource.list();
                        ArrayList items = new ArrayList();
                        for (Entry element : response.list.getEntries()) {
                            items.add(element.getEntry());
                        }
                        Pagination pagination = response.list.getPagination();
                        return new OwPage(items, pagination.getTotalItems(), pagination.isHasMoreItems());
                    }
                    catch (Exception ex) {
                        throw new OwServerException("Could not load task items.", (Throwable)ex);
                    }
                }
            }.doCall(resource);
        }
        catch (OwException e) {
            throw new OwAlfrescoBPMException("Could not fetch page.", (Throwable)e);
        }
    }

    public OwAbstractPageFetcher<Item> newCopy(int maxNumItems) {
        return new ItemsPageFetcher(this.repository, this.taskInstance, maxNumItems);
    }
}

