/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections;

import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.ProcessDefinitionStartFormModelResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Entry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Pagination;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.VariableDefinition;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.VariablesDefinitions;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class VariablesDefinitionsPageFetcher
extends OwAbstractPageFetcher<VariableDefinition> {
    private static final Logger LOG = OwLog.getLogger(VariablesDefinitionsPageFetcher.class);
    private OwAlfrescoBPMRepository repository;
    private OwAlfrescoBPMWorkflowDescription workflowDescription;

    public VariablesDefinitionsPageFetcher(OwAlfrescoBPMRepository repository, OwAlfrescoBPMWorkflowDescription workflowDescription) {
        this(repository, workflowDescription, 100L);
    }

    private VariablesDefinitionsPageFetcher(OwAlfrescoBPMRepository repository, OwAlfrescoBPMWorkflowDescription workflowDescription, long maxNumItems) {
        super(maxNumItems);
        this.repository = repository;
        this.workflowDescription = workflowDescription;
    }

    protected OwPage<VariableDefinition> fetchPage(long skipCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Fetching a new page of variables definitions for process  %s, from index %d to %d.", this.workflowDescription.getId(), skipCount, skipCount + this.maxNumItems));
        }
        AlfrescoRESTFulFactory restFulFactory = this.repository.getRestFulFactory();
        ProcessDefinitionStartFormModelResource resource = restFulFactory.processDefinitionStartFormModelResource(this.workflowDescription.getId());
        try {
            return (OwPage)new RestCallTemplate<ProcessDefinitionStartFormModelResource, OwPage<VariableDefinition>>(){

                @Override
                protected OwPage<VariableDefinition> execWith(ProcessDefinitionStartFormModelResource resource) throws OwException {
                    VariablesDefinitions result = (VariablesDefinitions)resource.list();
                    Entry<E>[] entries = result.list.getEntries();
                    ArrayList<VariableDefinition> list = new ArrayList<VariableDefinition>();
                    for (Entry entry : entries) {
                        VariableDefinition variableDef = (VariableDefinition)entry.getEntry();
                        list.add(variableDef);
                    }
                    Pagination pagination = result.list.getPagination();
                    return new OwPage(list, pagination.getTotalItems(), pagination.isHasMoreItems());
                }
            }.doCall(resource);
        }
        catch (OwException e) {
            throw new OwAlfrescoBPMException("Could not fetch page.", (Throwable)e);
        }
    }

    public OwAbstractPageFetcher<VariableDefinition> newCopy(int maxNumItems) {
        return new VariablesDefinitionsPageFetcher(this.repository, this.workflowDescription, maxNumItems);
    }
}

