/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.collections;

import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.RestCallTemplate;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceVariablesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Entry;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Pagination;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Variable;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.Variables;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class VariablesPageFetcher
extends OwAbstractPageFetcher<Variable> {
    private static final Logger LOG = OwLog.getLogger(VariablesPageFetcher.class);
    private OwAlfrescoBPMRepository repository;
    private TaskInstance taskInstance;

    public VariablesPageFetcher(OwAlfrescoBPMRepository repository, TaskInstance taskInstance) {
        this(repository, taskInstance, 100L);
    }

    private VariablesPageFetcher(OwAlfrescoBPMRepository repository, TaskInstance taskInstance, long maxNumItems) {
        super(maxNumItems);
        this.repository = repository;
        this.taskInstance = taskInstance;
    }

    protected OwPage<Variable> fetchPage(long skipCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Fetching a new page of variables for task  %s, from index %d to %d.", this.taskInstance.getId(), skipCount, skipCount + this.maxNumItems));
        }
        AlfrescoRESTFulFactory restFulFactory = this.repository.getRestFulFactory();
        TaskInstanceVariablesResource resource = restFulFactory.taskInstanceVariablesResource(this.taskInstance.getId());
        try {
            return (OwPage)new RestCallTemplate<TaskInstanceVariablesResource, OwPage<Variable>>(){

                @Override
                protected OwPage<Variable> execWith(TaskInstanceVariablesResource resource) throws OwException {
                    Variables result = (Variables)resource.list();
                    ArrayList taskVariables = new ArrayList();
                    for (Entry element : result.list.getEntries()) {
                        taskVariables.add(element.getEntry());
                    }
                    Pagination pagination = result.list.getPagination();
                    return new OwPage(taskVariables, pagination.getTotalItems(), pagination.isHasMoreItems());
                }
            }.doCall(resource);
        }
        catch (OwException e) {
            throw new OwAlfrescoBPMException("Could not fetch page.", (Throwable)e);
        }
    }

    public OwAbstractPageFetcher<Variable> newCopy(int maxNumItems) {
        return new VariablesPageFetcher(this.repository, this.taskInstance, maxNumItems);
    }
}

