/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.exceptions.OwException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientProxy;
import org.restlet.resource.ResourceException;

public abstract class RestCallTemplate<T extends ClientProxy, R> {
    private static final Logger LOG = OwLog.getLogger(RestCallTemplate.class);

    protected abstract R execWith(T var1) throws OwException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R doCall(T resource) throws OwException {
        try {
            R r = this.execWith(resource);
            return r;
        }
        catch (ResourceException resEx) {
            LOG.error((Object)resource.getClientResource().getResponse().getEntityAsText());
            this.onResourceException(resEx, resource);
            R r = null;
            return r;
        }
        finally {
            Representation responseEntity = resource.getClientResource().getResponseEntity();
            if (null != responseEntity) {
                try {
                    responseEntity.exhaust();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                responseEntity.release();
            }
        }
    }

    protected void onResourceException(ResourceException resEx, T resource) throws OwException {
        throw new OwRestException("Could not load workflow descriptions.", resEx);
    }
}

