/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.CMISPropertyAdapter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactory;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class WhereClause {
    private static final Logger LOG = OwLogCore.getLogger(WhereClause.class);
    private List<Criterion> criteria = new LinkedList<Criterion>();

    protected WhereClause() {
    }

    public static WhereClause emptyClause() {
        WhereClause clause = new WhereClause();
        return clause;
    }

    public static WhereClause fromOwSearchNode(OwSearchNode node, NativeValueConverterFactory valueConverterFactory) throws OwRestException {
        WhereClause clause = new WhereClause();
        try {
            if (node.getOperator() != 1) {
                throw new OwRestException("Only simple filters combined with the AND operator are supported for the moment.");
            }
            for (Object objSearchNode : node.getChilds()) {
                Date dateValue;
                OwSearchNode searchNode = (OwSearchNode)objSearchNode;
                OwSearchCriteria criteria = searchNode.getCriteria();
                OwFieldDefinition fieldDefinition = criteria.getFieldDefinition();
                String variableName = CMISPropertyAdapter.variableNameForProperty(fieldDefinition);
                int operator = criteria.getOperator();
                Object value = criteria.getValue();
                if (!variableName.endsWith("bpm_dueDate") || null == (dateValue = (Date)value)) continue;
                boolean ignoreTime = criteria.isIgnoreTime();
                String queryName = "variables/global/" + variableName;
                if (4 == operator) {
                    Criterion criterion1 = WhereClause.criterionFor(queryName, "d:date", 12, dateValue, fieldDefinition, valueConverterFactory, ignoreTime);
                    Criterion criterion2 = WhereClause.criterionFor(queryName, "d:date", 14, dateValue, fieldDefinition, valueConverterFactory, ignoreTime);
                    clause.addCriterion(criterion1);
                    clause.addCriterion(criterion2);
                    continue;
                }
                Criterion criterion = WhereClause.criterionFor(queryName, "d:date", operator, dateValue, fieldDefinition, valueConverterFactory, ignoreTime);
                clause.addCriterion(criterion);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwRestException("Could not process search filter.", e);
        }
        LOG.info((Object)("New where clause created from search node: " + clause.toString()));
        return clause;
    }

    private static Criterion criterionFor(String queryName, String type, int operator, Object value, OwFieldDefinition fieldDefinition, NativeValueConverterFactory valueConverterFactory, boolean ignoreTime) throws OwException {
        Object adjustedValue = value;
        if (value instanceof Date) {
            adjustedValue = WhereClause.adjustDateLimits((Date)value, operator, ignoreTime);
        }
        NativeValueConverter converter = valueConverterFactory.converterFor(fieldDefinition);
        String stringValue = (String)converter.fromJava(adjustedValue);
        String stringOperator = OwSearchOperator.getOperatorDisplaySymbol(null, (int)operator);
        return new Criterion(queryName, type, stringOperator, stringValue);
    }

    private static Date adjustDateLimits(Date value, int operator, boolean ignoreTime) {
        Date dateValue = value;
        if (ignoreTime) {
            if (14 == operator || 8 == operator) {
                dateValue = OwDateTimeUtil.setBeginOfNextDayTime((Date)value);
            } else if (12 == operator || 10 == operator) {
                dateValue = OwDateTimeUtil.setBeginOfDayTime((Date)value);
            }
        }
        return dateValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Criterion> it = this.criteria.iterator();
        while (it.hasNext()) {
            Criterion criterion = it.next();
            sb.append(criterion.toString());
            if (!it.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    public void addCriterion(Criterion criterion) {
        this.criteria.add(criterion);
    }

    public static class Criterion {
        private String variableName;
        private String variableType;
        private String operator;
        private String value;

        public Criterion(String variableName, String variableType, String operator, String value) {
            this.variableName = variableName;
            this.variableType = variableType;
            this.operator = operator;
            this.value = value;
        }

        public String toString() {
            if (null != this.variableType) {
                return String.format("%s %s '%s %s'", this.variableName, this.operator, this.variableType, this.value);
            }
            return String.format("%s %s '%s'", this.variableName, this.operator, this.value);
        }
    }
}

