/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprException;
import com.wewebu.expression.parser.ParseException;
import com.wewebu.expression.parser.TokenMgrError;
import java.util.ArrayList;
import java.util.List;

public abstract class OwExprErrorTable {
    private List m_expressionErrors = new ArrayList();
    private List m_parseErrors = new ArrayList();
    private List m_tokenErrors = new ArrayList();

    protected abstract String currentLocationInfo();

    public void add(OwExprException e_p) {
        this.m_expressionErrors.add(new Error(e_p, this.currentLocationInfo()));
    }

    public final boolean hasErrors() {
        return !this.m_expressionErrors.isEmpty() || !this.m_parseErrors.isEmpty() || !this.m_tokenErrors.isEmpty();
    }

    public int errCount() {
        return this.m_expressionErrors.size() + this.m_parseErrors.size() + this.m_tokenErrors.size();
    }

    public void add(ParseException e_p) {
        this.m_parseErrors.add(e_p);
    }

    public void add(TokenMgrError e_p) {
        this.m_tokenErrors.add(e_p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.errCount() > 0) {
            for (Object error : this.m_tokenErrors) {
                sb.append(((TokenMgrError)error).getMessage());
                sb.append("\n");
            }
            for (Object error : this.m_parseErrors) {
                sb.append(((ParseException)error).getMessage());
                sb.append("\n");
            }
            for (Object error : this.m_expressionErrors) {
                sb.append(((Error)error).toString());
                sb.append("\n");
            }
        } else {
            sb.append("No errors.");
        }
        return sb.toString();
    }

    private static class Error {
        private OwExprException exception;
        private String locationInfo;

        public Error(OwExprException exception_p, String locationInfo_p) {
            this.exception = exception_p;
            this.locationInfo = locationInfo_p;
        }

        public String toString() {
            return this.locationInfo + " : " + this.exception.getMessage();
        }
    }
}

