/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class OwExprScopeValue
extends OwExprValue {
    private OwExprScope m_scope;
    private Map m_scopeProperties = new HashMap();

    public OwExprScopeValue(OwExprScope scope_p) {
        super(OwExprScope.class);
        this.m_scope = scope_p;
        this.m_scopeProperties.put("length", new LengthProperty());
    }

    @Override
    protected Map getValuePropeties() {
        return this.m_scopeProperties;
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(this, v2_p);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprScopeValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public Object toJavaObject(Class javaSuperType_p) throws OwExprEvaluationException {
        if (javaSuperType_p.isArray() || javaSuperType_p.equals(Object.class)) {
            Class targetType = javaSuperType_p.isArray() ? javaSuperType_p.getComponentType() : Object.class;
            int len = this.length();
            Object[] array = (Object[])Array.newInstance(targetType, len);
            for (int i = 0; i < len; ++i) {
                Object javaObject;
                OwExprProperty property = this.at(i);
                OwExprValue value = property.value();
                array[i] = javaObject = value.toJavaObject(targetType);
            }
            return array;
        }
        throw new OwExprEvaluationException("Non-array scope conversions are not allowed!");
    }

    public final OwExprScope solveScope(String name_p) throws OwExprEvaluationException {
        return this.m_scope.property(name_p);
    }

    @Override
    public final OwExprFunction function(String functionName_p, OwExprExpressionType[] argunmentTypes_p) throws OwExprEvaluationException {
        return this.m_scope.function(functionName_p, argunmentTypes_p);
    }

    @Override
    public final OwExprProperty property(String propertyName_p) throws OwExprEvaluationException {
        try {
            return this.m_scope.property(propertyName_p);
        }
        catch (OwExprEvaluationException e) {
            return super.property(propertyName_p);
        }
    }

    @Override
    public OwExprProperty at(int index_p) throws OwExprEvaluationException {
        return this.m_scope.at(index_p);
    }

    @Override
    public int length() throws OwExprEvaluationException {
        return this.m_scope.length();
    }

    public final OwExprScope getScope() {
        return this.m_scope;
    }

    @Override
    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        if (super.hasProperty(propertyName_p)) {
            return true;
        }
        return this.m_scope.hasProperty(propertyName_p);
    }

    public String toString() {
        return "V$" + this.m_scope.toString();
    }

    private class LengthProperty
    extends OwExprScopedProperty {
        private LengthProperty() {
        }

        @Override
        public OwExprType type() throws OwExprEvaluationException {
            return OwExprType.NUMERIC;
        }

        @Override
        public OwExprValue value() throws OwExprEvaluationException {
            return new OwExprNumericValue(OwExprScopeValue.this.m_scope.length());
        }

        @Override
        public Class<?> javaType() throws OwExprEvaluationException {
            return Integer.class;
        }
    }
}

