/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprPrimaryPrefix;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprScopeValue;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprSymbol;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;
import java.util.LinkedList;
import java.util.List;

public class OwExprStaticArray
extends OwExprExpression
implements OwExprPrimaryPrefix,
OwExprScope {
    private List m_expressions = new LinkedList();
    private List m_values = new LinkedList();

    public OwExprStaticArray(OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p) {
        super(symbolTable_p, errorTable_p);
    }

    public void add(OwExprExpression expression_p) {
        this.m_expressions.add(expression_p);
    }

    @Override
    public OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        for (OwExprExpression expression : this.m_expressions) {
            OwExprValue value = expression.evaluate(scope_p);
            this.m_values.add(value);
        }
        return new OwExprScopeValue(this);
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        return new OwExprExpressionType(OwExprType.SCOPE);
    }

    @Override
    public OwExprExpression expression() {
        return this;
    }

    @Override
    public OwExprFunctionSymbol regressToFunction() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Invalid function call on literal " + this);
    }

    @Override
    public OwExprPropertySymbol regressToPorperty() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Invalid property access on static array " + this);
    }

    @Override
    public OwExprSymbolScope regressToScope() throws OwExprTypeMissmatchException {
        OwExprSymbolTable symTable = this.getSymbolTable();
        OwExprSymbol symbol = symTable.addAnonymousSymbol(null, this.m_symbolTable.issueRuntimeSymbolName(), this.type());
        return new OwExprSymbolScope(symbol, this);
    }

    @Override
    public OwExprProperty at(int index_p) throws OwExprEvaluationException {
        final OwExprValue value = (OwExprValue)this.m_values.get(index_p);
        return new OwExprScopedProperty(){

            @Override
            public OwExprType type() throws OwExprEvaluationException {
                return OwExprType.SCOPE;
            }

            @Override
            public OwExprValue value() throws OwExprEvaluationException {
                return value;
            }

            @Override
            public Class<?> javaType() throws OwExprEvaluationException {
                return OwExprValue.class;
            }
        };
    }

    @Override
    public OwExprFunction function(String functionName_p, OwExprExpressionType[] argunmentTyes_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("No such function " + functionName_p + " for static array scope " + this);
    }

    @Override
    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("No such property " + propertyName_p + " for static array scope " + this);
    }

    @Override
    public int length() throws OwExprEvaluationException {
        return this.m_expressions.size();
    }

    @Override
    public OwExprProperty property(String propertyName_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("No such property " + propertyName_p + " for static array scope " + this);
    }

    public String toString() {
        return "{" + this.m_expressions + "}";
    }
}

