/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprDateValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprTimeValue;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class OwExprStringValue
extends OwExprValue {
    private String m_string;
    private Map m_stringPropeties = new HashMap();

    public OwExprStringValue(String string_p) {
        this(string_p, String.class);
    }

    public OwExprStringValue(String string_p, Class<?> javaType_p) {
        super(javaType_p);
        this.m_string = string_p;
        this.m_stringPropeties.put("length", new OwExprScopedProperty(){

            @Override
            public OwExprType type() throws OwExprEvaluationException {
                return OwExprType.NUMERIC;
            }

            @Override
            public OwExprValue value() throws OwExprEvaluationException {
                return new OwExprNumericValue(OwExprStringValue.this.m_string.length());
            }

            @Override
            public Class<?> javaType() throws OwExprEvaluationException {
                return Integer.class;
            }
        });
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(this, v2_p);
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprNumericValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprStringValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprBooleanValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprDateValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprTimeValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    public final boolean equals(Object obj_p) {
        if (obj_p instanceof OwExprStringValue) {
            OwExprStringValue stringObject = (OwExprStringValue)obj_p;
            return this.m_string.equals(stringObject.m_string);
        }
        return false;
    }

    public int hashCode() {
        return this.m_string.hashCode();
    }

    public String getString() {
        return this.m_string;
    }

    public String toString() {
        return "'" + this.m_string + "'";
    }

    @Override
    public final Object toJavaObject(Class javaSuperType_p) throws OwExprEvaluationException {
        return this.m_string;
    }

    @Override
    protected Map getValuePropeties() {
        return this.m_stringPropeties;
    }

    public boolean like(String aString_p) {
        String expr = this.escapeSQLToRegExp(aString_p);
        Pattern pattern = Pattern.compile(expr, 34);
        return pattern.matcher(this.m_string).matches();
    }

    protected String escapeSQLToRegExp(String sqlLike_p) {
        int length = sqlLike_p.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        boolean sqlEscaped = false;
        boolean sqlRange = false;
        for (int i = 0; i < length; ++i) {
            char c = sqlLike_p.charAt(i);
            if (sqlRange) {
                buffer.append(c);
                sqlRange = ']' != c;
                continue;
            }
            if (sqlEscaped) {
                if ("[](){}.*+?$^|#\\".indexOf(c) != -1) {
                    buffer.append("\\");
                }
                buffer.append(c);
                sqlEscaped = false;
                continue;
            }
            if ('%' == c) {
                buffer.append(".*");
            } else if ('_' == c) {
                buffer.append(".?");
            } else if ('!' == c) {
                sqlEscaped = true;
            } else {
                if ("(){}.*+?$^|#\\".indexOf(c) != -1) {
                    buffer.append("\\");
                }
                buffer.append(c);
            }
            sqlRange = '[' == c;
        }
        return buffer.toString();
    }
}

