/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprDateValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprTime;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.util.HashMap;
import java.util.Map;

public class OwExprTimeValue
extends OwExprValue {
    private OwExprTime m_time;
    private Map m_timePropeties = new HashMap();

    public OwExprTimeValue(OwExprTime time_p) {
        this(time_p, OwExprTime.class);
    }

    public OwExprTimeValue(OwExprTime time_p, Class<?> javaType_p) {
        super(javaType_p);
        this.m_time = time_p;
        this.m_timePropeties.put("seconds", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Double(OwExprTimeValue.this.m_time.getSeconds());
            }
        });
        this.m_timePropeties.put("minutes", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Double(OwExprTimeValue.this.m_time.getMinutes());
            }
        });
        this.m_timePropeties.put("hours", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Double(OwExprTimeValue.this.m_time.getHours());
            }
        });
        this.m_timePropeties.put("inDays", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Double(OwExprTimeValue.this.m_time.getInDays());
            }
        });
        this.m_timePropeties.put("inUTCDays", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Double(OwExprTimeValue.this.m_time.getInUTCDays());
            }
        });
        this.m_timePropeties.put("days", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Integer(OwExprTimeValue.this.m_time.getDays());
            }
        });
        this.m_timePropeties.put("months", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Integer(OwExprTimeValue.this.m_time.getMonths());
            }
        });
        this.m_timePropeties.put("years", new TimeProperty(){

            @Override
            protected Number numberValue() {
                return new Integer(OwExprTimeValue.this.m_time.getYears());
            }
        });
    }

    @Override
    protected final Map getValuePropeties() {
        return this.m_timePropeties;
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return v2_p.accept(binaryOperator_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprDateValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprTimeValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprStringValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public Object toJavaObject(Class javaSuperType_p) throws OwExprEvaluationException {
        return this.m_time;
    }

    public final OwExprTime getTime() {
        return this.m_time;
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwExprTimeValue) {
            OwExprTimeValue timeObject = (OwExprTimeValue)obj_p;
            return this.m_time.equals(timeObject.m_time);
        }
        return false;
    }

    public int hashCode() {
        return this.m_time.hashCode();
    }

    public String toString() {
        return this.m_time.toString();
    }

    private abstract class TimeProperty
    extends OwExprScopedProperty {
        private TimeProperty() {
        }

        @Override
        public OwExprType type() throws OwExprEvaluationException {
            return OwExprType.NUMERIC;
        }

        @Override
        public OwExprValue value() throws OwExprEvaluationException {
            return new OwExprNumericValue(this.numberValue());
        }

        protected abstract Number numberValue();

        @Override
        public Class<?> javaType() throws OwExprEvaluationException {
            return Number.class;
        }
    }
}

