/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Parameter;
import org.restlet.security.Enroler;
import org.restlet.security.Verifier;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Realm {
    private volatile String name;
    private final Series<Parameter> parameters;
    private volatile Enroler enroler;
    private volatile Verifier verifier;
    private volatile boolean started;

    public Realm() {
        this(null, null);
    }

    public Realm(Verifier verifier, Enroler enroler) {
        this.enroler = enroler;
        this.verifier = verifier;
        this.parameters = new Series<Parameter>(Parameter.class, new CopyOnWriteArrayList());
        this.started = false;
    }

    public Enroler getEnroler() {
        return this.enroler;
    }

    public String getName() {
        return this.name;
    }

    public Series<Parameter> getParameters() {
        return this.parameters;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void setEnroler(Enroler enroler) {
        this.enroler = enroler;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(Series<Parameter> parameters) {
        Series<Parameter> series = this.getParameters();
        synchronized (series) {
            if (parameters != this.getParameters()) {
                this.getParameters().clear();
                if (parameters != null) {
                    this.getParameters().addAll(parameters);
                }
            }
        }
    }

    public void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }

    public String toString() {
        return this.getName();
    }
}

