/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc;

import com.wewebu.ow.csqlc.OwCSQLCException;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwANDBooleanTerm;
import com.wewebu.ow.csqlc.ast.OwBetweenPredicate;
import com.wewebu.ow.csqlc.ast.OwBooleanFactor;
import com.wewebu.ow.csqlc.ast.OwBooleanTerm;
import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwComparisonOperator;
import com.wewebu.ow.csqlc.ast.OwComparisonPredicate;
import com.wewebu.ow.csqlc.ast.OwCompoundSelectList;
import com.wewebu.ow.csqlc.ast.OwCorrelatedTableName;
import com.wewebu.ow.csqlc.ast.OwExternal;
import com.wewebu.ow.csqlc.ast.OwFolderPredicate;
import com.wewebu.ow.csqlc.ast.OwFolderPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwFromClause;
import com.wewebu.ow.csqlc.ast.OwInPredicate;
import com.wewebu.ow.csqlc.ast.OwInValueList;
import com.wewebu.ow.csqlc.ast.OwJoinSpecification;
import com.wewebu.ow.csqlc.ast.OwLikePredicate;
import com.wewebu.ow.csqlc.ast.OwLiteral;
import com.wewebu.ow.csqlc.ast.OwMergeType;
import com.wewebu.ow.csqlc.ast.OwNullLiteral;
import com.wewebu.ow.csqlc.ast.OwNullPredicate;
import com.wewebu.ow.csqlc.ast.OwORSearchCondition;
import com.wewebu.ow.csqlc.ast.OwOrderByClause;
import com.wewebu.ow.csqlc.ast.OwPredicate;
import com.wewebu.ow.csqlc.ast.OwPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwQuantifiedComparisonPredicate;
import com.wewebu.ow.csqlc.ast.OwQuantifiedInPredicate;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.csqlc.ast.OwRepositoryTarget;
import com.wewebu.ow.csqlc.ast.OwSQLDateTimeLiteral;
import com.wewebu.ow.csqlc.ast.OwSearchCondition;
import com.wewebu.ow.csqlc.ast.OwSearchConditionBooleanTest;
import com.wewebu.ow.csqlc.ast.OwSearchConditionPredicate;
import com.wewebu.ow.csqlc.ast.OwSelectAll;
import com.wewebu.ow.csqlc.ast.OwSelectList;
import com.wewebu.ow.csqlc.ast.OwSelectSublist;
import com.wewebu.ow.csqlc.ast.OwSignedNumericLiteral;
import com.wewebu.ow.csqlc.ast.OwSimpleTable;
import com.wewebu.ow.csqlc.ast.OwSortSpecification;
import com.wewebu.ow.csqlc.ast.OwStringImageLiteral;
import com.wewebu.ow.csqlc.ast.OwTextSearchPredicate;
import com.wewebu.ow.csqlc.ast.OwUndefinedPredicate;
import com.wewebu.ow.csqlc.ast.OwValueExpression;
import com.wewebu.ow.csqlc.ast.OwWhereClause;
import com.wewebu.ow.csqlc.ast.OwXBooleanFactor;
import com.wewebu.ow.server.ecm.OwClass;
import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.ecm.OwSearchPath;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;

public abstract class OwCSQLCProcessor {
    private static final Logger LOG = OwLogCore.getLogger(OwCSQLCProcessor.class);
    private static final String UNKNOWN_BASE_CLASS = "unknown";
    protected OwSQLEntitiesResolver m_entitiesResolver;
    private Integer maxRows;

    public OwCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p) {
        this.m_entitiesResolver = entitiesResolver_p;
    }

    public OwCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p, Integer maxRows) {
        this.m_entitiesResolver = entitiesResolver_p;
        this.maxRows = maxRows;
    }

    protected String createQueryFieldName(OwFieldDefinition fieldDefinition_p, OwProcessContext context_p) throws OwException {
        String fieldClassName = fieldDefinition_p.getClassName();
        String queryName = this.m_entitiesResolver.resovleQueryColumnName(context_p.mainType, fieldClassName, context_p.repositoryID);
        if (queryName == null) {
            String message = "The filed definition " + fieldClassName + " is not queryable! ";
            LOG.error((Object)("OwCSQLCProcessor.createQueryFieldName():" + message));
            throw new OwInvalidOperationException(new OwString1("ecmimpl.OwCSQLCProcessor.non.queryable.field.error", "Invalid searched field! The field %1 can not be queried!", fieldClassName));
        }
        return queryName;
    }

    protected abstract OwColumnQualifier createQueryFieldQualifier(OwFieldDefinition var1, OwProcessContext var2) throws OwException;

    protected abstract OwColumnQualifier createColumnQualifier(String var1, String var2) throws OwException;

    private String createQueryPropertyName(String tableName_p, String propertyName_p, String repositoryID_p) throws OwException {
        String queryName = this.m_entitiesResolver.resovleQueryColumnName(tableName_p, propertyName_p, repositoryID_p);
        return queryName;
    }

    public final OwExternal<List<OwQueryStatement>> createSQLStatements(OwSearchNode searchRootNode_p, Collection<String> propertyQueryNames_p, OwSort sortOrder_p) throws OwException {
        return this.createSQLStatements(searchRootNode_p, propertyQueryNames_p, sortOrder_p, 1);
    }

    public OwExternal<List<OwQueryStatement>> createSQLStatements(OwSearchNode searchRootNode_p, Collection<String> propertyQueryNames_p, OwSort sortOrder_p, int versionSelection_p) throws OwException {
        LinkedList<OwQueryStatement> statements = new LinkedList<OwQueryStatement>();
        OwExternal<Map<OwRepositoryTarget, List<OwSimpleTable>>> tablesEx = this.createSimpleTable(searchRootNode_p, propertyQueryNames_p, versionSelection_p);
        Map<OwRepositoryTarget, List<OwSimpleTable>> simpleTables = tablesEx.getInternal();
        OwExternal<List<OwQueryStatement>> statementsEx = new OwExternal<List<OwQueryStatement>>(statements, tablesEx);
        Set<Map.Entry<OwRepositoryTarget, List<OwSimpleTable>>> tableEntries = simpleTables.entrySet();
        for (Map.Entry<OwRepositoryTarget, List<OwSimpleTable>> tableEntry : tableEntries) {
            OwRepositoryTarget repositoryTarget = tableEntry.getKey();
            List<OwSimpleTable> repositorySimpleTables = tableEntry.getValue();
            HashSet<String> allTypes = new HashSet<String>();
            for (OwSimpleTable simpleTable : repositorySimpleTables) {
                OwColumnQualifier tableQ = simpleTable.getMainTableQualifier();
                allTypes.add(tableQ.getTargetObjectType());
            }
            for (OwSimpleTable table : repositorySimpleTables) {
                String repositoryID = repositoryTarget.getRepositoryId();
                OwColumnQualifier mainTableQ = table.getMainTableQualifier();
                String tableType = mainTableQ.getTargetObjectType();
                HashSet<String> extraTypes = new HashSet<String>(allTypes);
                extraTypes.remove(tableType);
                OwProcessContext context = new OwProcessContext(repositoryID, tableType, extraTypes);
                OwOrderByClause orderBy = this.createOrderByClause(sortOrder_p, context);
                OwQueryStatement statement = new OwQueryStatement(repositoryTarget, table, orderBy);
                this.joinNormalizedTables(statement, repositoryID, this.qualifySingleTable(searchRootNode_p, statement));
                statements.add(statement);
            }
        }
        return statementsEx;
    }

    protected boolean qualifySingleTable(OwSearchNode searchRootNode_p, OwQueryStatement statement_p) throws OwException {
        return false;
    }

    private void joinNormalizedTables(OwQueryStatement statement_p, String repositoryID_p, boolean qualifySingleTable_p) throws OwException {
        OwColumnQualifier mainTable;
        List<OwColumnQualifier> qs = statement_p.getColumnQualifiers();
        Set<OwColumnQualifier> normalizedQualifiers = this.enforceQualifiers(qs, mainTable = statement_p.getMainTableQualifier(), repositoryID_p, qualifySingleTable_p);
        if (!normalizedQualifiers.contains(mainTable)) {
            LOG.error((Object)"OwCSQLCProcessor.joinNormalizedTables(): Sublcass and where  missmatch !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
        }
        for (OwColumnQualifier qualifier : normalizedQualifiers) {
            if (mainTable.equals(qualifier)) continue;
            String table = qualifier.getTargetTable();
            OwCorrelatedTableName joinedTableReference = new OwCorrelatedTableName(table, qualifier);
            OwColumnReference joinSpecC1 = this.createColumnReference(mainTable, this.createJoinColumnName(mainTable));
            OwColumnReference joinSpecC2 = this.createColumnReference(qualifier, this.createJoinColumnName(qualifier));
            OwJoinSpecification joinSpec = new OwJoinSpecification(joinSpecC1, joinSpecC2, this.joinType(joinedTableReference));
            statement_p.addJoin(joinedTableReference, joinSpec);
        }
        statement_p.setNormalizedQualifiers(normalizedQualifiers);
    }

    protected abstract String joinType(OwCorrelatedTableName var1);

    protected abstract String createJoinColumnName(OwColumnQualifier var1);

    private OwOrderByClause createOrderByClause(OwSort sortOrder_p, OwProcessContext context_p) throws OwException {
        if (sortOrder_p != null) {
            OwOrderByClause orderByClause = new OwOrderByClause();
            Iterator<OwSort.OwSortCriteria> itsort = sortOrder_p.getPrioritizedIterator();
            while (itsort.hasNext()) {
                OwSort.OwSortCriteria sortCrit = itsort.next();
                String propertyName = sortCrit.getPropertyName();
                String queryPropertyName = this.createQueryPropertyName(context_p.mainType, propertyName, context_p.repositoryID);
                OwColumnQualifier columnQualifier = this.createColumnQualifier(propertyName, context_p.repositoryID);
                if (columnQualifier == null) {
                    columnQualifier = this.createColumnQualifier(context_p.mainType, context_p.repositoryID);
                }
                String targetType = columnQualifier.getTargetObjectType();
                boolean isSortTarget = true;
                if (!this.m_entitiesResolver.isSubtable(targetType, context_p.mainType, context_p.repositoryID)) {
                    for (String xType : context_p.extraTypes) {
                        if (!this.m_entitiesResolver.isSubtable(targetType, xType, context_p.repositoryID)) continue;
                        isSortTarget = false;
                        break;
                    }
                }
                if (queryPropertyName != null && isSortTarget) {
                    if (this.m_entitiesResolver.canOrderBy(context_p.mainType, propertyName, context_p.repositoryID)) {
                        boolean ascFlag = sortCrit.getAscFlag();
                        OwColumnReference columnReference = this.createColumnReference(columnQualifier, queryPropertyName);
                        OwSortSpecification sortSpecification = new OwSortSpecification(columnReference, ascFlag);
                        orderByClause.add(sortSpecification);
                        continue;
                    }
                    LOG.debug((Object)("OwCSQLCProcessor.createOrderByClause(): the order by sort specification on " + propertyName + " was ommited ( not orderable)."));
                    continue;
                }
                LOG.debug((Object)("OwCSQLCProcessor.createOrderByClause(): the order by sort specification on " + propertyName + " was ommited ( not queryable or external)."));
            }
            return orderByClause;
        }
        return null;
    }

    protected OwSearchCondition createSubclassesConditions(List<OwClass> subclasses_p) throws OwException {
        return new OwUndefinedPredicate();
    }

    private OwExternal<Map<OwRepositoryTarget, OwSearchCondition>> createRepositoryPathConditions(OwSearchNode specialNodeExt_p) throws OwException {
        List specialChildren = specialNodeExt_p.getChilds();
        Iterator itSpecial = specialChildren.iterator();
        HashMap<OwRepositoryTarget, OwSearchCondition> repositoryFolderConditions = new HashMap<OwRepositoryTarget, OwSearchCondition>();
        HashMap<String, OwRepositoryTarget> mergedTargets = new HashMap<String, OwRepositoryTarget>();
        OwExternal<Map<OwRepositoryTarget, OwSearchCondition>> paths = new OwExternal<Map<OwRepositoryTarget, OwSearchCondition>>(repositoryFolderConditions);
        while (itSpecial.hasNext()) {
            OwSearchNode node = (OwSearchNode)itSpecial.next();
            OwSearchCriteria crit = node.getCriteria();
            if (!crit.getClassName().equals("OwSearchPath")) continue;
            OwSearchPath path = (OwSearchPath)crit.getValue();
            OwSearchObjectStore objectStore = path.getObjectStore();
            String repositoryID = objectStore.getId();
            if (repositoryID == null) {
                repositoryID = this.m_entitiesResolver.resolveRepositoryID(objectStore.getName());
            }
            if (this.m_entitiesResolver.isInternalRepositoryID(repositoryID)) {
                OwPredicate folderPredicate = null;
                if (path.isObjectStoreReference()) {
                    folderPredicate = new OwUndefinedPredicate();
                } else {
                    String pathFolderId = path.getId();
                    if (pathFolderId == null) {
                        pathFolderId = this.m_entitiesResolver.resolveQueryFolderId(repositoryID, path.getPathName());
                    }
                    folderPredicate = this.createFolderPredicate(crit, pathFolderId, path.isSearchSubFolders());
                }
                OwMergeType mergeType = OwMergeType.fromCriteriaOperator(crit.getOperator());
                OwRepositoryTarget mergedTarget = (OwRepositoryTarget)mergedTargets.get(repositoryID);
                if (mergedTarget == null) {
                    mergedTarget = new OwRepositoryTarget(repositoryID, mergeType);
                } else {
                    OwSearchCondition condition = (OwSearchCondition)repositoryFolderConditions.remove(mergedTarget);
                    OwMergeType mergedMergeType = mergedTarget.getMergeType();
                    if (OwMergeType.NONE.equals((Object)mergedMergeType)) {
                        mergedTarget = new OwRepositoryTarget(repositoryID, mergeType);
                    } else if (!OwMergeType.NONE.equals((Object)mergeType) && !mergedMergeType.equals((Object)mergeType)) {
                        LOG.error((Object)("OwCSQLCProcessor.createRepositoryPathConditions(): merge type conflict for repository  " + repositoryID + " : " + mergeType.toString() + " <> " + mergedMergeType.toString()));
                        throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
                    }
                    repositoryFolderConditions.put(mergedTarget, condition);
                }
                mergedTargets.put(repositoryID, mergedTarget);
                OwSearchCondition foldersSearchCondition = (OwSearchCondition)repositoryFolderConditions.get(mergedTarget);
                foldersSearchCondition = foldersSearchCondition == null ? folderPredicate : new OwORSearchCondition(foldersSearchCondition, folderPredicate);
                repositoryFolderConditions.put(mergedTarget, foldersSearchCondition);
                continue;
            }
            paths.addExternalObjectStore(repositoryID, objectStore.getName());
        }
        if (repositoryFolderConditions.isEmpty() && paths.hasExternalObjectStores()) {
            paths.setInternal(null);
        }
        return paths;
    }

    protected abstract boolean isMultipleTextSearchSyntax();

    private OwSearchCondition addSubclassesCondition(List<OwClass> subclasses_p, OwSearchCondition searchCondition_p) throws OwException {
        if (subclasses_p == null || subclasses_p.isEmpty()) {
            return searchCondition_p;
        }
        OwSearchConditionBooleanTest folderBasedTest = new OwSearchConditionBooleanTest(searchCondition_p);
        OwSearchCondition subclassesCondition = this.createSubclassesConditions(subclasses_p);
        OwSearchConditionBooleanTest subclassesTest = new OwSearchConditionBooleanTest(subclassesCondition);
        return new OwANDBooleanTerm(subclassesTest, folderBasedTest);
    }

    protected final List<OwClass> subclass(OwClass mainType_p, Map<String, List<OwClass>> typedSubclasses_p, boolean singleMainType_p) {
        String mainBaseClass = mainType_p.getBaseClassName();
        if (mainBaseClass == null) {
            if (singleMainType_p) {
                LinkedList<OwClass> allSubclasses = new LinkedList<OwClass>();
                Collection<List<OwClass>> allSubclassValues = typedSubclasses_p.values();
                for (List<OwClass> list : allSubclassValues) {
                    allSubclasses.addAll(list);
                }
                return allSubclasses;
            }
            return Collections.EMPTY_LIST;
        }
        return typedSubclasses_p.get(mainBaseClass);
    }

    private OwExternal<Map<OwRepositoryTarget, Map<String, OwWhereClause>>> createWhereClauses(OwSearchNode searchRootNode_p, int versionSelection_p) throws OwException {
        OwSearchNode whereRoot = searchRootNode_p.findSearchNode(1);
        HashMap<OwRepositoryTarget, Map<String, OwWhereClause>> whereClauses = new HashMap<OwRepositoryTarget, Map<String, OwWhereClause>>();
        Map<String, List<OwClass>> typedClasses = this.findMainObjectClasses(searchRootNode_p);
        Collection<List<OwClass>> allClasses = typedClasses.values();
        LinkedList<OwClass> classes = new LinkedList<OwClass>();
        for (List<OwClass> typeClasses : allClasses) {
            classes.addAll(typeClasses);
        }
        Map<String, List<OwClass>> typedSubclasses = this.findSelectedObjectClasses(searchRootNode_p, "OwClassSubclasses");
        OwSearchNode pathSpecialNode = searchRootNode_p.findSearchNode(2);
        OwExternal<Map<OwRepositoryTarget, OwSearchCondition>> pathConditions = this.createRepositoryPathConditions(pathSpecialNode);
        Map<OwRepositoryTarget, OwSearchCondition> repositoryFolderConditions = pathConditions.getInternal();
        OwExternal<Map<OwRepositoryTarget, Map<String, OwWhereClause>>> whereClausesEx = new OwExternal<Map<OwRepositoryTarget, Map<String, OwWhereClause>>>(whereClauses, pathConditions);
        if (repositoryFolderConditions == null) {
            return whereClausesEx;
        }
        HashSet extraObjectTypes = new HashSet(classes);
        HashSet<String> extraObjectClassNames = new HashSet<String>();
        for (OwClass clazz : extraObjectTypes) {
            extraObjectClassNames.add(clazz.getClassName());
        }
        for (OwClass mainObjectType : classes) {
            OwSearchCondition contentCondition;
            OwExternal<Map<OwRepositoryTarget, OwSearchCondition>> localPathConditions = this.createRepositoryPathConditions(pathSpecialNode);
            Map<OwRepositoryTarget, OwSearchCondition> localRepositoryFolderConditions = localPathConditions.getInternal();
            extraObjectTypes.remove(mainObjectType);
            OwSearchCondition versionSelectoinCondition = this.createVersionSelectionCondition(searchRootNode_p, versionSelection_p);
            String mainClassName = mainObjectType.getClassName();
            if (!localRepositoryFolderConditions.isEmpty()) {
                Set<Map.Entry<OwRepositoryTarget, OwSearchCondition>> repositoryTargets = localRepositoryFolderConditions.entrySet();
                for (Map.Entry<OwRepositoryTarget, OwSearchCondition> repositoryTarget : repositoryTargets) {
                    OwSearchCondition contentCondition2;
                    String repositoryID = repositoryTarget.getKey().getRepositoryId();
                    OwProcessContext context = new OwProcessContext(repositoryID, mainClassName, extraObjectClassNames);
                    OwSearchCondition searchCondition = this.createSearchCondition(whereRoot, context);
                    if (versionSelectoinCondition != null && this.m_entitiesResolver.isVersionable(mainClassName, repositoryID)) {
                        searchCondition = new OwANDBooleanTerm(searchCondition.asBooleanTest(), new OwSearchConditionBooleanTest(versionSelectoinCondition));
                    }
                    if ((contentCondition2 = this.createContentCondition(searchRootNode_p, context)) != null) {
                        searchCondition = new OwANDBooleanTerm(new OwSearchConditionBooleanTest(searchCondition), new OwSearchConditionBooleanTest(contentCondition2));
                    }
                    OwSearchConditionBooleanTest searchTest = new OwSearchConditionBooleanTest(searchCondition);
                    OwSearchCondition foldersSearchCondition = repositoryTarget.getValue();
                    OwSearchConditionBooleanTest foldersTest = new OwSearchConditionBooleanTest(foldersSearchCondition);
                    OwANDBooleanTerm folderBasedSearchCondition = new OwANDBooleanTerm(foldersTest, searchTest);
                    List<OwClass> subclasses = this.subclass(mainObjectType, typedSubclasses, classes.size() == 1);
                    OwSearchCondition whereCondition = this.addSubclassesCondition(subclasses, folderBasedSearchCondition);
                    this.addWhereClause(whereClauses, repositoryTarget.getKey(), mainClassName, new OwWhereClause(whereCondition));
                }
                continue;
            }
            String defaultRepositoryID = this.m_entitiesResolver.resolveDefaultRepositoryID();
            OwRepositoryTarget defaultRepositoryTarget = new OwRepositoryTarget(defaultRepositoryID, OwMergeType.NONE);
            OwProcessContext context = new OwProcessContext(defaultRepositoryID, mainClassName, extraObjectClassNames);
            OwSearchCondition searchCondition = this.createSearchCondition(whereRoot, context);
            if (versionSelectoinCondition != null && this.m_entitiesResolver.isVersionable(mainClassName, defaultRepositoryID)) {
                searchCondition = new OwANDBooleanTerm(searchCondition.asBooleanTest(), new OwSearchConditionBooleanTest(versionSelectoinCondition));
            }
            if ((contentCondition = this.createContentCondition(searchRootNode_p, context)) != null) {
                searchCondition = new OwANDBooleanTerm(new OwSearchConditionBooleanTest(searchCondition), new OwSearchConditionBooleanTest(contentCondition));
            }
            List<OwClass> subclasses = this.subclass(mainObjectType, typedSubclasses, classes.size() == 1);
            OwSearchCondition whereCondition = this.addSubclassesCondition(subclasses, searchCondition);
            this.addWhereClause(whereClauses, defaultRepositoryTarget, mainClassName, new OwWhereClause(whereCondition));
        }
        return whereClausesEx;
    }

    private final void addWhereClause(Map<OwRepositoryTarget, Map<String, OwWhereClause>> whereClauses_p, OwRepositoryTarget repositoryTarget_p, String mainObjectType_p, OwWhereClause clause_p) {
        Map<String, OwWhereClause> repositoryClauses = whereClauses_p.get(repositoryTarget_p);
        if (repositoryClauses == null) {
            repositoryClauses = new HashMap<String, OwWhereClause>();
            whereClauses_p.put(repositoryTarget_p, repositoryClauses);
        }
        repositoryClauses.put(mainObjectType_p, clause_p);
    }

    protected abstract OwFolderPredicateFormat getFolderPredicateFormat();

    private OwFolderPredicate createFolderPredicate(OwSearchCriteria criteria_p, String pathFolderId_p, boolean inTree_p) {
        OwCharacterStringLiteral folderIDLiteral = this.createLiteral(criteria_p, pathFolderId_p);
        return new OwFolderPredicate(folderIDLiteral, inTree_p, this.getFolderPredicateFormat());
    }

    protected OwSearchCondition createContentCondition(OwSearchNode conditionRootNode_p, OwProcessContext context_p) throws OwException {
        OwSearchNode cbrNode = conditionRootNode_p.findSearchNode(3);
        OwTextSearchPredicate contentCondition = null;
        LinkedList<String> textSearchExpressions = new LinkedList<String>();
        OwSearchCriteria verityCriteria = null;
        if (cbrNode != null) {
            OwSearchNode cbrValueNode = cbrNode;
            Object value = "";
            Iterator itSearch = cbrValueNode.getChilds().iterator();
            while (itSearch.hasNext() && !cbrValueNode.isCriteriaNode()) {
                cbrValueNode = (OwSearchNode)itSearch.next();
            }
            verityCriteria = cbrValueNode.getCriteria();
            value = verityCriteria.getValue();
            if (value != null && value.toString().length() > 0) {
                textSearchExpressions.add(value.toString());
            }
        }
        if (!this.isMultipleTextSearchSyntax()) {
            this.handleSingleContentCondition(conditionRootNode_p, context_p, textSearchExpressions);
        }
        if (!textSearchExpressions.isEmpty()) {
            OwCharacterStringLiteral searchLiteral = this.createContentSearchLiteral(textSearchExpressions, verityCriteria);
            contentCondition = this.createTextSearchPredicate(searchLiteral, null);
        }
        return contentCondition;
    }

    protected void handleSingleContentCondition(OwSearchNode conditionRootNode_p, OwProcessContext context_p, List<String> textSearchExpressions_p) throws OwException {
        Stack<OwSearchNode> nodeStack = new Stack<OwSearchNode>();
        nodeStack.push(conditionRootNode_p);
        while (!nodeStack.isEmpty()) {
            OwSearchCriteria criteria;
            OwSearchNode node = (OwSearchNode)nodeStack.pop();
            List childNodes = node.getChilds();
            if (childNodes != null) {
                nodeStack.addAll(childNodes);
            }
            if ((criteria = node.getCriteria()) == null) continue;
            String expression = null;
            switch (criteria.getOperator()) {
                case 772: {
                    expression = this.createCBRAllExpression(criteria, context_p);
                    break;
                }
                case 776: {
                    expression = this.createCBRInExpression(criteria, context_p);
                    break;
                }
            }
            if (expression == null) continue;
            textSearchExpressions_p.add(expression);
        }
    }

    protected OwCharacterStringLiteral createContentSearchLiteral(List<String> textSearchExpressions_p, OwSearchCriteria criteria_p) {
        StringBuilder commonExpression = new StringBuilder();
        for (String expression : textSearchExpressions_p) {
            if (expression == null || expression.length() <= 0) continue;
            commonExpression.append(expression);
            commonExpression.append(" ");
        }
        if (commonExpression.length() > 0) {
            commonExpression.delete(commonExpression.length() - 1, commonExpression.length());
            return this.createLiteral(criteria_p, commonExpression.toString());
        }
        return null;
    }

    protected OwSearchCondition createVersionSelectionCondition(OwSearchNode searchRootNode_p, int versionSelection_p) throws OwException {
        return null;
    }

    private OwSearchCondition createSearchCondition(OwSearchNode conditionRootNode_p, OwProcessContext context_p) throws OwException {
        if (conditionRootNode_p != null) {
            List criteriaList = conditionRootNode_p.getChilds();
            if (criteriaList != null) {
                switch (conditionRootNode_p.getOperator()) {
                    case 1: {
                        return this.createBooleanTerm(conditionRootNode_p, context_p);
                    }
                    case 2: {
                        OwSearchCondition lastConditoin = null;
                        for (int i = 0; i < criteriaList.size(); ++i) {
                            OwSearchNode factorNode = (OwSearchNode)criteriaList.get(i);
                            OwBooleanTerm term = this.createBooleanTerm(factorNode, context_p);
                            lastConditoin = lastConditoin != null ? new OwORSearchCondition(lastConditoin, term) : term;
                        }
                        return lastConditoin;
                    }
                }
                LOG.error((Object)("OwCSQLCProcessor.createSearchCondition():Invalid template node operator code " + conditionRootNode_p.getOperator()));
                throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
            }
            return this.createBooleanTerm(conditionRootNode_p, context_p);
        }
        return new OwUndefinedPredicate();
    }

    private OwBooleanTerm createBooleanTerm(OwSearchNode termRootNode_p, OwProcessContext context_p) throws OwException {
        List criteriaList = termRootNode_p.getChilds();
        if (criteriaList != null && criteriaList.size() != 0) {
            OwBooleanTerm lastTerm = null;
            for (int i = 0; i < criteriaList.size(); ++i) {
                OwSearchNode factorNode = (OwSearchNode)criteriaList.get(i);
                OwBooleanFactor factor = this.createBooleanFactor(factorNode, context_p);
                lastTerm = lastTerm != null ? new OwANDBooleanTerm(lastTerm, factor) : factor;
            }
            return lastTerm;
        }
        OwBooleanFactor factor = this.createBooleanFactor(termRootNode_p, context_p);
        return factor;
    }

    private OwBooleanFactor createBooleanFactor(OwSearchNode factorRootNode_p, OwProcessContext context_p) throws OwException {
        List criteriaList = factorRootNode_p.getChilds();
        if (criteriaList != null && !criteriaList.isEmpty()) {
            return new OwSearchConditionBooleanTest(this.createSearchCondition(factorRootNode_p, context_p));
        }
        OwSearchCriteria criteria_p = factorRootNode_p.getCriteria();
        OwPredicate predicate = this.createPredicate(criteria_p, context_p);
        List<OwColumnQualifier> columnQualifiers = predicate.getColumnQualifiers();
        for (OwColumnQualifier qualifier : columnQualifiers) {
            String type = qualifier.getTargetObjectType();
            if (type == null || this.m_entitiesResolver.isSubtable(type, context_p.mainType, context_p.repositoryID)) continue;
            for (String extraType : context_p.extraTypes) {
                if (!this.m_entitiesResolver.isSubtable(type, extraType, context_p.repositoryID)) continue;
                return new OwXBooleanFactor(predicate);
            }
        }
        return predicate;
    }

    protected OwComparisonPredicate createComparisonPredicate(OwSearchCriteria criteria_p, OwComparisonOperator comparisonOperator_p, OwProcessContext context_p) throws OwException {
        Object value = this.getLimitForComparisonPredicate(criteria_p, comparisonOperator_p, context_p);
        OwValueExpression valueExpression = this.createValueExpression(criteria_p, context_p);
        OwLiteral literal = this.createLiteral(criteria_p, value);
        OwComparisonPredicate comparisonPredicate = new OwComparisonPredicate(valueExpression, comparisonOperator_p, literal);
        return comparisonPredicate;
    }

    protected Object getLimitForComparisonPredicate(OwSearchCriteria criteria_p, OwComparisonOperator comparisonOperator_p, OwProcessContext context_p) {
        Object value = criteria_p.getValue();
        return value;
    }

    protected abstract OwPredicateFormat getInFormat();

    protected OwInPredicate createInPredicate(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        OwInValueList inListValue = this.createInValueList(criteria_p, true);
        OwInPredicate inPredicate = new OwInPredicate(columnReference, inListValue, negate_p, this.getInFormat());
        return inPredicate;
    }

    protected OwLikePredicate createLikePredicate(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        Object value = criteria_p.getValue();
        String stringValue = null;
        if (value != null) {
            stringValue = this.convertWildCards(criteria_p, value.toString());
        }
        OwCharacterStringLiteral characterLiteral = this.createLiteral(criteria_p, stringValue);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        OwLikePredicate likePredicate = new OwLikePredicate(columnReference, characterLiteral, negate_p, this.createLikeFormat());
        return likePredicate;
    }

    protected abstract OwPredicateFormat createLikeFormat();

    protected OwNullPredicate createNullPredicate(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        OwNullPredicate nullPredicate = new OwNullPredicate(columnReference, negate_p);
        return nullPredicate;
    }

    protected abstract OwPredicateFormat getQuantifiedInFormat();

    protected OwQuantifiedInPredicate createQuantifiedInPredicate(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        OwInValueList inListValue = this.createInValueList(criteria_p, false);
        OwQuantifiedInPredicate quantifiedInPredicate = new OwQuantifiedInPredicate(columnReference, inListValue, negate_p, this.getQuantifiedInFormat());
        return quantifiedInPredicate;
    }

    protected OwBetweenPredicate createBetweenPredicate(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        RangeLimits limits = this.getBetweenPredicateRangeLimits(criteria_p, negate_p, context_p);
        Object v1 = limits.getLeftLimit();
        Object v2 = limits.getRightLimit();
        OwLiteral value1Literal = this.createLiteral(criteria_p, v1);
        OwLiteral value2Literal = this.createLiteral(criteria_p, v2);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        OwBetweenPredicate betweenPredicate = new OwBetweenPredicate(columnReference, value1Literal, value2Literal, negate_p);
        return betweenPredicate;
    }

    protected RangeLimits getBetweenPredicateRangeLimits(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) {
        OwSearchCriteria secondRangeCriteria = criteria_p.getSecondRangeCriteria();
        Object v1 = criteria_p.getValue();
        Object v2 = secondRangeCriteria.getValue();
        return new RangeLimits(v1, v2);
    }

    private OwPredicate createPredicate(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException {
        if (criteria_p == null) {
            return new OwUndefinedPredicate();
        }
        int operator = criteria_p.getOperator();
        if (operator == 0) {
            return new OwUndefinedPredicate();
        }
        Map<Integer, OwComparisonOperator> operatorMap = this.getSQLComparisonOperatorMap();
        OwComparisonOperator comparisonOperator = operatorMap.get(operator);
        if (comparisonOperator != null) {
            return this.createComparisonPredicate(criteria_p, comparisonOperator, context_p);
        }
        if (this.isValidPredicateValue(criteria_p, context_p, operator)) {
            switch (operator) {
                case 274: 
                case 275: {
                    try {
                        OwFieldDefinition fieldDefinition = criteria_p.getFieldDefinition();
                        if (fieldDefinition.isArray()) {
                            return this.createQuantifiedInPredicate(criteria_p, operator == 275, context_p);
                        }
                        return this.createInPredicate(criteria_p, operator == 275, context_p);
                    }
                    catch (OwException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("OwCSQLCProcessor.retrtieveDefinition():Could not retrieve field definition of search criteria " + criteria_p.getClassName()), (Throwable)e);
                        throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.field.error", "Search field error!"), (Throwable)e);
                    }
                }
                case 276: 
                case 277: {
                    return this.createMultiQuantifiedComparisonPredicate(criteria_p, operator == 277, context_p);
                }
                case 6: 
                case 7: {
                    return this.createLikePredicate(criteria_p, operator == 7, context_p);
                }
                case 16: 
                case 17: {
                    return this.createNullPredicate(criteria_p, operator == 17, context_p);
                }
                case 530: 
                case 531: {
                    return this.createBetweenPredicate(criteria_p, operator == 531, context_p);
                }
                case 772: 
                case 776: {
                    if (this.isMultipleTextSearchSyntax()) {
                        switch (operator) {
                            case 776: {
                                return this.createCBRInPredicate(criteria_p, context_p);
                            }
                            case 772: {
                                return this.createCBRAllPredicate(criteria_p, context_p);
                            }
                        }
                        LOG.error((Object)("SQL operator " + operator + " is not processed!"));
                        return new OwUndefinedPredicate();
                    }
                    return new OwUndefinedPredicate();
                }
            }
            return this.createExtendedPredicate(criteria_p, context_p, operator);
        }
        return new OwUndefinedPredicate();
    }

    protected OwPredicate createExtendedPredicate(OwSearchCriteria criteria_p, OwProcessContext context_p, int operator_p) throws OwException {
        LOG.error((Object)("OwCSQLCProcessor.createExtendedPredicate():Can not create SQL predicate for operator with code " + operator_p));
        throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
    }

    protected String createCBRAllExpression(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException {
        LOG.error((Object)"OwCSQLCProcessor.createCBRAllExpression(): The CBR_ALL element is not supported by this processor.");
        throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
    }

    protected OwPredicate createCBRAllPredicate(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException {
        String expression = this.createCBRAllExpression(criteria_p, context_p);
        return this.createTextSearchPredicate(this.createLiteral(criteria_p, expression), null);
    }

    protected abstract OwTextSearchPredicate createTextSearchPredicate(OwCharacterStringLiteral var1, OwColumnReference var2) throws OwException;

    protected String createCBRInExpression(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException {
        LOG.error((Object)"OwCSQLCProcessor.createCBRAllExpression(): The CBR_IN element is not supported by this processor.");
        throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
    }

    protected OwPredicate createCBRInPredicate(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String queryFieldName = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, queryFieldName);
        String expression = this.createCBRInExpression(criteria_p, context_p);
        return this.createTextSearchPredicate(this.createLiteral(criteria_p, expression), columnReference);
    }

    protected abstract OwPredicateFormat getQuantifiedComparisonFormat();

    private OwPredicate createMultiQuantifiedComparisonPredicate(OwSearchCriteria criteria_p, boolean negate_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        Object value = criteria_p.getValue();
        if (value != null && value.getClass().isArray()) {
            Object[] valuesArray = (Object[])value;
            if (valuesArray.length == 0) {
                return new OwUndefinedPredicate();
            }
            OwLiteral literal0 = this.createLiteral(criteria_p, valuesArray[0]);
            OwBooleanTerm condition = new OwQuantifiedComparisonPredicate(literal0, columnReference, negate_p, this.getQuantifiedComparisonFormat());
            for (int i = 1; i < valuesArray.length; ++i) {
                OwLiteral literal = this.createLiteral(criteria_p, valuesArray[i]);
                OwQuantifiedComparisonPredicate qComparison = new OwQuantifiedComparisonPredicate(literal, columnReference, negate_p, this.getQuantifiedComparisonFormat());
                condition = negate_p ? new OwSearchConditionBooleanTest(new OwORSearchCondition(condition, qComparison)) : new OwANDBooleanTerm(condition, qComparison);
            }
            return new OwSearchConditionPredicate(condition);
        }
        OwLiteral literal = this.createLiteral(criteria_p, value);
        return new OwQuantifiedComparisonPredicate(literal, columnReference, negate_p, this.getQuantifiedComparisonFormat());
    }

    private OwInValueList createInValueList(OwSearchCriteria criteria_p, boolean splitString_p) throws OwException {
        Object value = criteria_p.getValue();
        OwInValueList inValueList = new OwInValueList();
        if (value == null) {
            return inValueList;
        }
        if (value.getClass().isArray()) {
            Object[] arrayValue = (Object[])value;
            for (int i = 0; i < arrayValue.length; ++i) {
                OwLiteral literal = this.createLiteral(criteria_p, arrayValue[i]);
                inValueList.addLiteral(literal);
            }
        } else {
            String strValue = value.toString();
            OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
            if (splitString_p) {
                String[] tokens = strValue.split(",");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    Object valueFromString = this.valueFromSrting(fieldDefinition, token);
                    OwLiteral literal = this.createLiteral(criteria_p, valueFromString);
                    inValueList.addLiteral(literal);
                }
            } else {
                Object valueFromString = this.valueFromSrting(fieldDefinition, strValue);
                OwLiteral literal = this.createLiteral(criteria_p, valueFromString);
                inValueList.addLiteral(literal);
            }
        }
        return inValueList;
    }

    private Object valueFromSrting(OwFieldDefinition definition_p, String aString_p) throws OwException {
        try {
            return definition_p.getValueFromString(aString_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("OwCSQLCProcessor.valueFromSrting():Could not create value from String  " + aString_p + " through filed definition " + definition_p.getClassName()), (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.field.error", "Search field error!"), (Throwable)e);
        }
    }

    protected OwFieldDefinition retrieveDefinition(OwSearchCriteria criteria_p) throws OwException {
        try {
            return criteria_p.getFieldDefinition();
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("OwCSQLCProcessor.retrtieveDefinition():Could not retrieve field definition of search criteria " + criteria_p.getClassName()), (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.field.error", "Search field error!"), (Throwable)e);
        }
    }

    private OwValueExpression createValueExpression(OwSearchCriteria criteria_p, OwProcessContext context_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String className = this.createQueryFieldName(fieldDefinition, context_p);
        OwColumnQualifier qualifier = this.createQueryFieldQualifier(fieldDefinition, context_p);
        OwColumnReference columnReference = this.createColumnReference(qualifier, className);
        return columnReference;
    }

    protected OwSQLDateTimeLiteral createLiteral(OwSearchCriteria criteria_p, Date date_p) throws OwCSQLCException {
        return new OwSQLDateTimeLiteral(date_p);
    }

    protected OwSignedNumericLiteral createLiteral(OwSearchCriteria criteria_p, Number number_p) {
        return new OwSignedNumericLiteral(number_p);
    }

    protected OwCharacterStringLiteral createLiteral(OwSearchCriteria criteria_p, String string_p) {
        return new OwCharacterStringLiteral(string_p);
    }

    protected OwLiteral createDefaultLiteral(OwSearchCriteria criteria_p, Object value_p) {
        String stringValue = value_p.toString();
        String wildCardConvertedString = this.convertWildCards(criteria_p, stringValue);
        return new OwStringImageLiteral(wildCardConvertedString);
    }

    protected OwLiteral createNullLiteral() {
        return new OwNullLiteral();
    }

    protected OwLiteral createLiteral(OwSearchCriteria criteria_p, Object value_p) throws OwException {
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        if (value_p == null) {
            return this.createNullLiteral();
        }
        if (value_p instanceof Date) {
            return this.createLiteral(criteria_p, (Date)value_p);
        }
        if (value_p instanceof Number) {
            return this.createLiteral(criteria_p, (Number)value_p);
        }
        if (!value_p.getClass().isArray()) {
            if ("java.lang.String".equals(fieldDefinition.getJavaClassName())) {
                String stringValue = value_p.toString();
                String wildCardConvertedString = this.convertWildCards(criteria_p, stringValue);
                return this.createLiteral(criteria_p, wildCardConvertedString);
            }
            return this.createDefaultLiteral(criteria_p, value_p);
        }
        LOG.error((Object)("OwCSQLCProcessor.createLiteral : Array literals are not valid. Found array value for " + criteria_p.getClassName() + " with operator \"" + OwSearchOperator.getOperatorDisplayString(Locale.ENGLISH, criteria_p.getOperator()) + "\" ."));
        throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
    }

    protected String convertWildCards(OwSearchCriteria criteria_p, String value_p) {
        String value = this.escapeStringValue(value_p);
        Collection wdefs = criteria_p.getWildCardDefinitions();
        if (null == wdefs) {
            return value;
        }
        value = this.escapeNativeWildCardRepresentation(value, wdefs);
        for (OwWildCardDefinition def : wdefs) {
            value = OwString.replaceAll(value, def.getWildCard(), def.getNativeWildCard());
        }
        return value;
    }

    protected abstract String escapeNativeWildCardRepresentation(String var1, Collection<OwWildCardDefinition> var2);

    protected Map<Integer, OwComparisonOperator> getSQLComparisonOperatorMap() {
        HashMap<Integer, OwComparisonOperator> operatorMap = new HashMap<Integer, OwComparisonOperator>();
        operatorMap.put(4, OwComparisonOperator.EQ);
        operatorMap.put(10, OwComparisonOperator.LT);
        operatorMap.put(8, OwComparisonOperator.GT);
        operatorMap.put(14, OwComparisonOperator.LEQ);
        operatorMap.put(12, OwComparisonOperator.GEQ);
        operatorMap.put(5, OwComparisonOperator.NEQ);
        return operatorMap;
    }

    private Set<OwColumnReference> getTableQueryColumns(String class_p, String repositoryID_p) throws OwException {
        String firstClassQName = this.m_entitiesResolver.resolveQueryTableName(class_p, repositoryID_p);
        Set<String> qNames = this.m_entitiesResolver.resolveQueryableColumnNames(class_p, repositoryID_p);
        LinkedHashSet<OwColumnReference> columns = new LinkedHashSet<OwColumnReference>();
        for (String qName : qNames) {
            OwColumnQualifier colmnQualifier = this.createQueryColumnQualifier(firstClassQName, class_p);
            columns.add(this.createColumnReference(colmnQualifier, qName));
        }
        return columns;
    }

    protected abstract OwColumnQualifier createQueryColumnQualifier(String var1, String var2);

    protected OwColumnReference createColumnReference(OwColumnQualifier qualifier_p, String columnName_p) {
        return new OwColumnReference(qualifier_p, columnName_p);
    }

    private OwExternal<Map<OwRepositoryTarget, List<OwSimpleTable>>> createSimpleTable(OwSearchNode searchRootNode_p, Collection<String> propertyNames_p, int versionSelection_p) throws OwException {
        OwExternal<Map<OwRepositoryTarget, Map<String, OwWhereClause>>> whereClausesEx = this.createWhereClauses(searchRootNode_p, versionSelection_p);
        Map<OwRepositoryTarget, Map<String, OwWhereClause>> whereClauses = whereClausesEx.getInternal();
        HashMap<OwRepositoryTarget, LinkedList<OwSimpleTable>> simpleTables = new HashMap<OwRepositoryTarget, LinkedList<OwSimpleTable>>();
        OwExternal<Map<OwRepositoryTarget, List<OwSimpleTable>>> tablesEx = new OwExternal<Map<OwRepositoryTarget, List<OwSimpleTable>>>(simpleTables, whereClausesEx);
        Set<Map.Entry<OwRepositoryTarget, Map<String, OwWhereClause>>> whereEntries = whereClauses.entrySet();
        for (Map.Entry<OwRepositoryTarget, Map<String, OwWhereClause>> whereEntry : whereEntries) {
            OwRepositoryTarget repositoryTarget = whereEntry.getKey();
            String repositoryID = repositoryTarget.getRepositoryId();
            List<OwFromClause> fromClauses = this.createFromClauses(searchRootNode_p, repositoryID);
            for (OwFromClause fromClause : fromClauses) {
                OwSelectList selectList;
                OwColumnQualifier mainTableQ = fromClause.getMainTableQualifier();
                Map<String, OwWhereClause> whereMap = whereEntry.getValue();
                OwWhereClause where = whereMap.get(mainTableQ.getTargetObjectType());
                if (where.isXClause()) continue;
                LinkedHashSet<OwColumnReference> columnNames = new LinkedHashSet<OwColumnReference>();
                if (propertyNames_p != null) {
                    for (String propertyName : propertyNames_p) {
                        String qName;
                        OwColumnQualifier columnQ = this.createColumnQualifier(propertyName, repositoryID);
                        if (columnQ == null) {
                            columnQ = mainTableQ;
                        }
                        if ((qName = this.createQueryPropertyName(mainTableQ.getTargetObjectType(), propertyName, repositoryID)) != null) {
                            columnNames.add(this.createColumnReference(columnQ, qName));
                            continue;
                        }
                        LOG.error((Object)("OwCSQLCProcessor.createSimpleTable(): the property " + propertyName + " is not queryable! It will be ommited from the query!"));
                    }
                }
                Set<OwColumnReference> tableColumns = this.getTableQueryColumns(mainTableQ.getTargetObjectType(), repositoryID);
                columnNames.addAll(tableColumns);
                if (columnNames.isEmpty()) {
                    selectList = new OwSelectAll();
                } else {
                    OwCompoundSelectList compoundSelectList = new OwCompoundSelectList();
                    for (OwColumnReference columnReference : columnNames) {
                        OwSelectSublist subList = new OwSelectSublist(columnReference);
                        compoundSelectList.add(subList);
                    }
                    selectList = compoundSelectList;
                }
                LinkedList<OwSimpleTable> tables = (LinkedList<OwSimpleTable>)simpleTables.get(whereEntry.getKey());
                if (tables == null) {
                    tables = new LinkedList<OwSimpleTable>();
                    simpleTables.put(whereEntry.getKey(), tables);
                }
                tables.add(this.createSimpleTable(selectList, fromClause, where));
            }
        }
        return tablesEx;
    }

    private Set<OwColumnQualifier> enforceQualifiers(List<OwColumnQualifier> qualifiers_p, OwColumnQualifier mainTable_p, String respositoryID_p, boolean qualifySingleTable_p) throws OwException {
        this.createUniqueQualifiers(qualifiers_p, mainTable_p, qualifySingleTable_p);
        Set<OwColumnQualifier> nQualifiers = this.normalizeQualifiers(qualifiers_p, respositoryID_p);
        if (nQualifiers.size() == 1 && !qualifySingleTable_p) {
            for (OwColumnQualifier qualifier : qualifiers_p) {
                qualifier.setQualifierString(null);
            }
        } else if (nQualifiers.size() == 1) {
            OwColumnQualifier oneQualifier = nQualifiers.iterator().next();
            oneQualifier.setQualifierString("a");
        }
        return nQualifiers;
    }

    private Set<OwColumnQualifier> normalizeQualifiers(List<OwColumnQualifier> qualifers_p, String respositoryID_p) throws OwException {
        LinkedHashSet<OwColumnQualifier> normalizedQualifiers = new LinkedHashSet<OwColumnQualifier>();
        for (OwColumnQualifier qualifier : qualifers_p) {
            String qTable = qualifier.getTargetTable();
            LinkedHashSet<OwColumnQualifier> normalizedTablesCopy = new LinkedHashSet<OwColumnQualifier>(normalizedQualifiers);
            boolean ancestryEstablished = false;
            for (OwColumnQualifier nQualifier : normalizedTablesCopy) {
                String nQString = nQualifier.getQualifierString();
                String nQTable = nQualifier.getTargetTable();
                if (!nQTable.equals(qTable)) {
                    if (this.m_entitiesResolver.isSubtable(nQualifier.getTargetObjectType(), qualifier.getTargetObjectType(), respositoryID_p)) {
                        qualifier.setQualifierString(nQString);
                        normalizedQualifiers.remove(nQualifier);
                        normalizedQualifiers.add(qualifier);
                        ancestryEstablished = true;
                    } else if (this.m_entitiesResolver.isSubtable(qualifier.getTargetObjectType(), nQualifier.getTargetObjectType(), respositoryID_p)) {
                        qualifier.setQualifierString(nQString);
                        ancestryEstablished = true;
                    }
                } else {
                    qualifier.setQualifierString(nQString);
                    ancestryEstablished = true;
                }
                if (!ancestryEstablished) continue;
                break;
            }
            if (ancestryEstablished) continue;
            normalizedQualifiers.add(qualifier);
        }
        return normalizedQualifiers;
    }

    private void createUniqueQualifiers(List<OwColumnQualifier> qualifers_p, OwColumnQualifier mainTable_p, boolean qualifySingleTable_p) {
        HashMap<String, String> tableToQ = new HashMap<String, String>();
        LinkedList<OwColumnQualifier> defaults = new LinkedList<OwColumnQualifier>();
        String defaultQualifier = null;
        defaults.add(mainTable_p);
        int nextQualifierIndex = 0;
        for (OwColumnQualifier qualifier : qualifers_p) {
            String table = qualifier.getTargetTable();
            if (table != null && (qualifySingleTable_p || !table.equals(mainTable_p.getTargetTable()))) {
                String q = (String)tableToQ.get(table);
                if (q == null) {
                    q = "" + Character.valueOf((char)(98 + nextQualifierIndex));
                    tableToQ.put(table, q);
                    ++nextQualifierIndex;
                    if (defaultQualifier == null) {
                        defaultQualifier = "a";
                        for (OwColumnQualifier defaultQ : defaults) {
                            defaultQ.setQualifierString(defaultQualifier);
                        }
                    }
                }
                qualifier.setQualifierString(q);
                continue;
            }
            if (table == null) {
                qualifier.setTargetTable(mainTable_p.getTargetTable());
                qualifier.setTargetObjectType(mainTable_p.getTargetObjectType());
            }
            if (defaultQualifier != null) {
                qualifier.setQualifierString(defaultQualifier);
            }
            defaults.add(qualifier);
        }
    }

    protected final Map<String, List<OwClass>> findSelectedObjectClasses(OwSearchNode searchRootNode_p, String criteriaName_p) throws OwException {
        OwSearchNode specialNode = searchRootNode_p.findSearchNode(2);
        List specialChildren = specialNode.getChilds();
        Iterator itSpecial = specialChildren.iterator();
        LinkedHashMap<String, List<OwClass>> typedClasses = new LinkedHashMap<String, List<OwClass>>();
        while (itSpecial.hasNext()) {
            OwSearchNode node = (OwSearchNode)itSpecial.next();
            OwSearchCriteria crit = node.getCriteria();
            if (!crit.getUniqueName().equals(criteriaName_p)) continue;
            Object[] clazz = (Object[])crit.getValue();
            for (int i = 0; i < clazz.length; ++i) {
                if (clazz[i] instanceof OwClass) {
                    LinkedList<OwClass> classes;
                    OwClass classValue = (OwClass)clazz[i];
                    if (!classValue.isEnabled()) continue;
                    String baseClassName = classValue.getBaseClassName();
                    if (0 == classValue.getObjectType()) {
                        baseClassName = UNKNOWN_BASE_CLASS;
                    }
                    if ((classes = (LinkedList<OwClass>)typedClasses.get(baseClassName)) == null) {
                        classes = new LinkedList<OwClass>();
                        typedClasses.put(baseClassName, classes);
                    }
                    classes.add(classValue);
                    continue;
                }
                LOG.error((Object)("OwCSQLCProcessor.findSelectedObjectClasses : invalid class criteria value type " + clazz[i]));
                throw new OwInvalidOperationException("invalid class criteria value type.");
            }
        }
        return typedClasses;
    }

    protected String getMainObjectCriteria() {
        return "OwClassSelectObject";
    }

    protected final Map<String, List<OwClass>> findMainObjectClasses(OwSearchNode searchRootNode_p) throws OwException {
        return this.findSelectedObjectClasses(searchRootNode_p, this.getMainObjectCriteria());
    }

    private List<OwFromClause> createFromClauses(OwSearchNode searchRootNode_p, String repositoryID_p) throws OwException {
        Map<String, List<OwClass>> classes = this.findMainObjectClasses(searchRootNode_p);
        if (classes.isEmpty()) {
            LOG.error((Object)"OwCSQLCProcessor.createFromClauses():no <from> search class was specified !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwCSQLCProcessor.invalid.template.error", "Invalid search template!"));
        }
        Set<Map.Entry<String, List<OwClass>>> classEntries = classes.entrySet();
        LinkedList<OwFromClause> fromClauses = new LinkedList<OwFromClause>();
        for (Map.Entry<String, List<OwClass>> classEntry : classEntries) {
            for (OwClass aClass : classEntry.getValue()) {
                OwCorrelatedTableName correlatedTableName = this.createCorrelatedTableName(aClass.getClassName(), repositoryID_p);
                OwFromClause fromClause = new OwFromClause(correlatedTableName);
                fromClauses.add(fromClause);
            }
        }
        return fromClauses;
    }

    private OwCorrelatedTableName createCorrelatedTableName(String class_p, String repositoryID_p) throws OwException {
        String tableQueryName = this.m_entitiesResolver.resolveQueryTableName(class_p, repositoryID_p);
        if (tableQueryName == null) {
            LOG.error((Object)("OwCSQLCProcessor.createCorrelatedTableName():Object class " + class_p + " is not queryable!"));
            throw new OwInvalidOperationException(new OwString1("ecmimpl.OwCSQLCProcessor.non.queryable.table.error", "Invalid searched class! The class %1 can not be queried!", class_p));
        }
        OwColumnQualifier qualifier = this.createFromTableQualifier(tableQueryName, class_p);
        OwCorrelatedTableName correlatedTableName = new OwCorrelatedTableName(tableQueryName, qualifier);
        return correlatedTableName;
    }

    protected abstract OwColumnQualifier createFromTableQualifier(String var1, String var2);

    protected String escapeStringValue(String value_p) {
        String escaped = value_p.replaceAll("\\\\", "\\\\\\\\");
        escaped = escaped.replaceAll("'", "\\\\'");
        return escaped;
    }

    protected boolean isValidPredicateValue(OwSearchCriteria criteria_p, OwProcessContext context_p, int operator_p) {
        switch (operator_p) {
            case 16: 
            case 17: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 530: 
            case 531: {
                return true;
            }
        }
        return criteria_p.getValue() != null && !"".equals(criteria_p.getValue());
    }

    protected OwSimpleTable createSimpleTable(OwSelectList selectList, OwFromClause fromClause, OwWhereClause where) {
        if (this.getMaxRows() == null) {
            return new OwSimpleTable(selectList, fromClause, where);
        }
        return new OwSimpleTable(selectList, fromClause, where, this.getMaxRows());
    }

    public void setMaxRows(Integer rows) {
        this.maxRows = rows;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    protected class RangeLimits {
        private Object leftLimit;
        private Object rightLimit;

        public RangeLimits(Object leftLimit, Object rightLimit) {
            this.leftLimit = leftLimit;
            this.rightLimit = rightLimit;
        }

        public Object getLeftLimit() {
            return this.leftLimit;
        }

        public Object getRightLimit() {
            return this.rightLimit;
        }
    }

    public static class OwProcessContext {
        public final String repositoryID;
        public final String mainType;
        public final Set<String> extraTypes;

        public OwProcessContext(String repositoryID_p, String mainType_p, Set<String> extraTypes_p) {
            this.repositoryID = repositoryID_p;
            this.mainType = mainType_p;
            this.extraTypes = extraTypes_p;
        }
    }
}

