/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwANDBooleanTerm;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwComparisonOperator;
import com.wewebu.ow.csqlc.ast.OwComparisonPredicate;
import com.wewebu.ow.csqlc.ast.OwLiteral;
import com.wewebu.ow.csqlc.ast.OwORSearchCondition;
import com.wewebu.ow.csqlc.ast.OwPredicate;
import com.wewebu.ow.csqlc.ast.OwSearchCondition;
import com.wewebu.ow.csqlc.ast.OwSearchConditionBooleanTest;
import java.util.LinkedList;
import java.util.List;

public class OwBetweenPredicate
extends OwPredicate {
    private OwLiteral m_value1;
    private OwLiteral m_value2;
    private OwColumnReference m_columnReference;
    private boolean m_negate;

    public OwBetweenPredicate(OwColumnReference columnReference_p, OwLiteral value1_p, OwLiteral value2_p) {
        this(columnReference_p, value1_p, value2_p, false);
    }

    public OwBetweenPredicate(OwColumnReference columnReference_p, OwLiteral value1_p, OwLiteral value2_p, boolean negate_p) {
        this.m_value1 = value1_p;
        this.m_value2 = value2_p;
        this.m_columnReference = columnReference_p;
        this.m_negate = negate_p;
    }

    @Override
    public StringBuilder createPredicateSQLString() {
        if (this.isValid()) {
            OwComparisonOperator v1Operator = this.m_negate ? OwComparisonOperator.LT : OwComparisonOperator.GEQ;
            OwComparisonOperator v2Operator = this.m_negate ? OwComparisonOperator.GT : OwComparisonOperator.LEQ;
            OwComparisonPredicate v1ComparisonPredicate = null;
            OwComparisonPredicate v2ComparisonPredicate = null;
            OwComparisonPredicate uniqueComparisonPredicate = null;
            if (this.m_value1 != null && !this.m_value1.isNull()) {
                v1ComparisonPredicate = new OwComparisonPredicate(this.m_columnReference, v1Operator, this.m_value1);
            }
            if (this.m_value2 != null && !this.m_value2.isNull()) {
                v2ComparisonPredicate = new OwComparisonPredicate(this.m_columnReference, v2Operator, this.m_value2);
            }
            if (v2ComparisonPredicate == null) {
                uniqueComparisonPredicate = v1ComparisonPredicate;
            } else if (v1ComparisonPredicate == null) {
                uniqueComparisonPredicate = v2ComparisonPredicate;
            }
            if (uniqueComparisonPredicate != null) {
                return uniqueComparisonPredicate.createPredicateSQLString();
            }
            OwSearchCondition betweenInnerTerm = this.m_negate ? new OwORSearchCondition(v1ComparisonPredicate, v2ComparisonPredicate) : new OwANDBooleanTerm(v1ComparisonPredicate, v2ComparisonPredicate);
            OwSearchConditionBooleanTest betweenTest = new OwSearchConditionBooleanTest(betweenInnerTerm);
            return betweenTest.createBooleanTestSQLString();
        }
        return new StringBuilder();
    }

    @Override
    public boolean isValid() {
        return this.m_value1 != null && !this.m_value1.isNull() || this.m_value2 != null && !this.m_value2.isNull();
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        if (this.isValid()) {
            return this.m_columnReference.getColumnQualifiers();
        }
        return new LinkedList<OwColumnQualifier>();
    }
}

