/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwLiteral;

public class OwCharacterStringLiteral
implements OwLiteral {
    private String m_characterStringSQLString;

    public OwCharacterStringLiteral(String characterString_p) {
        this.m_characterStringSQLString = characterString_p;
    }

    @Override
    public StringBuilder createLiteralSQLString() {
        StringBuilder builder = new StringBuilder(this.m_characterStringSQLString);
        builder.insert(0, '\'');
        builder.append('\'');
        return builder;
    }

    private StringBuilder createBuilder() {
        String current = this.m_characterStringSQLString == null ? "" : this.m_characterStringSQLString;
        return new StringBuilder(current);
    }

    public OwCharacterStringLiteral append(String characterString_p) {
        StringBuilder builder = this.createBuilder();
        builder.append(characterString_p);
        return new OwCharacterStringLiteral(builder.toString());
    }

    public OwCharacterStringLiteral insert(int offset_p, String characterString_p) {
        StringBuilder builder = this.createBuilder();
        builder.insert(offset_p, characterString_p);
        return new OwCharacterStringLiteral(builder.toString());
    }

    public OwCharacterStringLiteral replace(int start_p, int end_p, String characterString_p) {
        StringBuilder builder = this.createBuilder();
        builder.replace(start_p, end_p, characterString_p);
        return new OwCharacterStringLiteral(builder.toString());
    }

    public boolean contains(char c_p, boolean escaped_p) {
        boolean contains = false;
        if (this.m_characterStringSQLString != null) {
            boolean escaping = false;
            for (int index = 0; index < this.m_characterStringSQLString.length(); ++index) {
                char c = this.m_characterStringSQLString.charAt(index);
                if (c == c_p && escaping == escaped_p) {
                    contains = true;
                    break;
                }
                escaping = c == '\\' && !escaping;
            }
        }
        return contains;
    }

    @Override
    public boolean isNull() {
        return this.m_characterStringSQLString == null || this.m_characterStringSQLString.length() == 0;
    }
}

