/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwBooleanTerm;
import com.wewebu.ow.csqlc.ast.OwBooleanTest;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwSearchCondition;
import com.wewebu.ow.csqlc.ast.OwSearchConditionBooleanTest;
import java.util.LinkedList;
import java.util.List;

public class OwORSearchCondition
implements OwSearchCondition {
    public static final String OR = "OR";
    private OwSearchCondition m_leftSideCondition;
    private OwBooleanTerm m_rightSideTerm;

    public OwORSearchCondition(OwSearchCondition leftSideCondition_p, OwBooleanTerm rightSideTerm_p) {
        this.m_leftSideCondition = leftSideCondition_p;
        this.m_rightSideTerm = rightSideTerm_p;
    }

    @Override
    public StringBuilder createSearchConditionSQLString() {
        boolean left = this.m_leftSideCondition.isValid() && !this.m_leftSideCondition.isXCondition();
        StringBuilder builder = left ? this.m_leftSideCondition.createSearchConditionSQLString() : new StringBuilder();
        if (this.m_rightSideTerm.isValid() && !this.m_rightSideTerm.isXCondition()) {
            if (left) {
                builder.append(" ");
                builder.append(OR);
                builder.append(" ");
            }
            StringBuilder builderRight = this.m_rightSideTerm.createBooleanTermSQLString();
            builder.append((CharSequence)builderRight);
        }
        return builder;
    }

    @Override
    public boolean isValid() {
        return this.m_leftSideCondition.isValid() && !this.m_leftSideCondition.isXCondition() || this.m_rightSideTerm.isValid() && !this.m_rightSideTerm.isXCondition();
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        boolean left;
        LinkedList<OwColumnQualifier> qualifiers = new LinkedList<OwColumnQualifier>();
        boolean bl = left = this.m_leftSideCondition.isValid() && !this.m_leftSideCondition.isXCondition();
        if (left) {
            qualifiers.addAll(this.m_leftSideCondition.getColumnQualifiers());
        }
        if (this.m_rightSideTerm.isValid() && !this.m_rightSideTerm.isXCondition()) {
            qualifiers.addAll(this.m_rightSideTerm.getColumnQualifiers());
        }
        return qualifiers;
    }

    @Override
    public boolean isXCondition() {
        return this.m_rightSideTerm.isXCondition() && this.m_leftSideCondition.isXCondition();
    }

    @Override
    public OwBooleanTest asBooleanTest() {
        return new OwSearchConditionBooleanTest(this);
    }
}

