/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwSortSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OwOrderByClause {
    public static final String ORDER_BY = "ORDER BY";
    private List<OwSortSpecification> m_sortSpecifications = new ArrayList<OwSortSpecification>();

    public void add(OwSortSpecification sortSpecification_p) {
        this.m_sortSpecifications.add(sortSpecification_p);
    }

    public StringBuilder createOrderByClauseSQLString() {
        if (!this.m_sortSpecifications.isEmpty()) {
            OwSortSpecification sortSpecification = this.m_sortSpecifications.get(0);
            StringBuilder builder = sortSpecification.createSortSpecificationSQLString();
            builder.insert(0, " ");
            builder.insert(0, ORDER_BY);
            for (int i = 1; i < this.m_sortSpecifications.size(); ++i) {
                OwSortSpecification specification = this.m_sortSpecifications.get(i);
                builder.append(",");
                builder.append((CharSequence)specification.createSortSpecificationSQLString());
            }
            return builder;
        }
        return new StringBuilder();
    }

    public boolean isValid() {
        return !this.m_sortSpecifications.isEmpty();
    }

    public List<OwColumnQualifier> getColumnQualifiers() {
        LinkedList<OwColumnQualifier> qualifiers = new LinkedList<OwColumnQualifier>();
        if (this.isValid()) {
            for (OwSortSpecification sort : this.m_sortSpecifications) {
                qualifiers.addAll(sort.getColumnQualifiers());
            }
        }
        return qualifiers;
    }
}

