/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.OwCSQLCException;
import com.wewebu.ow.csqlc.ast.OwLiteral;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class OwSQLDateTimeLiteral
implements OwLiteral {
    private String m_dateTimeSQLString = null;

    private static GregorianCalendar toCalendar(Date date_p) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date_p);
        return calendar;
    }

    private static XMLGregorianCalendar toXMLCalendar(GregorianCalendar calendar_p) throws OwCSQLCException {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            return factory.newXMLGregorianCalendar(calendar_p);
        }
        catch (DatatypeConfigurationException e) {
            throw new OwCSQLCException("XMLGregorianCalendar error.", (Throwable)e);
        }
    }

    public OwSQLDateTimeLiteral(Date date_p) throws OwCSQLCException {
        this(OwSQLDateTimeLiteral.toCalendar(date_p));
    }

    public OwSQLDateTimeLiteral(GregorianCalendar calendar_p) throws OwCSQLCException {
        this(OwSQLDateTimeLiteral.toXMLCalendar(calendar_p));
    }

    public OwSQLDateTimeLiteral(XMLGregorianCalendar calendar_p) {
        if (calendar_p != null) {
            String stringCalendar = this.asString(calendar_p);
            this.m_dateTimeSQLString = this.createLiteral(stringCalendar);
        }
    }

    protected String asString(XMLGregorianCalendar calendar_p) {
        return calendar_p.toXMLFormat();
    }

    protected String createLiteral(String dateString_p) {
        return dateString_p;
    }

    @Override
    public StringBuilder createLiteralSQLString() {
        return new StringBuilder(this.m_dateTimeSQLString);
    }

    @Override
    public boolean isNull() {
        return this.m_dateTimeSQLString == null;
    }
}

