/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwManagersConfiguration;
import com.wewebu.ow.server.ao.OwSupportsConfiguration;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import org.apache.log4j.Logger;

public class OwAOConfiguration {
    private static final Logger LOG = OwLogCore.getLogger(OwAOConfiguration.class);
    private OwSupportsConfiguration supportsConfiguration;
    private OwManagersConfiguration managersConfiguration;
    private OwXMLUtil configuration;

    public OwAOConfiguration(OwXMLUtil configuration, OwAOContext context) throws OwConfigurationException {
        this.configuration = configuration;
        try {
            OwXMLUtil suportsConfiguration = configuration.getSubUtil("Supports");
            this.supportsConfiguration = new OwSupportsConfiguration(suportsConfiguration, context);
            OwXMLUtil managersConfiguration = configuration.getSubUtil("Managers");
            this.managersConfiguration = new OwManagersConfiguration(managersConfiguration, this.supportsConfiguration, context);
        }
        catch (OwConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwConfigurationException("Invalid AO configuration.", (Throwable)e);
        }
    }

    public OwAOManager getManager(int type_p) throws OwInvalidOperationException {
        return this.managersConfiguration.getManager(type_p);
    }
}

