/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OwAOConfigurationPart {
    private OwXMLUtil configuration;
    private Map<String, String> parameters = new HashMap<String, String>();

    public OwAOConfigurationPart(OwXMLUtil configuration) throws OwConfigurationException {
        this.configuration = configuration;
        try {
            OwXMLUtil params = configuration.getSubUtil("params");
            if (params != null) {
                List paramList = params.getSafeUtilList("param");
                for (OwXMLUtil param : paramList) {
                    String name = param.getSafeStringAttributeValue("name", null);
                    String value = param.getSafeStringAttributeValue("value", null);
                    this.parameters.put(name, value);
                }
            }
        }
        catch (Exception e) {
            throw new OwConfigurationException("Invalid configuration.", (Throwable)e);
        }
    }

    public String getParameterValue(String name) throws OwConfigurationException {
        return this.getParameterValue(name, null);
    }

    public String getParameterValue(String name, String defaultValue) throws OwConfigurationException {
        if (defaultValue == null && !this.parameters.containsKey(name)) {
            throw new OwConfigurationException("Missing required configuration parameter " + name);
        }
        String value = this.parameters.get(name);
        return value == null ? defaultValue : value;
    }

    protected Class<?> safeClassFromName(String name, Class<?> superClass) throws OwConfigurationException {
        try {
            Class<?> theClass = Class.forName(name);
            if (!superClass.isAssignableFrom(theClass)) {
                throw new OwConfigurationException("Invalid class " + name + ". A " + superClass + " implementation was expected.");
            }
            return theClass;
        }
        catch (ClassNotFoundException e) {
            throw new OwConfigurationException("Invalid class " + name, (Throwable)e);
        }
    }

    protected <I> I safeInstanceFromName(String name, Class<I> instanceClass) throws OwConfigurationException {
        Class<?> theClass = this.safeClassFromName(name, instanceClass);
        try {
            return (I)theClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new OwConfigurationException("Invalid class " + name, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OwConfigurationException("Invalid class " + name, (Throwable)e);
        }
    }
}

