/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwConfigurableSupport;
import com.wewebu.ow.server.ao.OwSupportConfiguration;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwFileObject;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class OwFileAOSupport
implements OwAOSupport,
OwConfigurableSupport {
    private static final Logger LOG = OwLogCore.getLogger(OwFileAOSupport.class);
    private static final String DEFAULTLOCATION_PARAMETER = "defaultLocation";
    private static final String LOCATION_PARAMETER = "location";
    private static final String FILTER_CLASS = "fileFilterClass";
    private String defaultLocation;
    public static final char PATH_SEPARATOR = '/';
    private String basePath;
    private String userID;
    private OwNetwork<?> network;
    private String location;
    private String fileFilterClass;

    public OwFileAOSupport() {
    }

    public OwFileAOSupport(OwNetwork<?> network_p, OwNetworkConfiguration configuration_p, String defaultLocation_p) throws OwException {
        this.initialize(network_p, configuration_p.getApplicationObjectBaseDir(this.defaultLocation), defaultLocation_p);
    }

    private void initialize(OwNetwork<?> network_p, String location_p, String defaultLocation_p) throws OwException {
        try {
            this.defaultLocation = defaultLocation_p;
            this.network = network_p;
            OwCredentials credentials = network_p.getCredentials();
            OwUserInfo userInfo = credentials.getUserInfo();
            this.userID = userInfo.getUserID();
            OwNetworkContext context = network_p.getContext();
            this.basePath = context.getBasePath();
            this.location = location_p;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve credentials information...", (Throwable)e);
            throw new OwInvalidOperationException(network_p.getContext().localize("ecmimpl.OwFileAOSupport.credentials.error", "Could not retrieve credentials information!"), (Throwable)e);
        }
    }

    @Override
    public void init(OwSupportConfiguration configuration, OwAOContext context) throws OwConfigurationException {
        try {
            OwXMLUtil networkConfiguration = context.getConfiguration().getNetworkAdaptorConfiguration();
            String confDefaultLocation = configuration.getParameterValue(DEFAULTLOCATION_PARAMETER, "");
            String confLocation = configuration.getParameterValue(LOCATION_PARAMETER, "");
            if (confLocation.isEmpty()) {
                confLocation = networkConfiguration.getSafeTextValue("OwApplicationObjectBaseDir", confDefaultLocation);
            }
            this.fileFilterClass = configuration.getParameterValue(FILTER_CLASS, "com.wewebu.ow.server.ao.OwFileAOSupport$BasicFileFilter");
            this.initialize(context.getNetwork(), confLocation, confDefaultLocation);
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not initialize file AO support.", (Throwable)e);
        }
    }

    @Override
    public OwObject[] getSupportObjects(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p) throws OwException {
        File folder = this.getSupportFile(strName_p, forceUserspecificObject_p, createIfNotExist_p, false);
        File[] siteFiles = folder.listFiles(this.createFileFilter());
        if (siteFiles == null) {
            return new OwFileObject[0];
        }
        OwObject[] objects = new OwObject[siteFiles.length];
        if (siteFiles.length > 0) {
            for (int i = 0; i < siteFiles.length; ++i) {
                File file = siteFiles[i];
                if (file.isHidden()) continue;
                try {
                    objects[i] = new OwFileObject(this.network, file, file.getName());
                    continue;
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not read application object file: " + file), (Throwable)e);
                }
            }
        }
        return objects;
    }

    @Override
    public OwObject getSupportObject(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p) throws OwException {
        File file = this.getSupportFile(strName_p, forceUserspecificObject_p, createIfNotExist_p, true);
        try {
            return new OwFileObject(this.network, file, file.getName());
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create OwFileObject for " + strName_p + ", forceUsersSpecificObject=" + forceUserspecificObject_p + " , createIfNotExist=" + createIfNotExist_p), (Throwable)e);
            throw new OwInvalidOperationException(this.network.getContext().localize1("ecmimpl.OwFileAOSupport.getSupportObject.error", "Could not create file application object for %1.", strName_p), (Throwable)e);
        }
    }

    public File getSupportFile(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p, boolean isFile_p) throws OwException {
        File file;
        StringBuffer strFilePath;
        if (this.location.equals(this.defaultLocation)) {
            strFilePath = new StringBuffer(this.basePath.replace('\\', '/'));
            if (strFilePath.charAt(strFilePath.length() - 1) != '/') {
                strFilePath.append('/');
            }
            strFilePath.append(this.location);
        } else if (this.location.indexOf("/WEB-INF/") == 0 || this.location.indexOf("WEB-INF/") == 0) {
            strFilePath = new StringBuffer(this.basePath.replace('\\', '/'));
            if (strFilePath.charAt(strFilePath.length() - 1) != '/') {
                strFilePath.append('/');
            }
            strFilePath.append(this.location);
        } else {
            strFilePath = new StringBuffer(this.location.replace('\\', '/'));
        }
        if (strFilePath.charAt(strFilePath.length() - 1) == '/') {
            strFilePath.append(strName_p);
        } else {
            strFilePath.append('/');
            strFilePath.append(strName_p);
        }
        if (forceUserspecificObject_p) {
            strFilePath.append("_");
            try {
                String filePath = URLEncoder.encode(this.userID, "UTF-8");
                strFilePath.append(filePath);
            }
            catch (UnsupportedEncodingException e) {
                throw new OwServerException("Could not encode file path.");
            }
        }
        if (!(file = new File(strFilePath.toString())).exists() && createIfNotExist_p) {
            if (isFile_p) {
                try {
                    LOG.info((Object)("OwFileAOSupport.getSupportFile: The file was successfully created: " + file.createNewFile()));
                }
                catch (IOException e) {
                    LOG.fatal((Object)("Could not create file: " + strFilePath), (Throwable)e);
                    throw new OwServerException(this.network.getContext().localize1("ecmimpl.OwFileAOSupport.create.file.error", "Error creating file %1", strFilePath.toString()), (Throwable)e);
                }
            } else {
                LOG.info((Object)("OwFileAOSupport.getSupportFile: File structure successfully created: " + file.mkdirs()));
            }
        }
        return file;
    }

    public String toString() {
        return "OwFileAOSupport(basePath=" + this.basePath + ";location=" + this.location + ";userID=" + this.userID + ")";
    }

    protected FileFilter createFileFilter() {
        try {
            if (this.fileFilterClass != null) {
                Class<?> filter = Class.forName(this.fileFilterClass);
                return (FileFilter)filter.newInstance();
            }
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Unable to create instance of " + this.fileFilterClass + ", creating BasicFileFitler"), (Throwable)ex);
            }
            LOG.warn((Object)("Unable to create instance of " + this.fileFilterClass + ", creating BasicFileFitler"));
        }
        return new BasicFileFilter();
    }

    protected static class BasicFileFilter
    implements FileFilter {
        protected BasicFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.isHidden() && pathname.isFile();
        }
    }
}

