/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOConfigurableProvider;
import com.wewebu.ow.server.ao.OwAOConfiguration;
import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwAOProvider;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.List;

public class OwManagedAOProvider
implements OwAOProvider,
OwAOConfigurableProvider {
    private OwAOConfiguration aoConfiguration;

    private void checkConfiguration() throws OwConfigurationException {
        if (this.aoConfiguration == null) {
            throw new OwConfigurationException("The AO Provider is missing thge registry manager configuration.");
        }
    }

    @Override
    public <T> List<T> getApplicationObjects(OwAOType<T> type, String name, boolean forceSpecificObj) throws OwException {
        this.checkConfiguration();
        OwAOManager aoManager = this.aoConfiguration.getManager(type.getType());
        return (List)aoManager.getApplicationObjects(name, forceSpecificObj);
    }

    @Override
    public <T> T getApplicationObject(OwAOType<T> type, String name, boolean forceSpecificObj, boolean createNonExisting) throws OwException {
        this.checkConfiguration();
        OwAOManager aoManager = this.aoConfiguration.getManager(type.getType());
        return (T)aoManager.getApplicationObject(name, forceSpecificObj, createNonExisting);
    }

    @Override
    public <T> T getApplicationObject(OwAOType<T> type, String name, List<Object> params, boolean forceSpecificObj, boolean createNonExisting) throws OwException {
        this.checkConfiguration();
        OwAOManager aoManager = this.aoConfiguration.getManager(type.getType());
        return (T)aoManager.getApplicationObject(name, params.get(0), forceSpecificObj, createNonExisting);
    }

    @Override
    public synchronized void init(OwXMLUtil configuration, OwAOContext context) throws OwConfigurationException {
        this.aoConfiguration = this.createConfiguration(configuration, context);
    }

    protected OwAOConfiguration createConfiguration(OwXMLUtil configuration, OwAOContext context) throws OwConfigurationException {
        return new OwAOConfiguration(configuration, context);
    }
}

