/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOConfigurationPart;
import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwConfigurableManager;
import com.wewebu.ow.server.ao.OwManagerConfiguration;
import com.wewebu.ow.server.ao.OwSupportsConfiguration;
import com.wewebu.ow.server.ecmimpl.OwAOConstants;
import com.wewebu.ow.server.ecmimpl.OwAOTypesEnum;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwManagersConfiguration
extends OwAOConfigurationPart {
    private static final Logger LOG = OwLogCore.getLogger(OwManagersConfiguration.class);
    private OwXMLUtil configuration;
    private Map<Integer, OwAOManager> managers;

    public OwManagersConfiguration(OwXMLUtil configuration, OwSupportsConfiguration supportsConfiguration, OwAOContext context) throws OwConfigurationException {
        super(configuration);
        this.configuration = configuration;
        this.managers = this.readManagers(configuration, supportsConfiguration, context);
    }

    private Map<Integer, OwAOManager> readManagers(OwXMLUtil managersConfiguration, OwSupportsConfiguration supports, OwAOContext context) throws OwConfigurationException {
        HashMap<Integer, OwAOManager> managers = new HashMap<Integer, OwAOManager>();
        List managerConfigurations = managersConfiguration.getSafeUtilList("Manager");
        for (OwXMLUtil managerConfig : managerConfigurations) {
            String managerClassName = managerConfig.getSafeStringAttributeValue("class", null);
            String managerType = managerConfig.getSafeStringAttributeValue("type", null);
            if (managerClassName != null) {
                try {
                    OwAOManager manager = this.safeInstanceFromName(managerClassName, OwAOManager.class);
                    OwAOType<?> aoType = OwAOConstants.fromType(OwAOTypesEnum.valueOf(managerType));
                    if (manager instanceof OwConfigurableManager) {
                        OwConfigurableManager configurableManager = (OwConfigurableManager)((Object)manager);
                        configurableManager.init(aoType, new OwManagerConfiguration(managerConfig), supports, context);
                        LOG.debug((Object)("Loaded configurable AO manager " + manager));
                    } else {
                        LOG.debug((Object)("Loaded non configurable AO manager " + manager));
                    }
                    if (managers.containsKey(aoType.getType())) {
                        String msg = "Mutiple managers are registered for the same application object type " + aoType.getType();
                        LOG.error((Object)("OwStandardRegistry.registerManager():" + msg));
                        throw new OwConfigurationException(new OwString("ecmimpl.OwAOManager.registry.error", "Invalid application object manager registry operation!"));
                    }
                    managers.put(aoType.getType(), manager);
                    continue;
                }
                catch (OwInvalidOperationException e) {
                    throw new OwConfigurationException("Could not register manager.", (Throwable)e);
                }
            }
            throw new OwConfigurationException("Invalid managers configuration.");
        }
        return managers;
    }

    public OwAOManager getManager(int type_p) throws OwInvalidOperationException {
        OwAOManager manager = this.managers.get(type_p);
        if (manager == null) {
            String msg = "No managers for application objects of type " + type_p + "=" + OwAOTypesEnum.fromType(type_p).name() + " are registered!";
            LOG.error((Object)("OwManagersConfiguration.getManager():" + msg));
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.registry.error", "Invalid application object manager registry operation!"));
        }
        return manager;
    }
}

