/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwManagerConfiguration;
import com.wewebu.ow.server.ao.OwSearchTemplateFactory;
import com.wewebu.ow.server.ao.OwSupportBasedManager;
import com.wewebu.ow.server.ao.OwSupportsConfiguration;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.OwAOConstants;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwSearchTemplatesManager
extends OwSupportBasedManager {
    private static final String SINGLE_PATH_PARAMETER = "singlePath";
    private static final String MULTIPLE_PATH_PARAMETER = "multiplePath";
    private static final Logger LOG = OwLogCore.getLogger(OwSearchTemplatesManager.class);
    private OwSearchTemplateFactory searchTemplateFactory;
    private String singlePath = "";
    private String multiplePath = "";
    private OwRoleManager roleManager;

    public OwSearchTemplatesManager() {
    }

    public OwSearchTemplatesManager(OwAOSupport aoSupport_p, OwSearchTemplateFactory searchTemplateFactory_p) {
        this(aoSupport_p, "", searchTemplateFactory_p, "", "");
    }

    public OwSearchTemplatesManager(OwAOSupport aoSupport_p, String basePath_p, OwSearchTemplateFactory searchTemplateFactory_p, String singlePath_p, String multiplePath_p) {
        super(aoSupport_p, basePath_p);
        this.searchTemplateFactory = searchTemplateFactory_p;
        this.singlePath = singlePath_p;
        this.multiplePath = multiplePath_p;
    }

    private void checkDeniedAccess(OwSearchTemplate searchtemplate) throws OwAccessDeniedException {
        try {
            if (this.isAllowed(searchtemplate)) {
                return;
            }
        }
        catch (OwException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        String templateName = searchtemplate.getName();
        LOG.warn((Object)("OwSearchTemplatesManager.checkDeniedAccess : Access to the search template application object " + templateName + " was denied."));
        throw new OwAccessDeniedException(new OwString1("app.OwAOProvider.acces.denied", "Access to the application object %1 was denied", searchtemplate.getName()));
    }

    private boolean isAllowed(OwSearchTemplate searchtemplate) throws OwException {
        try {
            if (this.roleManager != null) {
                return this.roleManager.isAllowed(5, searchtemplate.getName());
            }
            return true;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Error at search template access check.", (Throwable)e);
        }
    }

    @Override
    public OwSearchTemplate getApplicationObject(String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        if (param_p != null) {
            LOG.error((Object)"OwSearchTemplatesManager.getApplicationObject(): Invalid application object request!Could not process non null search template parameter - not implemented!");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"));
        }
        OwObject supportObject = this.getAOSupportObject(this.aoPath(this.singlePath, strName_p), forceUserSpecificObject_p, createIfNotExist_p);
        OwSearchTemplate searchtemplate = this.searchTemplateFactory.createSearchTemplate(supportObject);
        this.checkDeniedAccess(searchtemplate);
        return searchtemplate;
    }

    private String aoPath(String cardinalityPath_p, String strName_p) {
        String aoPath = null;
        aoPath = cardinalityPath_p != null && cardinalityPath_p.length() > 0 ? cardinalityPath_p + "/" + strName_p : strName_p;
        return aoPath;
    }

    @Override
    public OwSearchTemplate getApplicationObject(String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        return this.getApplicationObject(strName_p, null, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public List<OwSearchTemplate> getApplicationObjects(String strName_p, boolean forceUserSpecificObject_p) throws OwException {
        OwObject[] supportObjects = this.getAOSupportObjects(this.aoPath(this.multiplePath, strName_p), forceUserSpecificObject_p, false);
        LinkedList<OwSearchTemplate> searchTemplatesCollection = new LinkedList<OwSearchTemplate>();
        for (int i = 0; i < supportObjects.length; ++i) {
            OwSearchTemplate searchTemplate;
            if (supportObjects[i] == null || !this.isAllowed(searchTemplate = this.searchTemplateFactory.createSearchTemplate(supportObjects[i]))) continue;
            searchTemplatesCollection.add(searchTemplate);
        }
        return searchTemplatesCollection;
    }

    @Override
    public int getManagedType() {
        return 3;
    }

    public OwAOType<?> getType() {
        return OwAOConstants.AO_SEARCHTEMPLATE;
    }

    protected OwSearchTemplateFactory initSearchTemplateFactory(OwAOContext context) {
        return (OwSearchTemplateFactory)((Object)context.getNetwork());
    }

    @Override
    public void init(OwAOType<?> type, OwManagerConfiguration configuration, OwSupportsConfiguration supports, OwAOContext context) throws OwConfigurationException {
        super.init(type, configuration, supports, context);
        this.singlePath = configuration.getParameterValue(SINGLE_PATH_PARAMETER);
        this.multiplePath = configuration.getParameterValue(MULTIPLE_PATH_PARAMETER);
        this.searchTemplateFactory = this.initSearchTemplateFactory(context);
        this.roleManager = context.isRoleManaged() ? context.getNetwork().getRoleManager() : null;
    }

    @Override
    public String toString() {
        return "OwSearchTemplatesManager(searchTemplateFactory=" + this.searchTemplateFactory + ")->" + super.toString();
    }
}

