/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OwAboutMessageHelper {
    public static List<String> getAboutInfo(OwAppContext ctx) throws IOException {
        ArrayList<String> messages = new ArrayList<String>();
        String value = OwConfiguration.getEditionString();
        String message_dev_version = "Development Version - Only for development and testing. Not for production environments";
        messages.add(ctx.localize(value, message_dev_version));
        messages.add(ctx.localize("default.OwMainLayout.jsp.version", "Version") + ": " + ctx.localize(OwConfiguration.getVersionString(), OwConfiguration.getVersionString()) + " - " + OwConfiguration.getBuildNumber());
        messages.add(ctx.localize("default.OwMainLayout.jsp.locale", "Language") + ": " + OwHTMLHelper.encodeToSecureHTML(ctx.getLocale().toString()));
        return messages;
    }

    public static String getAboutInfoAsJs(OwAppContext ctx) throws IOException {
        StringBuilder message = new StringBuilder();
        List<String> aboutInfo = OwAboutMessageHelper.getAboutInfo(ctx);
        message.append("[");
        for (int i = 0; i < aboutInfo.size(); ++i) {
            message.append("'").append(aboutInfo.get(i)).append("'");
            if (i >= aboutInfo.size() - 1) continue;
            message.append(",");
        }
        message.append("]");
        return message.toString();
    }

    public static List<String> getContributors(OwAppContext ctx) {
        ArrayList<String> contributorsList = new ArrayList<String>();
        String contributorsMsg = ctx.localize("About.contributors", "Alfresco Workdesk Contributors...");
        contributorsList.add(contributorsMsg);
        contributorsList.add("Jens Dahl");
        contributorsList.add("Valentin Hemmert");
        contributorsList.add("Alexander Haag");
        contributorsList.add("Dennis Koch");
        contributorsList.add("Bogdan Horje");
        contributorsList.add("Dan Corneanu");
        contributorsList.add("Mihai Cozma");
        contributorsList.add("Silviu Dinuta");
        contributorsList.add("Hema Amara");
        contributorsList.add("...");
        contributorsList.add("Stefan Waldhauser");
        contributorsList.add("Christian Finzel");
        contributorsList.add("Frank Becker");
        contributorsList.add("Dr. Rainer Pausch");
        contributorsList.add("Sabine Otto");
        contributorsList.add("Martin Kappel");
        contributorsList.add("Barbara Lemke");
        contributorsList.add("Tobias Schneider");
        contributorsList.add("Johannes Wernhammer");
        contributorsList.add("Stefan Kopf");
        return contributorsList;
    }

    public static String getCopyright(OwAppContext ctx) {
        return ctx.localize("default.OwMainLayout.jsp.copyright", "Copyright &copy; Alfresco Software, Inc.");
    }
}

