/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwBaseComboboxRenderer;
import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;

public class OwClassicComboboxRenderer
extends OwBaseComboboxRenderer {
    protected static final Set<String> CLASSIC_STYLE_CLASSES = new LinkedHashSet<String>();

    @Override
    public void renderCombo(Writer w_p) throws Exception {
        w_p.write("<select ");
        if (!this.enabled) {
            w_p.write(" disabled ");
        }
        w_p.write(this.renderStyleClasses(CLASSIC_STYLE_CLASSES));
        w_p.write(" name=\"");
        OwHTMLHelper.writeSecureHTML(w_p, this.m_fieldId);
        w_p.write("\"  id=\"");
        OwHTMLHelper.writeSecureHTML(w_p, this.m_fieldId);
        w_p.write("\" ");
        if (this.m_fieldDefinition != null) {
            w_p.write(" title=\"");
            if (this.m_description != null) {
                w_p.write(this.m_description.getString(this.getContext().getLocale()));
            } else {
                w_p.write(this.m_fieldDefinition.getDescription(this.getContext().getLocale()));
            }
            w_p.write("\" ");
            w_p.write(" onchange='onFieldManagerFieldExit(\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.m_fieldDefinition.getClassName()));
            w_p.write("\",\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.m_fieldDefinition.getJavaClassName()));
            w_p.write("\",\"");
            if (this.m_fieldProvider != null) {
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(this.m_fieldProvider.getFieldProviderType())));
                w_p.write("\",\"");
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.m_fieldProvider.getFieldProviderName()));
                w_p.write("\",\"");
            } else {
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(-1)));
                w_p.write("\",\"");
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(""));
                w_p.write("\",\"");
            }
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.m_fieldId));
            w_p.write("\",this.value)");
            String onChangeEventHandler = this.getEventHandler("onchange");
            if (onChangeEventHandler != null) {
                w_p.write(";" + onChangeEventHandler + ";");
            }
            w_p.write("'");
            w_p.write(this.renderEvents("onchange"));
        } else {
            if (this.m_description != null) {
                w_p.write(" title=\"");
                w_p.write(this.m_description.getString(this.getContext().getLocale()));
                w_p.write("\"");
            }
            w_p.write(this.renderEvents());
        }
        w_p.write(">\n");
        for (int i = 0; i < this.m_model.getSize(); ++i) {
            w_p.write("<option value=\"");
            OwComboItem item = this.m_model.getItemAt(i);
            OwHTMLHelper.writeSecureHTML(w_p, item.getValue());
            w_p.write("\"");
            if (this.m_model.isSelectedItem(item)) {
                w_p.write(" selected ");
            }
            w_p.write(">");
            OwHTMLHelper.writeSecureHTML(w_p, item.getDisplayName());
            w_p.write("</option>\n");
        }
        w_p.write("</select>\n");
        if (this.m_model.hasItemOutOfRange()) {
            w_p.write("<span class=\"OwInstructionName\">");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwStandardFieldManager.outofrangelist", "(!) Out of range list"));
            w_p.write("</span>");
        }
    }

    protected String renderEvents(String excludeEventName_p) {
        StringBuffer result = new StringBuffer();
        String[] allEventsNames = this.getAllEventsNames();
        if (allEventsNames.length > 0) {
            for (int i = 0; i < allEventsNames.length; ++i) {
                if (excludeEventName_p != null && allEventsNames[i].equalsIgnoreCase(excludeEventName_p)) continue;
                result.append(" " + allEventsNames[i] + "='" + this.getEventHandler(allEventsNames[i]) + "' ");
            }
        }
        return result.toString();
    }

    protected String renderEvents() {
        return this.renderEvents(null);
    }

    static {
        CLASSIC_STYLE_CLASSES.add("OwInputControl");
        CLASSIC_STYLE_CLASSES.add("OwInputControlChoice");
    }
}

