/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwAppVersion;
import com.wewebu.ow.server.app.OwBaseComboboxRenderer;
import com.wewebu.ow.server.app.OwClassicComboboxRenderer;
import com.wewebu.ow.server.app.OwContextBasedUOListenerFactory;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFunction;
import com.wewebu.ow.server.app.OwGlobalParametersConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwPlugin;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.app.OwSettings;
import com.wewebu.ow.server.app.OwSettingsSet;
import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwDataSourceException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.history.OwHistoryManager;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.mandator.OwMandatorManager;
import com.wewebu.ow.server.role.OwIntegratedApplicationRoleManager;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.role.OwRoleOptionAttributeBag;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwDataSourceUtil;
import com.wewebu.ow.server.util.OwExceptionManager;
import com.wewebu.ow.server.util.OwMimeTypes;
import com.wewebu.ow.server.util.OwSimpleAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardOptionXMLUtil;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwStringProperties;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtilOptionAndPlaceholderFilter;
import com.wewebu.ow.server.util.OwXMLUtilPlaceholderFilter;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OwConfiguration
extends OwBaseConfiguration
implements OwAttributeBag {
    public static int INTERFACE_MINOR_VERSION = 0;
    public static int INTERFACE_MAJOR_VERSION = 0;
    private static final String MASTER_ROLE_APP_SETTING = "MasterRole";
    public static final int IMPLEMENTATION_MAJOR_VERSION = 4;
    public static final int IMPLEMENTATION_MINOR_VERSION = 2;
    public static final int IMPLEMENTATION_UPDATE_VERSION = 0;
    public static final int IMPLEMENTATION_SERVICEPACK_VERSION = 0;
    public static final int IMPLEMENTATION_FIXPACK_VERSION = 0;
    public static final int IMPLEMENTATION_HOTFIX_VERSION = 0;
    public static final String IMPLEMENTATION_RELEASE_TYPE = "";
    public static final String MIME_TYPE_OPTION_PREFIX = "mime.";
    private static final Logger LOG = OwLogCore.getLogger(OwConfiguration.class);
    public static final String ECM_ADAPTER_ELEMENT = "EcmAdapter";
    private static final String WORKDESK_VERSION_PROPERTIES = "workdesk-version.properties";
    private static OwAppVersion version = null;
    private static final String ATT_OW_CONFIGURATION_M_BOOTSTRAP_CONFIGURATION = "OwConfiguration.m_bootstrapConfiguration";
    public static final String WORKDESK_APPLICATION_ID = "WorkdeskApplicationId";
    private static final String COMBOBOX_RENDERER_CLASS_NAME_ELEMENT = "ComboboxRendererClassName";
    public static final String MIMETYPES_CUSTOM_FILE_NAME = "mimetypes.properties";
    public static final String GLOBAL_PARAMETERS_ELEMENT = "globalParameters";
    private static final String LAYOUT_SETTINGS_BAG_ID_PREFIX = "layout_bag_id_";
    protected OwMainAppContext m_Context;
    private OwXMLUtil m_bootstrapConfiguration = null;
    private OwRoleOptionAttributeBag m_roleoptionIDs = new OwRoleOptionAttributeBag();
    protected List m_AllowedDocumentFunctionPluginList;
    protected Map m_AllowedDocumentFunctionPluginMap;
    protected List m_AllowedRecordFunctionPluginList;
    protected Map m_AllowedRecordFunctionPluginMap;
    protected List m_AllowedMasterPluginList;
    protected Map m_AllowedMasterPluginMap;
    private OwNetwork m_theNetwork;
    private OwRoleManager m_theRoleManager;
    private OwHistoryManager m_theHistoryManager;
    private OwMandatorManager m_theMandatorManager;
    private OwSettings m_Settings;
    private OwSettingsSet m_AppSettingsSet;
    private OwAttributeBagWriteable m_userattributebag;
    private JdbcTemplate m_jdbcTemplate;
    private Set<OwContextBasedUOListenerFactory> listenerFactories;
    private String applicationId;
    public static final String MAIN_PLUGIN_DOCUMENT_ID_EXTENSION = ".Doc";
    public static final String MAIN_PLUGIN_VIEW_ID_EXTENSION = ".View";
    public static final int PLUGINS_REQUIRE_CONTEXT_MENU = 1;
    public static final int PLUGINS_REQUIRE_CAN_MULTISELECT = 2;
    private int m_iDocumentFunctionRequirementFlags;
    private Map m_ClientWildCardDefinitionsMap;
    private Map m_mimenodemap = new HashMap();
    public static final int SSL_MODE_NONE = 0;
    public static final int SSL_MODE_SESSION = 1;
    private String m_comboboxRendererClassName;

    static synchronized OwAppVersion getVersions() {
        if (null == version) {
            String versionPropertiesFileName = "/workdesk-version.properties";
            URL versionPropertiesURL = OwConfiguration.class.getResource(versionPropertiesFileName);
            version = null != versionPropertiesURL ? OwAppVersion.fromProperties(versionPropertiesURL) : OwAppVersion.unknownVersion();
        }
        return version;
    }

    public static synchronized String getVersionString() {
        return OwConfiguration.getVersions().getVersionString();
    }

    public static synchronized String getEditionString() {
        return OwConfiguration.getVersions().getEditionString();
    }

    public static synchronized String getBuildNumber() {
        return OwConfiguration.getVersions().getBuildNumber();
    }

    public void init(OwMainAppContext context_p) throws Exception {
        this.m_Context = context_p;
        this.m_bootstrapConfiguration = (OwXMLUtil)context_p.getApplicationAttribute(ATT_OW_CONFIGURATION_M_BOOTSTRAP_CONFIGURATION);
        if (this.m_bootstrapConfiguration == null) {
            String msg = "OwConfiguration.init: Error, the bootstrap configuration XML node is null. Possible cause: the 'owbootstrap.xml' file is missing or has an invalid XML format.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg + " Please check your log files for further informations...)");
        }
        this.m_bootstrapConfiguration = new OwXMLUtilOptionAndPlaceholderFilter(this.m_bootstrapConfiguration, (OwAttributeBag)this, (OwAttributeBag)this.m_roleoptionIDs);
        this.m_jdbcTemplate = (JdbcTemplate)context_p.getApplicationAttribute("OwConfiguration.m_jdbcTemplate");
        if (this.m_jdbcTemplate == null) {
            LOG.warn((Object)"OwConfiguration.init: Warning, the spring JDBC access Template (m_jdbcTemplate) is null.");
        }
        this.applicationId = context_p.getInitParameter(WORKDESK_APPLICATION_ID);
        this.createMandatorManager();
        this.createHistoryManager();
        this.createNetworkAdapter();
        this.getHistoryManager().setNetwork(this.getNetwork());
        this.getNetwork().setEventManager(this.getHistoryManager());
        this.createRoleManager();
        this.getNetwork().setRoleManager(this.getRoleManager());
    }

    private static JdbcTemplate createJdbcDataSource(OwBaseInitializer initializer_p, String taskDataSourceJNDI_p) throws Exception {
        DataSource ds = OwDataSourceUtil.retrieveDataSource(taskDataSourceJNDI_p);
        if (ds == null) {
            String msg = "OwConfiguration.createJdbcDataSource: No DataSource available for provided name/id";
            LOG.fatal((Object)msg);
            throw new OwDataSourceException(msg);
        }
        LOG.debug((Object)"OwConfiguration.createJdbcDataSource: Initializing datasource successfully.");
        JdbcTemplate template = OwDataSourceUtil.createJdbcTemplate(ds);
        initializer_p.setApplicationAttribute("OwConfiguration.m_jdbcTemplate", template);
        LOG.debug((Object)"OwConfiguration.createJdbcDataSource: Initializing Spring Jdbc template successfully done.");
        return template;
    }

    public JdbcTemplate getJDBCTemplate() {
        return this.m_jdbcTemplate;
    }

    public static void applicationInitalize(OwBaseInitializer initializer_p) throws OwConfigurationException {
        try {
            LOG.debug((Object)"OwConfiguration.applicationInitalize: start initializing the application logger...");
            URL log4jurl = initializer_p.getConfigURL("log4j.properties");
            if (log4jurl != null && new File(log4jurl.getPath()).exists()) {
                PropertyConfigurator.configure((URL)log4jurl);
            } else {
                log4jurl = initializer_p.getConfigURL("log4j.xml");
                if (log4jurl != null && new File(log4jurl.getPath()).exists()) {
                    DOMConfigurator.configure((URL)log4jurl);
                }
            }
            if (log4jurl == null) {
                LOG.warn((Object)"OwConfiguration.applicationInitalize: can not found the logger initialization files: 'log4j.properties' or 'log4j.xml'...");
            } else {
                LOG.debug((Object)("OwConfiguration.applicationInitalize: ...application logger successfully configured from: " + log4jurl.toString()));
            }
            LOG.debug((Object)"OwConfiguration.applicationInitalize: start reading the bootstrap configuration data...");
            OwXMLUtil bootConfig = OwConfiguration.createBootstrap(initializer_p);
            Node dataSourceNode = bootConfig.getSubNode("DefaultDataSource");
            if (dataSourceNode == null) {
                LOG.debug((Object)"OwConfiguration.applicationInitalize: no DataSource is specified in the owbootstrap.xml (<DefaultDataSource>). The application will run without additional DB functionality: do not use the DBHistoryManager and OwDBRoleManager, use instead the OwSimpleHistoryManager and OwSimpleRoleManager.");
            } else {
                OwStandardXMLUtil datasourceconfig = new OwStandardXMLUtil(dataSourceNode);
                String taskDataSourceJNDI = datasourceconfig.getSafeTextValue("JNDIName", null);
                if (null != taskDataSourceJNDI) {
                    OwConfiguration.createJdbcDataSource(initializer_p, taskDataSourceJNDI);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OwConfiguration.applicationInitalize: DB <DefaultDataSource> of owbootstrap.xml, JNDIName = " + taskDataSourceJNDI));
                }
            }
            LOG.debug((Object)"OwConfiguration.applicationInitalize: ...reading the bootstrap configuration data finished.");
        }
        catch (Exception e) {
            String msg = "Application initializing error: Exception reading the bootstrap configuration data.";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"OwConfiguration.applicationInitalize: check if customized 'mimetypes.properties' file should be loaded.");
            }
            URL mimetypesPropertiesURL = initializer_p.getConfigURL(MIMETYPES_CUSTOM_FILE_NAME);
            OwMimeTypes.loadFromUrl(mimetypesPropertiesURL);
        }
        catch (Exception e) {
            String msg = "Application initializing error: Exception reading the 'mimetypes.properties' file.";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
    }

    public void loginInit() throws Exception {
        try {
            this.m_theRoleManager.loginInit();
        }
        catch (Exception e) {
            LOG.error((Object)("The Role Manager could not be initialized after login, RoleManager = " + this.m_theRoleManager.getClass().toString()), (Throwable)e);
            throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.rolemanageriniterror", "Role Manager could not be initialized after login:") + " " + this.m_theRoleManager.getClass().toString() + " - " + e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_Settings = new OwSettings(this.m_Context);
        if (this.m_theRoleManager.hasMasterRoles()) {
            String strMasterRole = this.m_Context.getSafeStringAppSetting(MASTER_ROLE_APP_SETTING, null);
            if (strMasterRole != null) {
                if (this.m_theRoleManager.setMasterRole(strMasterRole)) {
                    this.updateSettings();
                }
            } else {
                List appPlugs = this.getAllowedPlugins("ow_app");
                if (appPlugs == null) {
                    LOG.error((Object)("OwConfiguration.loginInit: The Workdesk plugin is not allowed for one of the roles specified in master role " + this.m_theRoleManager.getMasterRole()));
                    throw new OwConfigurationException(this.m_Context.localize1("app.OwConfiguration.masterroleconfigerror", "The Workdesk plugin is not available for one of the roles specified in master role %1. Please enable the Workdesk plugin for the roles from master role %1.", this.m_theRoleManager.getMasterRole()));
                }
            }
        }
        this.m_roleoptionIDs.setIDs(this.getRoleManager().getAllowedResources(8));
        this.createPlugins();
    }

    private void updateSettings() throws Exception {
        this.m_Settings.refresh();
        this.m_AppSettingsSet = null;
    }

    public boolean setMasterRole(String strRole_p) throws Exception {
        if (this.getRoleManager().setMasterRole(strRole_p)) {
            this.m_mimenodemap.clear();
            this.m_roleoptionIDs = new OwRoleOptionAttributeBag();
            this.updateSettings();
            this.m_Context.getConfigChangeEvent().onConfigChangeEventUpdateRoles();
            this.updatePlugins();
            this.m_roleoptionIDs.setIDs(this.getRoleManager().getAllowedResources(8));
            return true;
        }
        return false;
    }

    public OwAttributeBagWriteable getUserAttributeBag() throws Exception {
        if (null == this.m_userattributebag) {
            try {
                this.m_userattributebag = (OwAttributeBagWriteable)this.getNetwork().getApplicationObject(7, "OwApplicationSite", true, false);
            }
            catch (OwObjectNotFoundException e) {
                this.m_userattributebag = new OwSimpleAttributeBagWriteable();
                LOG.warn((Object)"No persistent attribute bag available, a dummy attribute bag is set so that the application is runnable...", (Throwable)e);
            }
        }
        return this.m_userattributebag;
    }

    public OwSettings getSettings() {
        return this.m_Settings;
    }

    public OwSettingsSet getAppSettings() throws Exception {
        List appPlugs;
        if (this.m_AppSettingsSet == null && (appPlugs = this.getAllowedPlugins("ow_app")) != null && appPlugs.size() > 0) {
            if (appPlugs.size() > 1) {
                LOG.warn((Object)"OwConfiguration.getAppSettings: Role has more than one workdesk sections defined. Please check roles.");
            }
            OwXMLUtil NodeWrapper = (OwXMLUtil)appPlugs.get(0);
            this.m_AppSettingsSet = this.m_Settings.getSettingsInfo(NodeWrapper.getSafeTextValue("id", "null"));
        }
        return this.m_AppSettingsSet;
    }

    public OwNetwork getNetwork() {
        return this.m_theNetwork;
    }

    public OwMandatorManager getMandatorManager() {
        return this.m_theMandatorManager;
    }

    public OwRoleManager getRoleManager() {
        return this.m_theRoleManager;
    }

    public OwHistoryManager getHistoryManager() {
        return this.m_theHistoryManager;
    }

    private void createNetworkAdapter() throws Exception {
        String strNetworkClassName = IMPLEMENTATION_RELEASE_TYPE;
        try {
            OwXMLUtil NetworkConfigurationNode = this.getNetworkAdaptorConfiguration();
            strNetworkClassName = NetworkConfigurationNode.getSafeTextValue("ClassName", null);
            Class<?> NetworkClass = Class.forName(strNetworkClassName);
            this.m_theNetwork = (OwNetwork)NetworkClass.newInstance();
            this.m_theNetwork.init(this.m_Context, NetworkConfigurationNode);
        }
        catch (Exception e) {
            LOG.error((Object)("The ECM Adapter could not be loaded, NetworkClassName = " + strNetworkClassName), (Throwable)e);
            throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.networkloaderror", "ECM adapter could not be loaded:") + " " + strNetworkClassName + " - " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void createHistoryManager() throws Exception {
        String strHistoryManagerClassName = IMPLEMENTATION_RELEASE_TYPE;
        try {
            OwXMLUtil ConfigurationNode = this.getHistoryManagerConfiguration();
            strHistoryManagerClassName = ConfigurationNode.getSafeTextValue("ClassName", null);
            Class<?> HistoryManagerClass = Class.forName(strHistoryManagerClassName);
            this.m_theHistoryManager = (OwHistoryManager)HistoryManagerClass.newInstance();
            this.m_theHistoryManager.init(this.m_Context, ConfigurationNode);
        }
        catch (Exception e) {
            LOG.error((Object)("Audit trail manager could not be loaded, HistoryManagerClassName = " + strHistoryManagerClassName), (Throwable)e);
            throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.HistoryManagermanagerloaderror", "History Manager could not be loaded:") + " " + strHistoryManagerClassName + " - " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void createMandatorManager() throws Exception {
        String strMandatorManagerClassName = IMPLEMENTATION_RELEASE_TYPE;
        try {
            OwXMLUtil ConfigurationNode = this.getMandatorManagerConfiguration();
            strMandatorManagerClassName = ConfigurationNode.getSafeTextValue("ClassName", null);
            Class<?> MandatorManagerClass = Class.forName(strMandatorManagerClassName);
            this.m_theMandatorManager = (OwMandatorManager)MandatorManagerClass.newInstance();
            this.m_theMandatorManager.init(this.m_Context, ConfigurationNode);
        }
        catch (Exception e) {
            LOG.error((Object)("Mandator Manager could not be loaded, MandatorManagerClassName = " + strMandatorManagerClassName), (Throwable)e);
            throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.MandatorManagerloaderror", "Tenant Manager could not be loaded:") + " " + strMandatorManagerClassName + " - " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void createRoleManager() throws Exception {
        String strRoleManagerClassName = IMPLEMENTATION_RELEASE_TYPE;
        try {
            OwXMLUtil ConfigurationNode = this.getRoleManagerConfiguration();
            strRoleManagerClassName = ConfigurationNode.getSafeTextValue("ClassName", null);
            Class<?> roleManagerClass = Class.forName(strRoleManagerClassName);
            try {
                this.m_theRoleManager = (OwRoleManager)roleManagerClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)("The Role Manager could not be loaded (can not be instantiated), RoleManagerClassName = " + strRoleManagerClassName), (Throwable)e);
                throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.rolemanagerloaderror", "Role Manager could not be loaded:") + " " + strRoleManagerClassName + " - " + e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_theRoleManager.init(this.m_Context.getRegisteredInterface(OwRoleManagerContext.class), ConfigurationNode);
            if (this.applicationId != null && this.m_theRoleManager instanceof OwIntegratedApplicationRoleManager) {
                OwIntegratedApplicationRoleManager integratedManager = (OwIntegratedApplicationRoleManager)this.m_theRoleManager;
                this.m_theRoleManager = integratedManager.createIntegratedRoleManager(this.applicationId);
            }
        }
        catch (OwConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("The Role Manager could not be loaded, RoleManagerClassName = " + strRoleManagerClassName), (Throwable)e);
            throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.rolemanagerloaderror", "Role Manager could not be loaded:") + " " + strRoleManagerClassName + " - " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public OwFieldManager createFieldManager() throws Exception {
        String strFieldManagerClassName = IMPLEMENTATION_RELEASE_TYPE;
        try {
            OwXMLUtil ConfigurationNode = this.getFieldManagerConfiguration();
            strFieldManagerClassName = ConfigurationNode.getSafeTextValue("ClassName", null);
            Class<?> FieldManagerClass = Class.forName(strFieldManagerClassName);
            OwFieldManager fieldManager = (OwFieldManager)FieldManagerClass.newInstance();
            fieldManager.init(ConfigurationNode);
            fieldManager.attach(this.m_Context, null);
            return fieldManager;
        }
        catch (Exception e) {
            LOG.error((Object)("The Attribute Field Manager could not be loaded. FieldManagerClassName = " + strFieldManagerClassName), (Throwable)e);
            throw new OwConfigurationException(this.m_Context.localize("app.OwConfiguration.propertyfieldmanagerloaderror", "Attribute Field Manager could not be loaded:") + " " + strFieldManagerClassName + " - " + e.getMessage(), (Throwable)e);
        }
    }

    public void updatePlugins() throws Exception {
        this.m_AllowedMasterPluginList = null;
        this.m_AllowedMasterPluginMap = null;
        this.m_AllowedDocumentFunctionPluginList = null;
        this.m_AllowedDocumentFunctionPluginMap = null;
        this.m_AllowedRecordFunctionPluginList = null;
        this.m_AllowedRecordFunctionPluginMap = null;
        this.createPlugins();
    }

    private void createPlugins() throws Exception {
        if (this.m_AllowedMasterPluginList == null) {
            this.m_AllowedMasterPluginList = new ArrayList();
            this.m_AllowedMasterPluginMap = new HashMap();
            List myPlugs = this.getAllowedPlugins("ow_master");
            if (myPlugs != null) {
                for (int i = 0; i < myPlugs.size(); ++i) {
                    OwXMLUtil NodeWrapper = (OwXMLUtil)myPlugs.get(i);
                    OwMasterPluginInstance mplug = this.createMasterPlugin(NodeWrapper);
                    this.m_AllowedMasterPluginList.add(mplug);
                    this.m_AllowedMasterPluginMap.put(mplug.getPluginID(), mplug);
                }
            }
        }
        if (this.m_AllowedDocumentFunctionPluginList == null) {
            this.m_AllowedDocumentFunctionPluginList = new ArrayList();
            this.m_AllowedDocumentFunctionPluginMap = new HashMap();
            this.m_iDocumentFunctionRequirementFlags = this.loadFunctionPlugins("ow_docfunction", this.m_AllowedDocumentFunctionPluginList, this.m_AllowedDocumentFunctionPluginMap);
        }
        if (this.m_AllowedRecordFunctionPluginList == null) {
            this.m_AllowedRecordFunctionPluginList = new ArrayList();
            this.m_AllowedRecordFunctionPluginMap = new HashMap();
            this.loadFunctionPlugins("ow_recordfunction", this.m_AllowedRecordFunctionPluginList, this.m_AllowedRecordFunctionPluginMap);
        }
    }

    protected OwMasterPluginInstance createMasterPlugin(String strDocClassName, String strViewClassName, OwXMLUtil pluginNodeWrapper_p) throws Exception {
        Class<?> DocumentClass = Class.forName(strDocClassName);
        OwMasterDocument newDoc = (OwMasterDocument)DocumentClass.newInstance();
        if (strViewClassName != null) {
            Class<?> ViewClass = Class.forName(strViewClassName);
            OwMasterView newView = (OwMasterView)ViewClass.newInstance();
            return new OwMasterPluginInstance(newView, newDoc, pluginNodeWrapper_p);
        }
        return new OwMasterPluginInstance(null, newDoc, pluginNodeWrapper_p);
    }

    protected OwMasterPluginInstance createMasterPlugin(OwXMLUtil pluginNodeWrapper_p) throws Exception {
        String strDocClassName = pluginNodeWrapper_p.getSafeTextValue("ClassName", null);
        String strViewClassName = pluginNodeWrapper_p.getSafeTextValue("ViewClassName", null);
        try {
            return this.createMasterPlugin(strDocClassName, strViewClassName, pluginNodeWrapper_p);
        }
        catch (Exception e) {
            LOG.error((Object)("Masterplugin can not be instantiated, DocClassName = " + strDocClassName + " , ViewClassName = " + strViewClassName), (Throwable)e);
            return new OwMasterPluginInstance(e, pluginNodeWrapper_p);
        }
    }

    public boolean isDocmentFunctionRequirement(int iRequirement_p) {
        return (iRequirement_p & this.m_iDocumentFunctionRequirementFlags) == iRequirement_p;
    }

    private int loadFunctionPlugins(String strPluginType_p, List functionList_p, Map backupMap_p) throws Exception {
        List FunctionPlugs = this.getAllowedPlugins(strPluginType_p);
        int iDocumentFunctionRequirementFlags = 0;
        if (FunctionPlugs != null) {
            for (int p = 0; p < FunctionPlugs.size(); ++p) {
                OwXMLUtil NodeWrapper = (OwXMLUtil)FunctionPlugs.get(p);
                String strPluginClass = NodeWrapper.getSafeTextValue("ClassName", null);
                String strID = NodeWrapper.getSafeTextValue("id", null);
                try {
                    Class<?> PluginClass = Class.forName(strPluginClass);
                    OwFunction newFunctionPlugIn = (OwFunction)PluginClass.newInstance();
                    newFunctionPlugIn.init(NodeWrapper, this.m_Context);
                    functionList_p.add(newFunctionPlugIn);
                    backupMap_p.put(strID, newFunctionPlugIn);
                    if (newFunctionPlugIn.getContextMenu()) {
                        iDocumentFunctionRequirementFlags |= 1;
                    }
                    try {
                        if (!((OwDocumentFunction)newFunctionPlugIn).getMultiselect()) continue;
                        iDocumentFunctionRequirementFlags |= 2;
                    }
                    catch (ClassCastException e) {}
                    continue;
                }
                catch (Exception e) {
                    String msg = "Exception loading the function plugin with the plugin Id = " + strID + ", PluginClass = " + strPluginClass;
                    LOG.error((Object)msg, (Throwable)e);
                }
            }
        }
        return iDocumentFunctionRequirementFlags;
    }

    public List getMasterPlugins(boolean fExcludeListeners_p) {
        if (fExcludeListeners_p) {
            ArrayList<OwMasterPluginInstance> retList = new ArrayList<OwMasterPluginInstance>();
            for (OwMasterPluginInstance masterPlug : this.m_AllowedMasterPluginList) {
                if (masterPlug.m_view == null) continue;
                retList.add(masterPlug);
            }
            return retList;
        }
        return this.m_AllowedMasterPluginList;
    }

    public List getDocumentFunctionPlugins() {
        return this.m_AllowedDocumentFunctionPluginList;
    }

    public OwDocumentFunction getDocumentFunction(String strID_p) throws Exception {
        OwDocumentFunction docFunction = (OwDocumentFunction)this.m_AllowedDocumentFunctionPluginMap.get(strID_p);
        if (null == docFunction) {
            String msg = "OwConfiguration.getDocumentFunction: Plugin 'access denied' or 'not allowed' in this context, document function plugin with Id = " + strID_p;
            LOG.debug((Object)msg);
            throw new OwAccessDeniedException(msg);
        }
        return docFunction;
    }

    public boolean isDocumentFunctionAllowed(String strID_p) {
        return this.m_AllowedDocumentFunctionPluginMap.containsKey(strID_p);
    }

    public List getRecordFunctionPlugins() {
        return this.m_AllowedRecordFunctionPluginList;
    }

    public OwRecordFunction getRecordFunction(String strID_p) throws Exception {
        OwRecordFunction recFunction = (OwRecordFunction)this.m_AllowedRecordFunctionPluginMap.get(strID_p);
        if (null == recFunction) {
            String msg = "OwConfiguration.getRecordFunction: Access denied, getting the record function plugin with Id = " + strID_p;
            LOG.debug((Object)msg);
            throw new OwAccessDeniedException(msg);
        }
        return recFunction;
    }

    public boolean isRecordFunctionAllowed(String strID_p) {
        return this.m_AllowedRecordFunctionPluginMap.containsKey(strID_p);
    }

    public OwMasterPluginInstance getMasterPlugin(String strID_p) throws Exception {
        OwMasterPluginInstance masterplug = (OwMasterPluginInstance)this.m_AllowedMasterPluginMap.get(strID_p);
        if (null == masterplug) {
            String msg = "OwConfiguration.getMasterPlugin: Access denied, getting the master plugin with Id = " + strID_p;
            LOG.debug((Object)msg);
            throw new OwAccessDeniedException(msg);
        }
        return masterplug;
    }

    public boolean isMasterPluginAllowed(String strID_p) {
        return this.m_AllowedMasterPluginMap.containsKey(strID_p);
    }

    public OwPlugin getAllowedPluginInstance(String strID_p) throws Exception {
        if (this.isRecordFunctionAllowed(strID_p)) {
            return this.getRecordFunction(strID_p);
        }
        if (this.isDocumentFunctionAllowed(strID_p)) {
            return this.getDocumentFunction(strID_p);
        }
        if (this.isMasterPluginAllowed(strID_p)) {
            return this.getMasterPlugin(strID_p);
        }
        String msg = "OwConfiguration.getAllowedPluginInstance: No allowed plugin instance found for the plugin with ID = " + strID_p;
        LOG.debug((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    public static OwXMLUtil getBootstrap(OwBaseInitializer initializer_p) {
        return (OwXMLUtil)initializer_p.getApplicationAttribute(ATT_OW_CONFIGURATION_M_BOOTSTRAP_CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OwXMLUtil createBootstrap(OwBaseInitializer initializer_p) throws Exception {
        String bootstrapInUse = (String)initializer_p.getApplicationAttribute("BOOTSTRAP_IN_USE");
        String shortBootstrapName = "bootstrap";
        if (bootstrapInUse != null) {
            shortBootstrapName = bootstrapInUse.substring(2, bootstrapInUse.length() - 4);
        }
        OwStandardOptionXMLUtil bootConfig = null;
        try (InputStream xmlConfigDoc = null;){
            xmlConfigDoc = initializer_p.getXMLConfigDoc(shortBootstrapName);
            bootConfig = new OwStandardOptionXMLUtil(xmlConfigDoc, "bootstrap");
            initializer_p.setApplicationAttribute(ATT_OW_CONFIGURATION_M_BOOTSTRAP_CONFIGURATION, bootConfig);
            OwStringProperties.initialize(bootConfig);
        }
        return bootConfig;
    }

    public OwXMLUtil getBootstrapConfiguration() {
        return this.m_bootstrapConfiguration;
    }

    public OwXMLUtil getMandatorManagerConfiguration() throws Exception {
        return new OwStandardXMLUtil(this.getBootstrapConfiguration().getSubNode("MandatorManager"));
    }

    public OwXMLUtil getNetworkAdaptorConfiguration() throws Exception {
        return new OwXMLUtilOptionAndPlaceholderFilter(this.getBootstrapConfiguration().getSubNode(ECM_ADAPTER_ELEMENT), (OwAttributeBag)this, (OwAttributeBag)this.m_roleoptionIDs);
    }

    public OwXMLUtil getHistoryManagerConfiguration() throws Exception {
        return new OwXMLUtilOptionAndPlaceholderFilter(this.getBootstrapConfiguration().getSubNode("HistoryManager"), (OwAttributeBag)this, (OwAttributeBag)this.m_roleoptionIDs);
    }

    public OwXMLUtil getRoleManagerConfiguration() throws Exception {
        return new OwXMLUtilOptionAndPlaceholderFilter(this.getBootstrapConfiguration().getSubNode("RoleManager"), (OwAttributeBag)this, (OwAttributeBag)this.m_roleoptionIDs);
    }

    public OwXMLUtil getFieldManagerConfiguration() throws Exception {
        return new OwXMLUtilOptionAndPlaceholderFilter(new OwStandardOptionXMLUtil(this.getBootstrapConfiguration().getSubNode("FieldManager")), (OwAttributeBag)this, (OwAttributeBag)this.m_roleoptionIDs);
    }

    public List getAllowedPlugins(String strType_p) throws Exception {
        return this.getRoleManager().getPlugins(strType_p);
    }

    public OwXMLUtil getPlugin(String strID_p) throws Exception {
        return this.getRoleManager().getPlugin(strID_p);
    }

    public Map getClientWildCardDefinitions() {
        if (null == this.m_ClientWildCardDefinitionsMap) {
            this.m_ClientWildCardDefinitionsMap = new HashMap();
            for (Node wcNode : this.getBootstrapConfiguration().getSafeNodeList("ClientWildCardDefinitions")) {
                String sType = OwXMLDOMUtil.getSafeStringAttributeValue(wcNode, "type", null);
                if (null == sType) {
                    LOG.error((Object)"OwConfiguration.getClientWildCardDefinitions: Please define ClientWildCardDefinitions with type attribute in bootstrap.");
                    continue;
                }
                Integer type = null;
                try {
                    type = (Integer)OwWildCardDefinition.class.getField(sType).get(null);
                }
                catch (Exception e) {
                    try {
                        type = new Integer(sType);
                    }
                    catch (Exception e2) {
                        LOG.error((Object)("Please define ClientWildCardDefinitions with number or OwWildCardDefinition..WILD_CARD_TYPE_... type attribute in bootstrap. Unknown type: " + sType), (Throwable)e2);
                        continue;
                    }
                }
                String sCharacter = null;
                try {
                    sCharacter = wcNode.getFirstChild().getNodeValue();
                }
                catch (Exception e3) {
                    LOG.error((Object)("OwConfiguration - Please define ClientWildCardDefinitions with a valid wildcard character in bootstrap. Type: " + sType), (Throwable)e3);
                    continue;
                }
                this.m_ClientWildCardDefinitionsMap.put(type, sCharacter);
            }
        }
        return this.m_ClientWildCardDefinitionsMap;
    }

    public String getDefaultFolderClassName() {
        return this.getBootstrapConfiguration().getSafeTextValue("DefaultFolderClass", null);
    }

    public List getRecordClassNames() {
        return this.getBootstrapConfiguration().getSafeStringList("RecordClasses");
    }

    public List getAvailableLanguages() {
        return this.getBootstrapConfiguration().getSafeNodeList("availablelocals");
    }

    public boolean displayLanguageSelection() {
        try {
            return this.getBootstrapConfiguration().getSubNode("availablelocals").getAttributes().getNamedItem("display").getNodeValue().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getDefaultLanguage() {
        return this.getBootstrapConfiguration().getSafeTextValue("defaultlocal", "en");
    }

    public boolean getDetectBrowserLocale() {
        try {
            return OwXMLDOMUtil.getSafeBooleanAttributeValue(this.getBootstrapConfiguration().getSubNode("defaultlocal"), "detectbrowserlocale", true);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean getMessageBoxOnUserError() {
        return this.getBootstrapConfiguration().getSafeBooleanValue("MessageBoxOnUserError", false);
    }

    public OwXMLUtil getMIMENode(String strMIMEType_p) throws Exception {
        if (this.m_mimenodemap.containsKey(strMIMEType_p)) {
            return (OwXMLUtil)this.m_mimenodemap.get(strMIMEType_p);
        }
        String optionmimetype = (String)this.m_roleoptionIDs.getAttribute(MIME_TYPE_OPTION_PREFIX + strMIMEType_p);
        if (null == optionmimetype) {
            optionmimetype = strMIMEType_p;
        }
        OwXMLUtilPlaceholderFilter ret = null;
        OwXMLUtil node = this.getRoleManager().getMIMENode(optionmimetype);
        if (node != null) {
            ret = new OwXMLUtilPlaceholderFilter(node, (OwAttributeBag)this);
        }
        this.m_mimenodemap.put(strMIMEType_p, ret);
        return ret;
    }

    public OwXMLUtil getDefaultMIMENode(int iObjectType_p) throws Exception {
        String key = String.valueOf(iObjectType_p);
        if (this.m_mimenodemap.containsKey(key)) {
            return (OwXMLUtil)this.m_mimenodemap.get(key);
        }
        OwXMLUtilPlaceholderFilter ret = null;
        OwXMLUtil node = this.getRoleManager().getDefaultMIMENode(iObjectType_p);
        if (node != null) {
            ret = new OwXMLUtilPlaceholderFilter(node, (OwAttributeBag)this);
        }
        this.m_mimenodemap.put(key, ret);
        return ret;
    }

    public int getSSLMode() {
        return this.getBootstrapConfiguration().getSafeIntegerValue("SSLMode", 1);
    }

    public String getTempDir() throws OwConfigurationException {
        String strTempDir;
        block5: {
            strTempDir = IMPLEMENTATION_RELEASE_TYPE;
            try {
                strTempDir = this.getBootstrapConfiguration().getSafeTextValue("TempDir", IMPLEMENTATION_RELEASE_TYPE);
                if (strTempDir != null && strTempDir.length() != 0) break block5;
                LOG.debug((Object)"Cannot find the temp dir (TempDir, defined in bootstrap configuration), that can be used for upload... Trying to set the temp dir to 'java.io.tmpdir'...");
                strTempDir = System.getProperty("java.io.tmpdir");
                if (strTempDir != null && strTempDir.length() != 0) break block5;
                try {
                    strTempDir = this.m_Context.getHttpServletContext().getResource("/").getPath();
                }
                catch (MalformedURLException e) {
                    throw new OwConfigurationException("Could not set the 'java.io.tmpdir' as temp dir....", (Throwable)e);
                }
            }
            catch (OwConfigurationException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new OwConfigurationException("Error getting the temp dir (TempDir), that can be used for upload...", (Throwable)ex);
            }
        }
        return strTempDir;
    }

    @Override
    public String getLocalizedPluginSettingTitle(Node settingDescriptionNode_p, String strPluginName_p) {
        return this.m_Context.localize("plugin." + strPluginName_p + ".setting." + settingDescriptionNode_p.getNodeName(), OwXMLDOMUtil.getSafeStringAttributeValue(settingDescriptionNode_p, "displayname", null));
    }

    @Override
    public String getLocalizedPluginTitle(OwXMLUtil pluginDescriptionNode_p) {
        return this.m_Context.localize("plugin." + pluginDescriptionNode_p.getSafeTextValue("id", "undef") + ".title", pluginDescriptionNode_p.getSafeTextValue("Name", "[undef]"));
    }

    @Override
    public String getLocalizedPluginTitle(String strID_p) {
        try {
            OwXMLUtil pluginDescriptionNode = this.getPlugin(strID_p);
            if (pluginDescriptionNode != null) {
                return this.getLocalizedPluginTitle(pluginDescriptionNode);
            }
            return strID_p;
        }
        catch (Exception e) {
            return strID_p;
        }
    }

    @Override
    public String getLocalizedPluginDescription(OwXMLUtil pluginDescriptionNode_p) {
        return this.m_Context.localize("plugin." + pluginDescriptionNode_p.getSafeTextValue("id", "undef") + ".description", pluginDescriptionNode_p.getSafeTextValue("Description", "[undef]"));
    }

    @Override
    public String getLocalizedPluginDescription(String strID_p) {
        try {
            OwXMLUtil pluginDescriptionNode = this.getPlugin(strID_p);
            if (pluginDescriptionNode != null) {
                return this.getLocalizedPluginDescription(pluginDescriptionNode);
            }
            return strID_p;
        }
        catch (Exception e) {
            return strID_p;
        }
    }

    public void refreshStaticConfiguration() throws OwConfigurationException {
        OwConfiguration.applicationInitalize(this.m_Context);
    }

    @Override
    public int attributecount() {
        OwMandator mandator = this.m_theMandatorManager.getUserMandator();
        if (null == mandator) {
            return 0;
        }
        return mandator.attributecount();
    }

    @Override
    public Object getAttribute(int index_p) throws Exception {
        OwMandator mandator = this.m_theMandatorManager.getUserMandator();
        if (null == mandator) {
            String msg = "OwConfiguration.getAttribute(int index_p): No User Mandator found by the MandatorManager, OwMandator == null / index_p = " + index_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return mandator.getAttribute(index_p);
    }

    @Override
    public Object getAttribute(String strName_p) throws Exception {
        OwMandator mandator = this.m_theMandatorManager.getUserMandator();
        if (null == mandator) {
            String msg = "OwConfiguration.getAttribute(String strName_p): No User Mandator found by the MandatorManager, OwMandator == null / strName_p = " + strName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return mandator.getAttribute(strName_p);
    }

    @Override
    public Collection getAttributeNames() {
        OwMandator mandator = this.m_theMandatorManager.getUserMandator();
        if (null == mandator) {
            return new Vector();
        }
        return mandator.getAttributeNames();
    }

    @Override
    public Object getSafeAttribute(String strName_p, Object default_p) {
        OwMandator mandator = this.m_theMandatorManager.getUserMandator();
        if (null == mandator) {
            return default_p;
        }
        return mandator.getSafeAttribute(strName_p, default_p);
    }

    @Override
    public boolean hasAttribute(String strName_p) {
        OwMandator mandator = this.m_theMandatorManager.getUserMandator();
        if (null == mandator) {
            return false;
        }
        return mandator.hasAttribute(strName_p);
    }

    public String getComboboxRendererClassName() {
        if (this.m_comboboxRendererClassName == null) {
            try {
                OwXMLUtil bootstrapManagerConfiguration = this.getBootstrapConfiguration();
                Node subnode = bootstrapManagerConfiguration.getSubNode(COMBOBOX_RENDERER_CLASS_NAME_ELEMENT);
                if (subnode != null) {
                    OwStandardXMLUtil rendererClassNameElement = new OwStandardXMLUtil(subnode);
                    this.m_comboboxRendererClassName = rendererClassNameElement.getSafeTextValue(OwClassicComboboxRenderer.class.getName());
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cannot find the element ComboboxRendererClassName. Default combobox renderer class name will be used.");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot find the element ComboboxRendererClassName. Default combobox renderer class name will be used.", (Throwable)e);
            }
            if (this.m_comboboxRendererClassName == null) {
                this.m_comboboxRendererClassName = OwBaseComboboxRenderer.class.getName();
            }
        }
        return this.m_comboboxRendererClassName;
    }

    public boolean isDynamicSplitInUse() {
        boolean result = false;
        OwXMLUtil bootstrapConfig = this.getBootstrapConfiguration();
        try {
            OwXMLUtil ajaxLayout = bootstrapConfig.getSubUtil("AjaxLayout");
            if (ajaxLayout != null) {
                result = ajaxLayout.getSafeBooleanValue("UseDynamicSplit", false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getLayoutConfigurationBagPrefix() {
        String result = LAYOUT_SETTINGS_BAG_ID_PREFIX;
        OwXMLUtil bootstrapConfig = this.getBootstrapConfiguration();
        try {
            OwXMLUtil ajaxLayout = bootstrapConfig.getSubUtil("AjaxLayout");
            if (ajaxLayout != null) {
                result = ajaxLayout.getSafeTextValue("AttributeBagPrefix", result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isUseExtJsForDragAndDrop() {
        OwXMLUtil bootstrapConfig = this.getBootstrapConfiguration();
        boolean result = bootstrapConfig.getSafeBooleanValue("UseExtJsForDragAndDrop", true);
        return result;
    }

    public Set<OwContextBasedUOListenerFactory> getUserOperationListenerFactories() throws Exception {
        if (this.listenerFactories == null) {
            List list;
            LinkedHashSet<OwContextBasedUOListenerFactory> result = null;
            OwXMLUtil bootstrapConfiguration = this.getBootstrapConfiguration();
            OwXMLUtil ecmAdapterUtil = bootstrapConfiguration.getSubUtil(ECM_ADAPTER_ELEMENT);
            OwXMLUtil listenersNode = ecmAdapterUtil.getSubUtil("UserOperationListeners");
            if (listenersNode != null && (list = listenersNode.getSafeNodeList()).size() > 0) {
                result = new LinkedHashSet<OwContextBasedUOListenerFactory>();
                for (int i = 0; i < list.size(); ++i) {
                    Node theNode = (Node)list.get(i);
                    try {
                        NamedNodeMap attrs = theNode.getAttributes();
                        String className = attrs.getNamedItem("className").getNodeValue();
                        Class<?> factoryClass = Class.forName(className);
                        if (!OwContextBasedUOListenerFactory.class.isAssignableFrom(factoryClass)) continue;
                        Constructor<?> c = factoryClass.getConstructor(this.m_Context.getClass());
                        OwContextBasedUOListenerFactory factoryInstance = (OwContextBasedUOListenerFactory)c.newInstance(this.m_Context);
                        result.add(factoryInstance);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception occurred on initialization of user operation listener <UserOperationListeners>.", (Throwable)e);
                        throw new OwConfigurationException(this.m_Context.localize("app.OwMainAppContext.useroperation.listener.configuration", "Exception occurred on initialization of user operation listener <UserOperationListeners>."), (Throwable)e);
                    }
                }
                this.listenerFactories = result;
            }
        }
        return this.listenerFactories;
    }

    public OwGlobalParametersConfiguration getGlobalParameters() {
        OwXMLUtil util = this.getBootstrapConfiguration();
        try {
            OwXMLUtil global = util.getSubUtil(GLOBAL_PARAMETERS_ELEMENT);
            if (global != null) {
                util = global;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to get <globalParameters> element from bootstrap", (Throwable)e);
        }
        return new OwGlobalParametersConfiguration(util);
    }

    protected class OwErrorView
    extends OwView {
        private Exception m_exception;
        private String m_strTitle;

        public Exception getException() {
            return this.m_exception;
        }

        public OwErrorView(Exception e_p, String strTitle_p) {
            this.m_exception = e_p;
            this.m_strTitle = strTitle_p;
        }

        @Override
        public String getIcon() throws Exception {
            return OwConfiguration.this.m_Context.getDesignURL() + "/images/masterplugin_error.png";
        }

        @Override
        public String getTitle() {
            return this.m_strTitle;
        }

        @Override
        protected void onRender(Writer w_p) throws Exception {
            OwExceptionManager.PrintCatchedException(OwConfiguration.this.m_Context.getLocale(), this.m_exception, new PrintWriter(w_p), "OwErrorStack");
        }
    }

    public class OwMasterPluginInstance
    implements OwPlugin {
        private OwXMLUtil m_configNode;
        private OwView m_view;

        public OwMasterPluginInstance(Exception e_p, OwXMLUtil configNode_p) {
            this.m_view = this.getErrorView(e_p, OwConfiguration.this.getLocalizedPluginTitle(configNode_p));
            this.m_configNode = configNode_p;
        }

        public OwMasterPluginInstance(OwMasterView view_p, OwMasterDocument doc_p, OwXMLUtil configNode_p) throws Exception {
            this.m_view = view_p;
            this.m_configNode = configNode_p;
            doc_p.setPlugin(this);
            OwConfiguration.this.m_Context.removeTarget(this.getDocID());
            doc_p.attach(OwConfiguration.this.m_Context, this.getDocID());
            if (view_p != null) {
                view_p.setDocument(doc_p);
            }
        }

        public OwView getView() {
            return this.m_view;
        }

        public OwMasterDocument getDocument() {
            return (OwMasterDocument)OwConfiguration.this.m_Context.getEventTarget(this.getDocID());
        }

        @Override
        public String getPluginTitle() {
            return OwConfiguration.this.getLocalizedPluginTitle(this.m_configNode);
        }

        @Override
        public String getPluginID() {
            return this.m_configNode.getSafeTextValue("id", null);
        }

        public String getViewID() {
            if (this.getPluginID() == null) {
                return null;
            }
            return this.getPluginID() + OwConfiguration.MAIN_PLUGIN_VIEW_ID_EXTENSION;
        }

        public String getDocID() {
            if (this.getPluginID() == null) {
                return null;
            }
            return this.getPluginID() + OwConfiguration.MAIN_PLUGIN_DOCUMENT_ID_EXTENSION;
        }

        public OwView getErrorView(Exception e_p, String strTitle_p) {
            return new OwErrorView(e_p, strTitle_p);
        }

        public String getPluginClassName() {
            return this.m_configNode.getSafeTextValue("ClassName", null);
        }

        @Override
        public String getPluginTypeDisplayName() {
            return OwBaseConfiguration.getPluginTypeDisplayName(this.getPluginType(), OwConfiguration.this.m_Context.getLocale());
        }

        @Override
        public OwXMLUtil getConfigNode() {
            return this.m_configNode;
        }

        @Override
        public String getPluginType() {
            return "ow_master";
        }

        @Override
        public String getIcon() throws Exception {
            return OwConfiguration.this.m_Context.getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/masterplugin.png");
        }
    }
}

