/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.List;

public class OwGlobalParametersConfiguration {
    private OwXMLUtil root;

    public OwGlobalParametersConfiguration(OwXMLUtil root) {
        this.root = root;
    }

    public boolean getSafeBoolean(String paramName, boolean defaultValue) {
        String value;
        OwXMLUtil util = this.getXMLUtil(paramName);
        if (util != null && (value = util.getSafeTextValue(null)) != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public int getSafeInteger(String paramName, int defaultValue) {
        String value;
        OwXMLUtil util = this.getXMLUtil(paramName);
        if (util != null && (value = util.getSafeTextValue(null)) != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getSafeString(String paramName, String defaultValue) {
        OwXMLUtil util = this.getXMLUtil(paramName);
        if (util != null) {
            return util.getSafeTextValue(defaultValue);
        }
        return defaultValue;
    }

    protected OwXMLUtil getXMLUtil(String paramName) {
        if (this.root != null) {
            List utils = this.root.getSafeUtilList(null);
            for (OwXMLUtil util : utils) {
                String name;
                if (!"param".equals(util.getName()) || (name = util.getSafeStringAttributeValue("name", null)) == null || !name.equals(paramName)) continue;
                return util;
            }
        }
        return null;
    }
}

