/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class OwJspFormConfigurator {
    private Map<String, String> m_formsClasses = new HashMap<String, String>();
    private static final String DESCRIPTION_KEY_CLASSES = "objectclasses";
    private static final String JSP_FORMS_TAG = "JspForms";
    private static final String JSP_PAGE = "JspPage";
    private static final String JSP_FORMULAR_BACKWARD_COMPATIBILITY_ELEMENT = "FormJspPage";
    private static final String JSP_FORMULAR_ELEMENT = "JspForm";
    private static final String ALL_CLASSES_DEFINED = "Default";
    private boolean m_defaultJSPPage = false;

    public OwJspFormConfigurator(String singleForm_p) {
        if (singleForm_p != null) {
            this.m_formsClasses.put(ALL_CLASSES_DEFINED, singleForm_p);
            this.m_defaultJSPPage = true;
        }
    }

    public OwJspFormConfigurator(OwXMLUtil node_p) throws Exception {
        this.m_formsClasses = this.configurationReader(node_p);
    }

    public String getJspForm(String objectclassname_p) {
        String jspForm = this.m_formsClasses.get(objectclassname_p);
        if (jspForm == null && this.m_defaultJSPPage) {
            jspForm = this.m_formsClasses.get(ALL_CLASSES_DEFINED);
        }
        return jspForm;
    }

    private Map<String, String> configurationReader(OwXMLUtil node_p) throws Exception {
        List jspForms;
        String jspPage = null;
        List supportedClassList = null;
        HashMap<String, String> retMap = new HashMap<String, String>();
        supportedClassList = node_p.getSafeStringList(DESCRIPTION_KEY_CLASSES);
        if (supportedClassList.size() > 0) {
            for (int j = 0; j < supportedClassList.size(); ++j) {
                String objclass = (String)supportedClassList.get(j);
                jspPage = this.getJspPage(node_p);
                if (jspPage == null) continue;
                retMap.put(objclass, jspPage);
            }
        } else {
            jspPage = this.getJspPage(node_p);
            if (jspPage != null) {
                this.m_defaultJSPPage = true;
                retMap.put(ALL_CLASSES_DEFINED, jspPage);
            }
        }
        if ((jspForms = node_p.getSafeNodeList(JSP_FORMS_TAG)).size() > 0) {
            Iterator it = jspForms.iterator();
            while (it.hasNext()) {
                OwStandardXMLUtil config = new OwStandardXMLUtil((Node)it.next());
                supportedClassList = config.getSafeStringList(DESCRIPTION_KEY_CLASSES);
                if (supportedClassList != null && supportedClassList.size() > 0) {
                    for (int j = 0; j < supportedClassList.size(); ++j) {
                        String objclass = (String)supportedClassList.get(j);
                        jspPage = config.getSafeTextValue(JSP_PAGE, null);
                        if (jspPage == null) continue;
                        retMap.put(objclass, jspPage);
                    }
                    continue;
                }
                jspPage = config.getSafeTextValue(JSP_PAGE, null);
                if (jspPage == null) continue;
                retMap.put(ALL_CLASSES_DEFINED, jspPage);
                this.m_defaultJSPPage = true;
            }
        }
        return retMap;
    }

    private String getJspPage(OwXMLUtil node_p) {
        boolean jspPageSet = false;
        String jspPage = node_p.getSafeTextValue(JSP_FORMULAR_ELEMENT, null);
        if (jspPage != null && jspPage.trim().length() == 0) {
            jspPage = null;
            jspPageSet = true;
        }
        if (jspPage == null && !jspPageSet && (jspPage = node_p.getSafeTextValue(JSP_FORMULAR_BACKWARD_COMPATIBILITY_ELEMENT, null)) != null && jspPage.trim().length() == 0) {
            jspPage = null;
        }
        return jspPage;
    }

    public boolean isJspFormEnabled() {
        return !this.m_formsClasses.isEmpty();
    }
}

