/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.log.OwLogCore;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwMessageBox
extends OwStandardDialog {
    private static final String NO_EVENT = "No";
    private static final String CANCEL_EVENT = "Cancel";
    private static final String YES_EVENT = "Yes";
    private static final String OK_EVENT = "OK";
    private static final Logger LOG = OwLogCore.getLogger(OwMessageBox.class);
    public static final int TYPE_OK = 0;
    public static final int TYPE_CANCEL = 1;
    public static final int TYPE_OK_CANCEL = 2;
    public static final int TYPE_YES_NO = 3;
    public static final int TYPE_YES_NO_CANCEL = 4;
    public static final int ICON_TYPE_QUESTION = 0;
    public static final int ICON_TYPE_EXCLAMATION = 1;
    public static final int ICON_TYPE_WARNING = 2;
    public static final int ICON_TYPE_INFO = 3;
    public static final int ACTION_STYLE_LINK = 1;
    public static final int ACTION_STYLE_BUTTON = 2;
    private int m_type;
    private int m_actionStyle;
    private String m_strText;
    private int m_icontype;

    public OwMessageBox(int type_p, int icontype_p, String strTitle_p, String strText_p) {
        this(type_p, 1, icontype_p, strTitle_p, strText_p);
    }

    public OwMessageBox(int type_p, int actionStyle_p, int icontype_p, String strTitle_p, String strText_p) {
        this.m_actionStyle = actionStyle_p == 1 || actionStyle_p == 2 ? actionStyle_p : 1;
        this.m_type = type_p;
        this.m_icontype = icontype_p;
        this.m_strText = strText_p;
        this.setTitle(strTitle_p);
    }

    @Override
    public void init() throws Exception {
        switch (this.m_icontype) {
            case 0: {
                this.setInfoIcon(this.getContext().getDesignURL() + "/images/OwMessageBox/iconquestion.png");
                break;
            }
            case 1: {
                this.setInfoIcon(this.getContext().getDesignURL() + "/images/OwMessageBox/iconexclamation.png");
                break;
            }
            case 2: {
                this.setInfoIcon(this.getContext().getDesignURL() + "/images/OwMessageBox/iconwarning.png");
                break;
            }
            case 3: {
                this.setInfoIcon(this.getContext().getDesignURL() + "/images/OwMessageBox/iconinfo.png");
            }
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                w_p.write("<div class=\"OwMessageBoxText\" >" + this.m_strText + "</div>");
                w_p.write("<div class=\"OwMessageBoxButton\" >");
                switch (this.m_type) {
                    case 2: {
                        String okEvent = OK_EVENT;
                        String okEventDisplayName = this.getContext().localize("app.OwMessageBox.ok", "&nbsp;&nbsp;&nbsp;&nbsp;OK&nbsp;&nbsp;&nbsp;&nbsp;");
                        String cancelEvent = CANCEL_EVENT;
                        String cancelEventDisplayName = this.getContext().localize("app.OwMessageBox.cancel", CANCEL_EVENT);
                        w_p.write(this.createEvent(okEvent, okEventDisplayName));
                        w_p.write("&nbsp;&nbsp;");
                        w_p.write(this.createEvent(cancelEvent, cancelEventDisplayName));
                        break;
                    }
                    case 0: {
                        String okEvent = OK_EVENT;
                        String okEventDisplayName = this.getContext().localize("app.OwMessageBox.ok", "&nbsp;&nbsp;&nbsp;&nbsp;OK&nbsp;&nbsp;&nbsp;&nbsp;");
                        w_p.write(this.createEvent(okEvent, okEventDisplayName));
                        break;
                    }
                    case 1: {
                        String cancelEvent = CANCEL_EVENT;
                        String cancelEventDisplayName = this.getContext().localize("app.OwMessageBox.cancel", CANCEL_EVENT);
                        w_p.write(this.createEvent(cancelEvent, cancelEventDisplayName));
                        break;
                    }
                    case 4: {
                        String yesEvent = YES_EVENT;
                        String yesEventDisplayName = this.getContext().localize("app.OwMessageBox.yes", "&nbsp;&nbsp;&nbsp;&nbsp;Yes&nbsp;&nbsp;&nbsp;&nbsp;");
                        String noEvent = NO_EVENT;
                        String noEventDisplayName = this.getContext().localize("app.OwMessageBox.no", "&nbsp;&nbsp;&nbsp;&nbsp;No&nbsp;&nbsp;&nbsp;&nbsp;");
                        String cancelEvent = CANCEL_EVENT;
                        String cancelEventDisplayName = this.getContext().localize("app.OwMessageBox.cancel", CANCEL_EVENT);
                        w_p.write(this.createEvent(yesEvent, yesEventDisplayName));
                        w_p.write("&nbsp;&nbsp;");
                        w_p.write(this.createEvent(noEvent, noEventDisplayName));
                        w_p.write("&nbsp;&nbsp;");
                        w_p.write(this.createEvent(cancelEvent, cancelEventDisplayName));
                        break;
                    }
                    case 3: {
                        String yesEvent = YES_EVENT;
                        String yesEventDisplayName = this.getContext().localize("app.OwMessageBox.yes", "&nbsp;&nbsp;&nbsp;&nbsp;Yes&nbsp;&nbsp;&nbsp;&nbsp;");
                        String noEvent = NO_EVENT;
                        String noEventDisplayName = this.getContext().localize("app.OwMessageBox.no", "&nbsp;&nbsp;&nbsp;&nbsp;No&nbsp;&nbsp;&nbsp;&nbsp;");
                        w_p.write(this.createEvent(yesEvent, yesEventDisplayName));
                        w_p.write("&nbsp;&nbsp;");
                        w_p.write(this.createEvent(noEvent, noEventDisplayName));
                        break;
                    }
                }
                w_p.write("</div>");
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    private String createEvent(String eventName_p, String displayName_p) {
        String action;
        String eventURL = this.getEventURL(eventName_p, null);
        if (this.m_actionStyle == 1) {
            action = "<a class=\"OwMessageBoxButton\" href=\"" + eventURL + "\" ";
            action = this.addCancelBubbleSupport(eventName_p, action);
            action = action + ">" + displayName_p + "</a>";
        } else {
            action = "<input type=\"button\" value=\"" + displayName_p + "\" name=\"" + eventName_p + "\" onclick=\"document.location='" + eventURL + "'\" ";
            action = this.addCancelBubbleSupport(eventName_p, action);
            action = action + "/>";
        }
        if (YES_EVENT.equalsIgnoreCase(eventName_p) || OK_EVENT.equalsIgnoreCase(eventName_p)) {
            try {
                this.getContext().registerKeyFormEvent(13, 0, eventURL, null, displayName_p);
            }
            catch (Exception e) {
                LOG.error((Object)("OwMessageBox.createEvent: Cannot register key for event: " + eventName_p), (Throwable)e);
            }
        }
        return action;
    }

    private String addCancelBubbleSupport(String eventName_p, String action_p) {
        if (NO_EVENT.equalsIgnoreCase(eventName_p) || CANCEL_EVENT.equalsIgnoreCase(eventName_p)) {
            action_p = action_p + " onkeydown='event.cancelBubble=true' ";
        }
        return action_p;
    }

    public void onOK(HttpServletRequest request_p) throws Exception {
        this.onOK();
        this.closeDialog();
    }

    public void onCancel(HttpServletRequest request_p) throws Exception {
        this.onCancel();
        this.closeDialog();
    }

    public void onYes(HttpServletRequest request_p) throws Exception {
        this.onYes();
        this.closeDialog();
    }

    public void onNo(HttpServletRequest request_p) throws Exception {
        this.onNo();
        this.closeDialog();
    }

    public void onOK() throws Exception {
    }

    public void onCancel() throws Exception {
    }

    public void onYes() throws Exception {
    }

    public void onNo() throws Exception {
    }
}

