/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwEcmUtil;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwWindowPositions;
import com.wewebu.ow.server.app.id.viid.OwVIId;
import com.wewebu.ow.server.app.id.viid.OwVIIdFactory;
import com.wewebu.ow.server.ecm.OwFileObject;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwMimeManager
extends OwEventTarget {
    private static final Logger LOG = OwLogCore.getLogger(OwMimeManager.class);
    private static final Random RANDOM = new Random();
    protected static final OwReplaceScanner URL_REPLACE_SCANNER = new OwDownloadURLReplaceScanner();
    protected static final OwReplaceScanner PAGECOUNT_REPLACE_SCANNER = new OwPageCountReplaceScanner();
    public static final String DWL_MODE_KEY = "dwlmode";
    public static final String DMSID_KEY = "dmsid";
    public static final String CONTENT_TYPE_KEY = "cttyp";
    public static final String CONTENT_PROPERTY_KEY = "cproperty";
    public static final String CONTENT_MIMETYPE_KEY = "cmimetype";
    public static final String PAGE_KEY = "page";
    public static final String XSL_TRANSFORMATOR_KEY = "xsltrans";
    public static final String XSL_TRANSFORMATOR_ENCODING_KEY = "xslencode";
    public static final int DWL_MODE_OPEN = 1;
    public static final int DWL_MODE_SAVE_COPY = 2;
    public static final String MDI_OBJECTS_COLLECTION_ATTRIBUTE_NAME = "OwMimeManager_BrowseList";
    public static final String FILE_PREVIEW_ATTRIBUTE_NAME = "OwMimeManager_FilePreview";
    public static final String FILE_PREVIEW_ATTRIBUTE_FILENAME = "OwMimeManager_FileName";
    public static final String FILE_PREVIEW_ATTRIBUTE_MIMETYPE = "OwMimeManager_MIMEType";
    public static final String FILE_PREVIEW_DMSID = "owmimemanagerfilepreview";
    public static final String MIME_ICON_NAME = "icon";
    public static final String MIME_OPENICON_NAME = "openicon";
    public static final String MIME_DOWNLOAD_URL = "dwlurl";
    public static final String MIME_VIEWERSERLVET = "viewerservlet";
    public static final String MIME_EDITSERLVET = "editservlet";
    public static final String MIME_EVENTHANDLER = "eventhandler";
    public static final String MIME_DOCUMENTFUNCTION = "documentfunction";
    public static final String MIME_ATT_AUTOVIEWERMODE = "autoviewermode";
    public static final String MIME_ICON_SUBPATH = "/micon/";
    public static final int VIEWER_MODE_SIMPLE = 0;
    public static final int VIEWER_MODE_DEFAULT = 1;
    public static final int VIEWER_MODE_SINGLE = 2;
    public static final int VIEWER_MODE_MULTI = 3;
    public static final int VIEWER_MODE_COMPARE = 4;
    public static final int VIEWER_MODE_JAVASCRIPT = 5;
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_DMSID = "{dmsid}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL = "{serverurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_BASEURL = "{baseurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_BASEDIR = "{basedir}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_SECURITYTOKEN = "{securitytoken}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_SECURITYTOKEN_ENC = "{securitytokenenc}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PAGE_COUNT = "{pagecount}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PAGE = "{page}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_CONTENT_TYPE = "{contenttype}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_DOWNLOAD_URL = "{dwlurl}";
    public static final String REPLACE_TOKEN_VIID = "{viid}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START = "{prop";
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_ENCODE_CHAR = ':';
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_JSENCODE_CHAR = '~';
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_NOENCODE_CHAR = '#';
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END = "}";
    protected static final String OBJECT_INDEX_KEY = "oi";
    protected static final String SUBPATH_KEY = "subpath";
    public static final String SCRIPT_URL_PREFIX = "javascript:";
    public static final String MIME_TYPE_PREFIX_OW_FOLDER = "ow_folder/";
    public static final String MIME_TYPE_PREFIX_OW_DEFAULT = "ow_default/";
    public static final String MIME_TYPE_PREFIX_OW_CUSTOMOBJECT = "ow_customobject/";
    protected OwMainAppContext m_MainContext;
    protected OwConfiguration m_Configuration;
    protected OwObject m_parent;
    protected OwClientRefreshContext m_RefreshContext;
    protected boolean m_fDEBUG_ResetCalled = false;
    protected Map m_ObjectMap = new HashMap();
    protected String m_strMimeItemStyle = "OwMimeItem";
    protected String m_strMimeIconStyle = "OwMimeIcon";
    protected String undefName;
    protected String documentTitle;
    protected String objectTitle;
    protected NumberFormat m_NumberFormat;
    protected String m_mimeTypeContext = null;

    @Override
    protected void init() throws Exception {
        this.m_MainContext = (OwMainAppContext)this.getContext();
        this.m_Configuration = this.m_MainContext.getConfiguration();
        this.setUndefinedLabel(this.getContext().localize("app.OwMimeManager.undefname", "[undefined]"));
        this.documentTitle = this.getContext().localize("app.OwMimeManager.documenttitle", "Show document");
        this.objectTitle = this.getContext().localize("app.OwMimeManager.objecttitle", "Edit object");
        this.m_NumberFormat = NumberFormat.getNumberInstance(this.getContext().getLocale());
        this.m_NumberFormat.setGroupingUsed(false);
    }

    public void setIconStyle(String strMimeIconStyle_p) {
        this.m_strMimeIconStyle = strMimeIconStyle_p;
    }

    public String getIconStyle() {
        return this.m_strMimeIconStyle;
    }

    public void setItemStyle(String strMimeItemStyle_p) {
        this.m_strMimeItemStyle = strMimeItemStyle_p;
    }

    public void setUndefinedLabel(String undefLabel_p) {
        this.undefName = undefLabel_p != null ? undefLabel_p : "app.OwMimeManager.undefname";
    }

    public String getUndefinedLabel() {
        return this.undefName;
    }

    public void setMimeTypeContext(String context_p) {
        this.m_mimeTypeContext = context_p;
    }

    public String getMimeTypeContext() {
        return this.m_mimeTypeContext;
    }

    public static OwXMLUtil getMimeNode(OwConfiguration configuration_p, OwObjectReference obj_p) throws Exception {
        return OwMimeManager.getMimeNode(configuration_p, obj_p, null);
    }

    private static OwXMLUtil getMimeNode(OwConfiguration configuration_p, OwObjectReference obj_p, String context_p) throws Exception {
        OwXMLUtil mimeNode = null;
        if (context_p != null) {
            mimeNode = configuration_p.getMIMENode(context_p + ":" + obj_p.getMIMEType());
        }
        if (mimeNode == null) {
            mimeNode = configuration_p.getMIMENode(obj_p.getMIMEType());
        }
        if (mimeNode == null && (mimeNode = configuration_p.getDefaultMIMENode(obj_p.getType())) == null) {
            return new OwStandardXMLUtil();
        }
        return mimeNode;
    }

    public static String getMimeIcon(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        OwXMLUtil MimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p);
        StringBuilder iconpath = new StringBuilder();
        iconpath.append(context_p.getDesignURL());
        iconpath.append(MIME_ICON_SUBPATH);
        iconpath.append(MimeNode.getSafeTextValue(MIME_ICON_NAME, "unknown.png"));
        return iconpath.toString();
    }

    public void insertIconLink(Writer w_p, OwObjectReference obj_p, String subpath_p) throws Exception {
        this.insertIconLink(w_p, obj_p, subpath_p, 1);
    }

    public void insertIconLink(Writer w_p, OwObjectReference obj_p, String subpath_p, int page_p) throws Exception {
        StringBuffer link = this.createIconLink(obj_p);
        this.insertHtmlLink(w_p, link.toString(), obj_p, subpath_p, page_p);
    }

    protected StringBuffer createIconLink(OwObjectReference obj_p) throws Exception {
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(this.m_Configuration, obj_p);
        String strViewServlet = mimeNode.getSafeTextValue(MIME_VIEWERSERLVET, null);
        String tooltipText = "";
        StringWriter w_p = new StringWriter();
        if (strViewServlet != null) {
            if (obj_p.hasContent(1) || mimeNode.getSafeBooleanAttributeValue("nocontentcheck", false)) {
                int iViewerMode = mimeNode.getSafeIntegerAttributeValue(MIME_ATT_AUTOVIEWERMODE, 0);
                switch (iViewerMode) {
                    default: {
                        OwHTMLHelper.writeSecureHTML(w_p, this.documentTitle);
                        w_p.write(" (");
                        OwHTMLHelper.writeSecureHTML(w_p, obj_p.getMIMEType());
                        w_p.write(")");
                        break;
                    }
                    case 0: {
                        OwHTMLHelper.writeSecureHTML(w_p, this.documentTitle);
                        w_p.write(" (");
                        OwHTMLHelper.writeSecureHTML(w_p, obj_p.getMIMEType());
                        w_p.write(")");
                        break;
                    }
                }
            }
        } else {
            String strEventHandler = mimeNode.getSafeTextValue(MIME_EVENTHANDLER, null);
            String strDocumentFunction = mimeNode.getSafeTextValue(MIME_DOCUMENTFUNCTION, null);
            if (strEventHandler != null || strDocumentFunction != null) {
                OwHTMLHelper.writeSecureHTML(w_p, this.objectTitle);
            }
        }
        tooltipText = w_p.toString();
        StringBuffer link = new StringBuffer("<img src=\"");
        link.append(this.m_MainContext.getDesignURL());
        link.append(MIME_ICON_SUBPATH);
        link.append(mimeNode.getSafeTextValue(MIME_ICON_NAME, "unknown.png"));
        link.append("\" border=\"0\" class=\"");
        link.append(this.m_strMimeIconStyle);
        link.append("\" alt=\"").append(tooltipText).append("\" title=\"").append(tooltipText).append("\" draggable=\"false\" />");
        return link;
    }

    public void insertIconLink(Writer w_p, OwObjectReference obj_p) throws Exception {
        StringBuffer link = this.createIconLink(obj_p);
        this.insertHtmlLink(w_p, link.toString(), obj_p, null);
    }

    public static String getDownloadURL(OwMainAppContext context_p, OwObjectReference obj_p, int iContentType_p, int iPage_p, OwXMLUtil mimeNode_p) throws Exception {
        String strDownloadURLPattern = mimeNode_p.getSafeTextValue(MIME_DOWNLOAD_URL, null);
        if (strDownloadURLPattern != null) {
            return OwMimeManager.getServletReplacedTokenString(strDownloadURLPattern, context_p, obj_p, mimeNode_p, iPage_p, iContentType_p);
        }
        return OwMimeManager.getDefaultDownloadURL(context_p, obj_p, 1, iPage_p);
    }

    protected static String getDefaultDownloadURL(OwMainAppContext context_p, OwObjectReference obj_p, int iContentType_p, int iPage_p) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(context_p.getBaseURL());
        buf.append("/getContent?");
        buf.append(DMSID_KEY);
        buf.append("=");
        buf.append(OwAppContext.encodeURL(obj_p.getDMSID()));
        buf.append("&");
        buf.append(CONTENT_TYPE_KEY);
        buf.append("=");
        buf.append(iContentType_p);
        buf.append("&");
        buf.append(PAGE_KEY);
        buf.append("=");
        buf.append(iPage_p);
        return buf.toString();
    }

    private static String retrieveValue(OwProperty property_p) throws Exception {
        OwPropertyClass propertyClass = property_p.getPropertyClass();
        String javaClassName = propertyClass.getJavaClassName();
        Object value = property_p.getValue();
        if (value == null) {
            throw new NullPointerException("null property value can not be converted to String!");
        }
        if ("com.wewebu.ow.server.ecm.OwObject".equals(javaClassName)) {
            OwObject owObject = (OwObject)value;
            return owObject.getDMSID();
        }
        return value.toString();
    }

    protected static String replaceProperties(OwMainAppContext context_p, String strIn_p, OwObjectReference obj_p) throws Exception {
        int iIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START);
        if (-1 == iIndex) {
            return strIn_p;
        }
        OwObject obj = obj_p.getInstance();
        int iOldIndex = 0;
        StringBuilder strRet = new StringBuilder();
        while (-1 != iIndex) {
            String stringValue;
            OwProperty property;
            strRet.append(strIn_p.substring(iOldIndex, iIndex));
            ++iIndex;
            int iEnd = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END, iIndex += VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START.length());
            String strPropName = strIn_p.substring(iIndex, iEnd);
            if (strIn_p.charAt(iIndex - 1) == ':') {
                try {
                    property = obj.getProperty(strPropName);
                    stringValue = OwMimeManager.retrieveValue(property);
                    strRet.append(OwAppContext.encodeURL(stringValue));
                }
                catch (Exception e) {
                    LOG.debug((Object)"OwMimeManager.replaceProperties(): Error getting, replacing or appending URL encoded property...", (Throwable)e);
                }
            } else if (strIn_p.charAt(iIndex - 1) == '~') {
                try {
                    property = obj.getProperty(strPropName);
                    String valueString = OwMimeManager.retrieveValue(property);
                    strRet.append(OwHTMLHelper.encodeJavascriptString(valueString, true));
                }
                catch (Exception e) {
                    LOG.debug((Object)"OwMimeManager.replaceProperties(): Error getting, replacing or appending JavaScript encoded property...", (Throwable)e);
                }
            } else {
                try {
                    property = obj.getProperty(strPropName);
                    stringValue = OwMimeManager.retrieveValue(property);
                    strRet.append(stringValue);
                }
                catch (Exception e) {
                    LOG.debug((Object)"OwMimeManager.replaceProperties(): Error getting or appending unencoded property...", (Throwable)e);
                }
            }
            iOldIndex = iIndex = iEnd + 1;
            iIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START, iIndex);
        }
        if (iOldIndex <= strIn_p.length()) {
            strRet.append(strIn_p.substring(iOldIndex, strIn_p.length()));
        }
        return strRet.toString();
    }

    public void insertTextLink(Writer w_p, String strDisplayName_p, OwObjectReference obj_p) throws Exception {
        this.insertTextLink(w_p, strDisplayName_p, obj_p, null, 1);
    }

    public void insertTextLink(Writer w_p, String strDisplayName_p, OwObjectReference obj_p, String subpath_p) throws Exception {
        this.insertTextLink(w_p, strDisplayName_p, obj_p, subpath_p, 1);
    }

    public void insertTextLink(Writer w_p, String strDisplayName_p, OwObjectReference obj_p, String subpath_p, int page_p) throws Exception {
        if (strDisplayName_p == null) {
            strDisplayName_p = this.getUndefinedLabel();
        }
        String formattedDisplayName = strDisplayName_p;
        try {
            formattedDisplayName = this.getNumberFormater().format(Double.parseDouble(strDisplayName_p));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        StringWriter sw = new StringWriter();
        OwHTMLHelper.writeSecureHTML(sw, formattedDisplayName);
        this.insertHtmlLink(w_p, sw.toString(), obj_p, subpath_p, page_p);
    }

    public void insertHtmlLink(Writer w_p, String strHtmlCode_p, OwObjectReference obj_p, String subpath_p) throws Exception {
        this.insertHtmlLink(w_p, strHtmlCode_p, obj_p, subpath_p, 1);
    }

    public void insertHtmlLink(Writer w_p, String strHtmlCode_p, OwObjectReference obj_p, String subpath_p, int page_p) throws Exception {
        if (strHtmlCode_p == null) {
            strHtmlCode_p = "";
        }
        if (!this.m_fDEBUG_ResetCalled) {
            throw new OwInvalidOperationException("OwMimeManager.insertHtmlLink: Used MimeManager without reseting the map. Did you call OwMimeManager.Reset() in your onRender method?");
        }
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(this.m_Configuration, obj_p, this.m_mimeTypeContext);
        String strViewServlet = mimeNode.getSafeTextValue(MIME_VIEWERSERLVET, null);
        int iViewerMode = mimeNode.getSafeIntegerAttributeValue(MIME_ATT_AUTOVIEWERMODE, 0);
        if (strViewServlet != null) {
            if (strViewServlet.indexOf(34) > 0) {
                strViewServlet = strViewServlet.replaceAll("[\"]", "%22");
            }
            if (obj_p.hasContent(1) || mimeNode.getSafeBooleanAttributeValue("nocontentcheck", false)) {
                String strURL = OwMimeManager.getServletReplacedTokenString(strViewServlet, this.m_MainContext, obj_p, mimeNode, page_p);
                switch (iViewerMode) {
                    default: {
                        w_p.write("<a title=\"");
                        OwHTMLHelper.writeSecureHTML(w_p, this.documentTitle);
                        w_p.write(" (");
                        OwHTMLHelper.writeSecureHTML(w_p, obj_p.getMIMEType());
                        w_p.write(")");
                        w_p.write("\" href=\"");
                        w_p.write(SCRIPT_URL_PREFIX + OwMimeManager.getAutoViewerScript(this.m_MainContext, strURL, iViewerMode, obj_p.getDMSID(), obj_p.getDMSID(), page_p));
                        w_p.write("\" class=\"");
                        w_p.write("OwMimeItem");
                        w_p.write("\">");
                        w_p.write(strHtmlCode_p);
                        w_p.write("</a>");
                        w_p.write("<span class=\"accessibility\">&nbsp;");
                        w_p.write(this.m_MainContext.localize("app.OwMimeManager.anchor.target.jsopen.warning", "(This link will open a new window)"));
                        w_p.write("</span>");
                        break;
                    }
                    case 0: {
                        w_p.write("<a target=\"_new\" title=\"");
                        OwHTMLHelper.writeSecureHTML(w_p, this.documentTitle);
                        w_p.write(" (");
                        OwHTMLHelper.writeSecureHTML(w_p, obj_p.getMIMEType());
                        w_p.write(")");
                        w_p.write("\" href=\"");
                        w_p.write(strURL);
                        w_p.write("\" class=\"");
                        w_p.write("OwMimeItem");
                        w_p.write("\">");
                        w_p.write(strHtmlCode_p);
                        w_p.write("</a>");
                        w_p.write("<span class=\"accessibility\">&nbsp;");
                        w_p.write(this.m_MainContext.localize("app.OwMimeManager.anchor.target.new.warning", "(This link will open a new window, if no window with the same title has already been opened)"));
                        w_p.write("</span>");
                        break;
                    }
                }
            } else {
                w_p.write(strHtmlCode_p);
            }
            return;
        }
        this.registerObject(obj_p);
        String strEventHandler = mimeNode.getSafeTextValue(MIME_EVENTHANDLER, null);
        if (strEventHandler != null) {
            subpath_p = OwAppContext.encodeURL(subpath_p);
            String strURL = this.createLinkUrl("PluginEventHandler", obj_p, subpath_p);
            w_p.write("<a title=\"");
            OwHTMLHelper.writeSecureHTML(w_p, this.objectTitle);
            w_p.write("\" href=\"");
            w_p.write(strURL);
            w_p.write("\" class='");
            OwHTMLHelper.writeSecureHTML(w_p, this.m_strMimeItemStyle);
            w_p.write("'>");
            w_p.write(strHtmlCode_p);
            w_p.write("</a>");
            return;
        }
        String strDocumentFunction = mimeNode.getSafeTextValue(MIME_DOCUMENTFUNCTION, null);
        if (strDocumentFunction != null) {
            subpath_p = OwAppContext.encodeURL(subpath_p);
            String strURL = this.createLinkUrl("DocumentFunctionHandler", obj_p, subpath_p);
            w_p.write("<a title=\"");
            OwHTMLHelper.writeSecureHTML(w_p, this.objectTitle);
            w_p.write("\" href=\"");
            w_p.write(strURL);
            w_p.write("\" class='");
            OwHTMLHelper.writeSecureHTML(w_p, this.m_strMimeItemStyle);
            w_p.write("'>");
            w_p.write(strHtmlCode_p);
            w_p.write("</a>");
            return;
        }
        w_p.write(strHtmlCode_p);
    }

    protected String createLinkUrl(String eventName_p, OwObjectReference obj_p, String subpath_p) {
        StringBuilder query = new StringBuilder();
        query.append(OBJECT_INDEX_KEY);
        query.append("=");
        query.append(String.valueOf(obj_p.hashCode()));
        if (null != subpath_p) {
            query.append("&");
            query.append(SUBPATH_KEY);
            query.append("=");
            query.append(subpath_p);
        }
        return this.getEventURL(eventName_p, query.toString());
    }

    public void reset() {
        this.m_ObjectMap.clear();
        this.m_fDEBUG_ResetCalled = true;
    }

    public void setParent(OwObject parent_p) {
        this.m_parent = parent_p;
    }

    public void onDocumentFunctionHandler(HttpServletRequest request_p) throws Exception {
        String strObjectKey = request_p.getParameter(OBJECT_INDEX_KEY);
        if (strObjectKey != null) {
            OwObject obj;
            OwObjectReference objRef = (OwObjectReference)this.m_ObjectMap.get(strObjectKey);
            OwDocumentFunction docfunc = OwMimeManager.getHandlerDocumentPlugin(this.m_MainContext, objRef, this.m_mimeTypeContext);
            if (docfunc.isEnabled(obj = objRef.getInstance(), this.m_parent, 2)) {
                docfunc.onClickEvent(obj, this.m_parent, this.m_RefreshContext);
            } else {
                throw new OwInvalidOperationException(this.m_MainContext.localize("app.OwMimeManager.docfuncdisabled", "The function is not available for this object."));
            }
        }
    }

    public void setRefreshContext(OwClientRefreshContext eventlister_p) {
        this.m_RefreshContext = eventlister_p;
    }

    public void onPluginEventHandler(HttpServletRequest request_p) throws Exception {
        String strObjectKey = request_p.getParameter(OBJECT_INDEX_KEY);
        String subpath = request_p.getParameter(SUBPATH_KEY);
        if (null != subpath && subpath.length() == 0) {
            subpath = null;
        }
        if (strObjectKey != null) {
            OwObjectReference objRef = (OwObjectReference)this.m_ObjectMap.get(strObjectKey);
            OwMasterDocument masterPlugin = OwMimeManager.getHandlerMasterPlugin(this.m_MainContext, objRef, this.m_mimeTypeContext);
            OwMimeManager.delegateToMasterPlugin(this.m_MainContext, masterPlugin, objRef, subpath);
        }
    }

    protected NumberFormat getNumberFormater() {
        return this.m_NumberFormat;
    }

    protected static void delegateToMasterPlugin(OwMainAppContext context_p, OwMasterDocument masterPlugin_p, OwObjectReference obj_p, String subpath_p) throws Exception {
        OwObject obj = obj_p.getInstance();
        OwXMLUtil MimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj);
        if (subpath_p == null && OwXMLDOMUtil.getSafeBooleanAttributeValue(MimeNode.getSubNode(MIME_EVENTHANDLER), "openrecord", false)) {
            List parentPathInfoList = OwEcmUtil.getParentPathOfClass(obj, context_p.getConfiguration().getRecordClassNames());
            if (parentPathInfoList.size() > 0) {
                OwEcmUtil.OwParentPathInfo pathInfo = (OwEcmUtil.OwParentPathInfo)parentPathInfoList.get(0);
                masterPlugin_p.dispatch(1, pathInfo.getParent(), pathInfo.getPath() + "/" + obj.getID());
            } else {
                masterPlugin_p.dispatch(1, obj, null);
            }
        } else {
            masterPlugin_p.dispatch(1, obj, subpath_p);
        }
        context_p.closeAllDialogs();
    }

    public static OwMasterDocument getHandlerMasterPlugin(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        return OwMimeManager.getHandlerMasterPlugin(context_p, obj_p, null);
    }

    private static OwMasterDocument getHandlerMasterPlugin(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p) throws Exception {
        OwXMLUtil MimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p, mimeContext_p);
        String strEventHandler = MimeNode.getSafeTextValue(MIME_EVENTHANDLER, null);
        if (strEventHandler != null) {
            String strType = OwXMLDOMUtil.getSafeStringAttributeValue(MimeNode.getSubNode(MIME_EVENTHANDLER), "type", "id");
            if (strType.equalsIgnoreCase("id")) {
                OwMasterDocument masterPlugin = (OwMasterDocument)context_p.getEventTarget(strEventHandler);
                if (null == masterPlugin) {
                    String msg = "OwMimeManager.getHandlerMasterPlugin: The MIME type handler could not be found. Please ensure that the master plugin is installed and plugin-id has appendix .Doc in owmimetable.xml, name = " + strEventHandler;
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(context_p.localize("app.OwMimeManager.handlerundefined", "The MIME type handler could not be found. Please ensure that the Master Plugin is installed and plugin ID has appendix .Doc in owmimetable.xml:") + strEventHandler);
                }
                return masterPlugin;
            }
            for (OwConfiguration.OwMasterPluginInstance inst : context_p.getConfiguration().getMasterPlugins(false)) {
                if (!inst.getPluginClassName().equals(strEventHandler)) continue;
                return inst.getDocument();
            }
            String msg = "OwMimeManager.getHandlerMasterPlugin: The MIME type handler could not be found. Please ensure that the master plugin is installed, name = " + strEventHandler;
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(context_p.localize("app.OwMimeManager.handlerundefined", "The MIME type handler could not be found. Please ensure that the Master Plugin is installed and plugin ID has appendix .Doc in owmimetable.xml:") + strEventHandler);
        }
        return null;
    }

    public static OwDocumentFunction getHandlerDocumentPlugin(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        return OwMimeManager.getHandlerDocumentPlugin(context_p, obj_p, null);
    }

    private static OwDocumentFunction getHandlerDocumentPlugin(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p) throws Exception {
        OwXMLUtil MimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p, mimeContext_p);
        String strDocumentFunction = MimeNode.getSafeTextValue(MIME_DOCUMENTFUNCTION, null);
        if (strDocumentFunction != null) {
            try {
                return context_p.getConfiguration().getDocumentFunction(strDocumentFunction);
            }
            catch (Exception e) {
                throw new OwConfigurationException(context_p.localize("app.OwMimeManager.handlerundefined", "The MIME type handler could not be found. Please ensure that the Master Plugin is installed and plugin ID has appendix .Doc in owmimetable.xml:") + strDocumentFunction, (Throwable)e);
            }
        }
        return null;
    }

    public static void openObject(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p, String mimeContext_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, false, refreshCtx_p, 1, context_p.getWindowPositions(), null, null, mimeContext_p);
    }

    public static void openObject(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, refreshCtx_p, null);
    }

    public static void openObjectPreview(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, true, refreshCtx_p, 1, context_p.getWindowPositions(), null, null, null);
    }

    public static void openObject(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p, int iPage_p, OwWindowPositions windowpos_p, Collection objects_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, false, refreshCtx_p, 1, windowpos_p, objects_p, null, null);
    }

    public static void openObject(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p, int iPage_p, OwWindowPositions windowpos_p, Collection objects_p, String additionalParams_p, String mimeContext_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, false, refreshCtx_p, 1, windowpos_p, objects_p, additionalParams_p, mimeContext_p);
    }

    public static void openObject(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p, int iPage_p, OwWindowPositions windowpos_p, Collection objects_p, String additionalParams_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, refreshCtx_p, iPage_p, windowpos_p, objects_p, additionalParams_p, null);
    }

    public static void openObjectPreview(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, OwClientRefreshContext refreshCtx_p, int iPage_p, OwWindowPositions windowpos_p, Collection objects_p) throws Exception {
        OwMimeManager.openObject(context_p, obj_p, parent_p, iViewerMode_p, true, refreshCtx_p, 1, context_p.getWindowPositions(), objects_p, null, null);
    }

    private static void openObject(OwMainAppContext context_p, OwObjectReference obj_p, OwObject parent_p, int iViewerMode_p, boolean fPreviewMode_p, OwClientRefreshContext refreshCtx_p, int iPage_p, OwWindowPositions windowpos_p, Collection objects_p, String additionalParams_p, String mimeContext_p) throws Exception {
        if (OwMimeManager.isObjectDownloadable(context_p, obj_p, mimeContext_p)) {
            context_p.getHttpSession().setAttribute(MDI_OBJECTS_COLLECTION_ATTRIBUTE_NAME, (Object)objects_p);
            OwOpenCommand scmd = OwMimeManager.getOpenCommand(context_p, obj_p, mimeContext_p, additionalParams_p);
            context_p.addFinalScript("\n" + scmd.getScript(iViewerMode_p, windowpos_p, fPreviewMode_p));
            return;
        }
        OwDocumentFunction docfunction = OwMimeManager.getHandlerDocumentPlugin(context_p, obj_p, mimeContext_p);
        if (null != docfunction) {
            OwObject obj = obj_p.getInstance();
            if (!docfunction.isEnabled(obj, parent_p, 2)) {
                throw new OwInvalidOperationException(context_p.localize("app.OwMimeManager.docfuncdisabled", "The function is not available for this object."));
            }
            docfunction.onClickEvent(obj, parent_p, refreshCtx_p);
            return;
        }
        OwMasterDocument masterplugin = OwMimeManager.getHandlerMasterPlugin(context_p, obj_p, mimeContext_p);
        if (null != masterplugin) {
            OwMimeManager.delegateToMasterPlugin(context_p, masterplugin, obj_p, null);
            return;
        }
    }

    public static OwOpenCommand editObject(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        return OwMimeManager.editObject(context_p, obj_p, null, 1);
    }

    public static OwOpenCommand editObject(OwMainAppContext context_p, OwObjectReference obj_p, int page_p) throws Exception {
        return OwMimeManager.editObject(context_p, obj_p, null, page_p);
    }

    public static OwOpenCommand editObject(OwMainAppContext context_p, OwObjectReference obj_p, String additionalParams_p, int page_p) throws Exception {
        return new OwOpenCommand(context_p, obj_p, null, additionalParams_p, page_p, Boolean.TRUE);
    }

    public static OwOpenCommand editObject(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p, String additionalParams_p, int page_p) throws Exception {
        return new OwOpenCommand(context_p, obj_p, mimeContext_p, additionalParams_p, page_p, Boolean.TRUE);
    }

    public static void openFilePreview(OwMainAppContext context_p, String mimeType_p, String path_p) throws Exception {
        OwMimeManager.openFilePreview(context_p, path_p, mimeType_p, null, 1);
    }

    public static void openFilePreview(OwMainAppContext context_p, String mimeType_p, String path_p, String fileName_p) throws Exception {
        OwMimeManager.openFilePreview(context_p, path_p, mimeType_p, fileName_p, 1);
    }

    private static void openFilePreview(OwMainAppContext context_p, String path_p, String mimeType_p, String fileName_p, int page_p) throws Exception {
        String sURL;
        String sUrlPattern = null;
        OwFileObject obj = fileName_p == null ? new OwFileObject(context_p.getNetwork(), new File(path_p)) : new OwFileObject(context_p.getNetwork(), new File(path_p), fileName_p, mimeType_p);
        OwXMLUtil mimeNode = context_p.getConfiguration().getMIMENode(mimeType_p);
        if (mimeNode != null) {
            sUrlPattern = mimeNode.getSafeTextValue(MIME_VIEWERSERLVET, null);
            int iViewerMode = mimeNode.getSafeIntegerAttributeValue(MIME_ATT_AUTOVIEWERMODE, 0);
            if (iViewerMode == 5 || null == sUrlPattern) {
                sUrlPattern = mimeNode.getSafeTextValue(MIME_DOWNLOAD_URL, null);
            }
        }
        StringBuilder sbDownloadUrl = new StringBuilder();
        sbDownloadUrl.append(context_p.getBaseURL());
        sbDownloadUrl.append("/getContent?");
        sbDownloadUrl.append(DMSID_KEY);
        sbDownloadUrl.append("=");
        sbDownloadUrl.append(OwAppContext.encodeURL(FILE_PREVIEW_DMSID));
        sbDownloadUrl.append("&");
        sbDownloadUrl.append(CONTENT_TYPE_KEY);
        sbDownloadUrl.append("=");
        sbDownloadUrl.append(1);
        sbDownloadUrl.append("&");
        sbDownloadUrl.append(PAGE_KEY);
        sbDownloadUrl.append("=");
        sbDownloadUrl.append(page_p);
        sbDownloadUrl.append("&forceload=");
        sbDownloadUrl.append(RANDOM.nextInt());
        if (sUrlPattern != null) {
            sURL = OwString.replaceAll(sUrlPattern, VIEWER_SERVLET_REPLACE_TOKEN_DMSID, OwAppContext.encodeURL(FILE_PREVIEW_DMSID));
            sURL = OwString.replaceAll(sURL, VIEWER_SERVLET_REPLACE_TOKEN_DOWNLOAD_URL, sbDownloadUrl.toString());
            sURL = OwMimeManager.getServletReplacedTokenString(sURL, context_p, obj, mimeNode, page_p, 1);
        } else {
            sURL = sbDownloadUrl.toString();
        }
        context_p.getHttpSession().setAttribute(FILE_PREVIEW_ATTRIBUTE_NAME, (Object)path_p);
        context_p.getHttpSession().setAttribute(FILE_PREVIEW_ATTRIBUTE_FILENAME, (Object)obj.getName());
        context_p.getHttpSession().setAttribute(FILE_PREVIEW_ATTRIBUTE_MIMETYPE, (Object)obj.getMIMEType());
        context_p.addFinalScript("\n" + OwMimeManager.getAutoViewerScript(context_p, sURL, 1, FILE_PREVIEW_DMSID, FILE_PREVIEW_DMSID, page_p, context_p.getWindowPositions()));
    }

    public static boolean isObjectDownloadable(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        return OwMimeManager.isObjectDownloadable(context_p, obj_p, null);
    }

    public static boolean isObjectDownloadable(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p) throws Exception {
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p, mimeContext_p);
        return obj_p.hasContent(1) && mimeNode.getSafeTextValue(MIME_VIEWERSERLVET, null) != null;
    }

    public static String getDownloadLink(OwMainAppContext context_p, String strDisplayName_p, OwObjectReference obj_p) throws Exception {
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p);
        StringBuilder ret = new StringBuilder();
        ret.append("<a title='");
        ret.append(context_p.localize("app.OwMimeManager.savecopytooltip", "Download"));
        ret.append("' href=\"");
        ret.append(OwMimeManager.getDownloadURL(context_p, obj_p, 1, 1, mimeNode));
        ret.append("&");
        ret.append(DWL_MODE_KEY);
        ret.append("=");
        ret.append(String.valueOf(2));
        ret.append("\" class='");
        ret.append("OwMimeItem");
        ret.append("'>");
        ret.append(strDisplayName_p);
        ret.append("</a>");
        return ret.toString();
    }

    public static String getSaveDownloadURL(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p);
        StringBuilder ret = new StringBuilder();
        ret.append(OwMimeManager.getDownloadURL(context_p, obj_p, 1, 1, mimeNode));
        ret.append("&");
        ret.append(DWL_MODE_KEY);
        ret.append("=");
        ret.append(String.valueOf(2));
        return ret.toString();
    }

    public static String getDownloadURL(OwMainAppContext context_p, OwObjectReference obj_p, int iContentType_p, int iPage_p) throws Exception {
        OwXMLUtil MimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p);
        return OwMimeManager.getDownloadURL(context_p, obj_p, iContentType_p, iPage_p, MimeNode);
    }

    public static OwOpenCommand getOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p) throws Exception {
        return OwMimeManager.getOpenCommand(context_p, obj_p, null);
    }

    public static OwOpenCommand getOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String additionalParams_p) throws Exception {
        return OwMimeManager.getOpenCommand(context_p, obj_p, null, additionalParams_p);
    }

    public static OwOpenCommand getOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p, String additionalParams_p) throws Exception {
        return OwMimeManager.getOpenCommand(context_p, obj_p, mimeContext_p, additionalParams_p, 1);
    }

    public static OwOpenCommand getOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String additionalParams_p, int page_p) throws Exception {
        return OwMimeManager.getOpenCommand(context_p, obj_p, null, additionalParams_p, page_p);
    }

    public static OwOpenCommand getOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p, String additionalParams_p, int page_p) throws Exception {
        return new OwOpenCommand(context_p, obj_p, mimeContext_p, additionalParams_p, page_p);
    }

    public OwOpenCommand getOpenCommand(OwObjectReference obj_p) throws Exception {
        return new OwOpenCommand(this, obj_p, null);
    }

    public OwOpenCommand getOpenCommand(OwObjectReference obj_p, String additionalParams_p) throws Exception {
        return new OwOpenCommand(this, obj_p, additionalParams_p);
    }

    public OwOpenCommand getOpenCommand(OwObjectReference obj_p, String additionalParams_p, int page_p) throws Exception {
        return new OwOpenCommand(this, obj_p, additionalParams_p, page_p);
    }

    protected void registerObject(OwObjectReference obj_p) {
        this.m_ObjectMap.put(String.valueOf(obj_p.hashCode()), obj_p);
    }

    public static String createAutoViewerRestoreMainWindowScript(OwMainAppContext context_p, int viewermode_p) {
        return "window.resizeTo(screen.availWidth,screen.availHeight);window.moveTo(0,0);";
    }

    public static String makeViewerTitleString(String id_p) {
        StringBuilder buf = new StringBuilder(id_p.length());
        block3: for (int i = 0; i < id_p.length(); ++i) {
            char c = id_p.charAt(i);
            switch (c) {
                case ' ': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '\\': 
                case '{': 
                case '}': {
                    buf.append('_');
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private static String getViewerWindowArrangeScript(String sOpenURL_p, String sViewerName_p, String sDmsID_p, int iPage_p, OwWindowPositions windowpos_p) {
        StringBuilder ret = new StringBuilder();
        ret.append("openViewerWindowArranged('");
        ret.append(sOpenURL_p);
        ret.append("','");
        ret.append(OwMimeManager.hashViewerName(sViewerName_p));
        ret.append("','");
        ret.append(sDmsID_p);
        ret.append("',");
        ret.append(String.valueOf(iPage_p));
        ret.append(",");
        ret.append(windowpos_p.getViewerWidth());
        ret.append(",");
        ret.append(windowpos_p.getViewerHeight());
        ret.append(",");
        ret.append(windowpos_p.getViewerTopX());
        ret.append(",");
        ret.append(windowpos_p.getViewerTopY());
        ret.append(",");
        ret.append(windowpos_p.getWindowWidth());
        ret.append(",");
        ret.append(windowpos_p.getWindowHeight());
        ret.append(",");
        ret.append(windowpos_p.getWindowTopX());
        ret.append(",");
        ret.append(windowpos_p.getWindowTopY());
        ret.append(",");
        ret.append(windowpos_p.getPositionMainWindow());
        ret.append(",");
        ret.append(windowpos_p.getUnits());
        ret.append(");");
        return ret.toString();
    }

    private static String getViewerWindowScript(String sOpenURL_p, String sViewerName_p, String sDmsID_p, int iPage_p) {
        StringBuilder ret = new StringBuilder();
        ret.append("openViewerWindow('");
        ret.append(sOpenURL_p);
        ret.append("','");
        ret.append(OwMimeManager.hashViewerName(sViewerName_p));
        ret.append("','");
        ret.append(sDmsID_p);
        ret.append("',");
        ret.append(String.valueOf(iPage_p));
        ret.append(");");
        return ret.toString();
    }

    public static String getAutoViewerScript(OwMainAppContext context_p, String strOpenURL_p, int viewermode_p, String id_p, String sDmsID_p, int iPage_p) {
        switch (viewermode_p) {
            default: {
                return OwMimeManager.getViewerWindowArrangeScript(strOpenURL_p, "Viewer", sDmsID_p, iPage_p, context_p.getWindowPositions());
            }
            case 4: {
                return OwMimeManager.getViewerWindowScript(strOpenURL_p, OwMimeManager.makeViewerTitleString(id_p), sDmsID_p, iPage_p);
            }
            case 3: {
                return OwMimeManager.getViewerWindowArrangeScript(strOpenURL_p, OwMimeManager.makeViewerTitleString(id_p), sDmsID_p, iPage_p, context_p.getWindowPositions());
            }
            case 5: 
        }
        return strOpenURL_p.endsWith(";") ? strOpenURL_p : strOpenURL_p + ";";
    }

    public static String getAutoViewerScript(OwMainAppContext context_p, String strOpenURL_p, int viewermode_p, String id_p, String sDmsID_p, int iPage_p, OwWindowPositions windowpos_p) {
        switch (viewermode_p) {
            default: {
                return OwMimeManager.getViewerWindowArrangeScript(strOpenURL_p, "Viewer", sDmsID_p, iPage_p, windowpos_p);
            }
            case 4: {
                return OwMimeManager.getViewerWindowScript(strOpenURL_p, OwMimeManager.makeViewerTitleString(id_p), sDmsID_p, iPage_p);
            }
            case 3: {
                return OwMimeManager.getViewerWindowArrangeScript(strOpenURL_p, OwMimeManager.makeViewerTitleString(id_p), sDmsID_p, iPage_p, windowpos_p);
            }
            case 5: 
        }
        return strOpenURL_p;
    }

    protected static String getServletReplacedTokenString(String servletURL_p, OwMainAppContext currentContext_p, OwObjectReference obj_p, OwXMLUtil mimeNode_p, int page_p) throws UnsupportedEncodingException, Exception {
        return OwMimeManager.getServletReplacedTokenString(servletURL_p, currentContext_p, obj_p, mimeNode_p, page_p, Integer.MIN_VALUE);
    }

    protected static String getServletReplacedTokenString(String servletURL_p, OwMainAppContext currentContext_p, OwObjectReference obj_p, OwXMLUtil mimeNode_p, int page_p, int contentType_p) throws UnsupportedEncodingException, Exception {
        StringBuilder retVal = new StringBuilder(servletURL_p);
        OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_BASEURL, currentContext_p.getBaseURL() + "/");
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL) >= 0) {
            OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL, currentContext_p.getServerURL() + "/");
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_DMSID) >= 0) {
            OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_DMSID, OwAppContext.encodeURL(obj_p.getDMSID()));
        }
        if (retVal.indexOf(REPLACE_TOKEN_VIID) >= 0) {
            OwVIIdFactory factory = currentContext_p.getRegisteredInterface(OwVIIdFactory.class);
            if (factory != null) {
                OwVIId viid = factory.createVersionIndependentId(obj_p.getInstance());
                OwString.replaceAll(retVal, REPLACE_TOKEN_VIID, OwAppContext.encodeURL(viid.getViidAsString()));
            } else {
                LOG.warn((Object)"OwMimeManager: No OwVIId factory registered, cannot replace token in MIME definition");
            }
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PAGE) >= 0) {
            OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_PAGE, Integer.toString(page_p));
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_SECURITYTOKEN) >= 0) {
            OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_SECURITYTOKEN, currentContext_p.getNetwork().getCredentials().getSecurityToken(null));
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_SECURITYTOKEN_ENC) >= 0) {
            OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_SECURITYTOKEN_ENC, OwAppContext.encodeURL(currentContext_p.getNetwork().getCredentials().getSecurityToken(null)));
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PAGE_COUNT) >= 0) {
            retVal = new StringBuilder(PAGECOUNT_REPLACE_SCANNER.replace(currentContext_p, obj_p, retVal.toString(), VIEWER_SERVLET_REPLACE_TOKEN_PAGE_COUNT, mimeNode_p));
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_DOWNLOAD_URL) >= 0) {
            retVal = new StringBuilder(URL_REPLACE_SCANNER.replace(currentContext_p, obj_p, retVal.toString(), VIEWER_SERVLET_REPLACE_TOKEN_DOWNLOAD_URL, mimeNode_p));
        }
        if (retVal.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_CONTENT_TYPE) >= 0 && contentType_p != Integer.MIN_VALUE) {
            OwString.replaceAll(retVal, VIEWER_SERVLET_REPLACE_TOKEN_CONTENT_TYPE, String.valueOf(contentType_p));
        }
        return OwMimeManager.replaceProperties(currentContext_p, retVal.toString(), obj_p);
    }

    private static String hashViewerName(String viewerName_p) {
        if (viewerName_p != null) {
            int hash = viewerName_p.hashCode();
            String hashedName = Integer.toString(hash);
            if (hash < 0) {
                hashedName = hashedName.replace('-', '_');
            }
            return hashedName;
        }
        return null;
    }

    public static class OwOpenCommand {
        private String m_sCommand;
        private int m_iViewerMode;
        private OwMainAppContext m_context;
        private OwObjectReference m_obj;
        private boolean m_fHandler = false;

        public OwOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String additionalParams_p) throws Exception {
            this(context_p, obj_p, additionalParams_p, 1);
        }

        public OwOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String additionalParams_p, int page_p) throws Exception {
            this(context_p, obj_p, null, additionalParams_p, page_p, Boolean.FALSE);
        }

        public OwOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p, String additionalParams_p, int page_p) throws Exception {
            this(context_p, obj_p, mimeContext_p, additionalParams_p, page_p, Boolean.FALSE);
        }

        public OwOpenCommand(OwMainAppContext context_p, OwObjectReference obj_p, String mimeContext_p, String additionalParams_p, int page_p, boolean handleEditTag_p) throws Exception {
            this.m_context = context_p;
            this.m_obj = obj_p;
            OwXMLUtil mimeNode = OwMimeManager.getMimeNode(context_p.getConfiguration(), obj_p, mimeContext_p);
            String strViewServlet = mimeNode.getSafeTextValue(handleEditTag_p ? OwMimeManager.MIME_EDITSERLVET : OwMimeManager.MIME_VIEWERSERLVET, null);
            if (strViewServlet != null) {
                this.m_iViewerMode = mimeNode.getSafeIntegerAttributeValue(OwMimeManager.MIME_ATT_AUTOVIEWERMODE, 0);
                if (handleEditTag_p) {
                    OwStandardXMLUtil edit = new OwStandardXMLUtil(mimeNode.getSubNode(OwMimeManager.MIME_EDITSERLVET));
                    this.m_iViewerMode = edit.getSafeIntegerAttributeValue(OwMimeManager.MIME_ATT_AUTOVIEWERMODE, this.m_iViewerMode);
                }
            } else {
                throw new OwInvalidOperationException("OwMimeManager.OwOpenCommand: ...Is not a servlet.");
            }
            this.m_sCommand = this.createURL(obj_p, strViewServlet, mimeNode, additionalParams_p, page_p);
        }

        public OwOpenCommand(OwMimeManager mimemanager_p, OwObjectReference obj_p, String additionalParams_p) throws Exception {
            this(mimemanager_p, obj_p, additionalParams_p, 1);
        }

        public OwOpenCommand(OwMimeManager mimemanager_p, OwObjectReference obj_p, String additionalParams_p, int page_p) throws Exception {
            this(mimemanager_p, obj_p, additionalParams_p, page_p, Boolean.FALSE);
        }

        public OwOpenCommand(OwMimeManager mimemanager_p, OwObjectReference obj_p, String additionalParams_p, int page_p, boolean handleEditTag_p) throws Exception {
            this.m_context = (OwMainAppContext)mimemanager_p.getContext();
            this.m_obj = obj_p;
            OwXMLUtil mimeNode = OwMimeManager.getMimeNode(this.m_context.getConfiguration(), obj_p);
            String strViewServlet = mimeNode.getSafeTextValue(handleEditTag_p ? OwMimeManager.MIME_EDITSERLVET : OwMimeManager.MIME_VIEWERSERLVET, null);
            if (strViewServlet != null) {
                this.m_iViewerMode = mimeNode.getSafeIntegerAttributeValue(OwMimeManager.MIME_ATT_AUTOVIEWERMODE, 0);
                if (handleEditTag_p) {
                    OwStandardXMLUtil edit = new OwStandardXMLUtil(mimeNode.getSubNode(OwMimeManager.MIME_EDITSERLVET));
                    this.m_iViewerMode = edit.getSafeIntegerAttributeValue(OwMimeManager.MIME_ATT_AUTOVIEWERMODE, this.m_iViewerMode);
                }
                this.m_sCommand = this.createURL(obj_p, strViewServlet, mimeNode, additionalParams_p, page_p);
                return;
            }
            this.m_fHandler = true;
            mimemanager_p.registerObject(obj_p);
            String strEventHandler = mimeNode.getSafeTextValue(OwMimeManager.MIME_EVENTHANDLER, null);
            if (strEventHandler != null) {
                this.m_sCommand = mimemanager_p.createLinkUrl("PluginEventHandler", obj_p, null);
                return;
            }
            String strDocumentFunction = mimeNode.getSafeTextValue(OwMimeManager.MIME_DOCUMENTFUNCTION, null);
            if (strDocumentFunction != null) {
                this.m_sCommand = mimemanager_p.createLinkUrl("DocumentFunctionHandler", obj_p, null);
                return;
            }
        }

        private String createURL(OwObjectReference obj_p, String strViewServlet_p, OwXMLUtil mimeNode_p, String additionalParam_p, int page_p) throws Exception {
            if (additionalParam_p != null) {
                strViewServlet_p = additionalParam_p.startsWith("&") ? strViewServlet_p + additionalParam_p : strViewServlet_p + "&" + additionalParam_p;
            }
            return OwMimeManager.getServletReplacedTokenString(strViewServlet_p, this.m_context, obj_p, mimeNode_p, page_p);
        }

        public int getViewerMode() {
            return this.m_iViewerMode;
        }

        public boolean canGetScript() {
            return !this.m_fHandler;
        }

        public String getScript(int iViewerMode_p, OwWindowPositions windowpos_p, boolean fPreviewMode_p) throws Exception {
            if (iViewerMode_p == 1 || this.m_iViewerMode == 5) {
                iViewerMode_p = this.m_iViewerMode;
            }
            String scmd = this.m_sCommand;
            if (fPreviewMode_p && this.m_iViewerMode == 5) {
                scmd = OwMimeManager.getDownloadURL(this.m_context, this.m_obj, 1, 1);
                iViewerMode_p = 1;
            }
            if (windowpos_p != null) {
                return OwMimeManager.getAutoViewerScript(this.m_context, scmd, iViewerMode_p, this.m_obj.getDMSID(), this.m_obj.getDMSID(), 1, windowpos_p);
            }
            return OwMimeManager.getAutoViewerScript(this.m_context, scmd, iViewerMode_p, this.m_obj.getDMSID(), this.m_obj.getDMSID(), 1);
        }

        public boolean canGetURL() {
            return this.m_iViewerMode != 5;
        }

        public String getURL() throws OwInvalidOperationException {
            if (!this.canGetURL()) {
                throw new OwInvalidOperationException("OwMimeManager.getURL: URL is a script command = " + this.m_sCommand);
            }
            return this.m_sCommand;
        }
    }

    private static class OwPageCountReplaceScanner
    extends OwReplaceScanner {
        private OwPageCountReplaceScanner() {
        }

        @Override
        protected String getReplacement(OwMainAppContext context_p, OwObjectReference obj_p, OwXMLUtil mimeNode_p) throws Exception {
            return String.valueOf(obj_p.getPageCount());
        }
    }

    private static class OwDownloadURLReplaceScanner
    extends OwReplaceScanner {
        private OwDownloadURLReplaceScanner() {
        }

        @Override
        protected String getReplacement(OwMainAppContext context_p, OwObjectReference obj_p, OwXMLUtil mimeNode_p) throws Exception {
            return OwMimeManager.getDownloadURL(context_p, obj_p, 1, 1, mimeNode_p);
        }
    }

    protected static abstract class OwReplaceScanner {
        protected OwReplaceScanner() {
        }

        public String replace(OwMainAppContext context_p, OwObjectReference obj_p, String strIn_p, String strPattern_p, OwXMLUtil mimeNode_p) throws Exception {
            int iIndex = strIn_p.indexOf(strPattern_p);
            if (iIndex == -1) {
                return strIn_p;
            }
            StringBuilder strRet = new StringBuilder();
            int iOldIndex = 0;
            while (-1 != iIndex) {
                strRet.append(strIn_p.substring(iOldIndex, iIndex));
                strRet.append(this.getReplacement(context_p, obj_p, mimeNode_p));
                iOldIndex = iIndex += strPattern_p.length();
                iIndex = strIn_p.indexOf(strPattern_p, iIndex);
            }
            if (iOldIndex <= strIn_p.length()) {
                strRet.append(strIn_p.substring(iOldIndex, strIn_p.length()));
            }
            return strRet.toString();
        }

        protected abstract String getReplacement(OwMainAppContext var1, OwObjectReference var2, OwXMLUtil var3) throws Exception;
    }
}

