/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwStandardSequenceDialog;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import java.util.List;

public abstract class OwObjectSequenceDialog
extends OwStandardSequenceDialog {
    private List<OwObject> objectItems;
    private int index;

    public OwObjectSequenceDialog(List<OwObject> objectItems) {
        this.objectItems = objectItems;
    }

    @Override
    public void prev(boolean fRemoveCurrent_p) throws Exception {
        if (fRemoveCurrent_p) {
            throw new OwNotSupportedException("OwEditPropertiesDialog.prev(fRemoveCurrent_p==true) not supported.");
        }
        this.index = this.hasPrev() ? --this.index : this.objectItems.size() - 1;
        this.initPrevtNewItem();
    }

    protected void initPrevtNewItem() throws OwException {
        this.initNewItem(false);
    }

    @Override
    public void next(boolean fRemoveCurrent_p) throws Exception {
        if (fRemoveCurrent_p) {
            if (this.getCount() == 1) {
                super.closeDialog();
                return;
            }
            this.objectItems.remove(this.index);
            if (this.index >= this.objectItems.size()) {
                this.index = 0;
            }
        } else {
            this.index = this.hasNext() ? ++this.index : 0;
        }
        this.initNextNewItem();
    }

    protected void initNextNewItem() throws OwException {
        this.initNewItem(true);
    }

    protected abstract void initNewItem(Object var1) throws OwException;

    protected int getIndex() {
        return this.index;
    }

    public OwObject getCurrentItem() {
        return this.objectItems.get(this.index);
    }

    @Override
    public int getCount() {
        return this.objectItems.size();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.index < this.objectItems.size() - 1;
    }

    @Override
    public boolean hasPrev() throws Exception {
        return this.index > 0;
    }
}

