/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app.impl.viid;

import com.wewebu.ow.server.app.id.viid.OwVIId;
import com.wewebu.ow.server.app.id.viid.OwVIIdType;

public class OwSimpleVIId
implements OwVIId {
    private String objectId;
    private String resourceId;
    private String typeString;
    private OwVIIdType type;

    public OwSimpleVIId(String objectId, String resourceId, String type) {
        this(objectId, resourceId, OwVIIdType.getFromPrefix(type));
        if (this.getType() == null) {
            this.typeString = type;
        }
    }

    public OwSimpleVIId(String objectId, String resourceId, OwVIIdType type) {
        this.objectId = objectId;
        this.resourceId = resourceId;
        this.type = type;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public OwVIIdType getType() {
        return this.type;
    }

    @Override
    public String getTypeAsString() {
        if (this.getType() != null) {
            return this.getType().getPrefix();
        }
        return this.typeString;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public String getViidAsString() {
        return OwSimpleVIId.getViidString(this.getResourceId(), this.getObjectId(), this.getTypeAsString());
    }

    public static String getViidString(String resourceId, String objectId, String type) {
        StringBuilder vidmsid = new StringBuilder("viid");
        vidmsid.append(",");
        vidmsid.append(type);
        vidmsid.append(",");
        vidmsid.append(objectId);
        vidmsid.append(",");
        vidmsid.append(resourceId);
        return vidmsid.toString();
    }

    public static String getUoidString(String resourceId, String objectId, OwVIIdType type) {
        return OwSimpleVIId.getViidString(resourceId, objectId, type.getPrefix());
    }
}

