/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app.viewer;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.viewer.OwAnnotationInfoProvider;
import com.wewebu.ow.server.ui.viewer.OwInfoProvider;
import com.wewebu.ow.server.ui.viewer.OwInfoProviderRegistry;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OwSimpleInfoProviderRegistry
implements OwInfoProviderRegistry {
    private static final Logger LOG = OwLogCore.getLogger(OwSimpleInfoProviderRegistry.class);
    private OwRoleManagerContext roleCtxt;
    private HashMap<String, OwInfoProvider> registry;

    public OwSimpleInfoProviderRegistry(OwRoleManagerContext roleCtxt_p) {
        this.roleCtxt = roleCtxt_p;
        this.registry = new HashMap();
        this.init();
    }

    protected void init() {
        block7: {
            OwInfoProvider prov;
            OwNetwork network;
            String fqc;
            block6: {
                fqc = OwInfoProvider.class.getCanonicalName();
                network = this.roleCtxt.getNetwork();
                if (network.hasInterface(fqc)) {
                    try {
                        prov = (OwInfoProvider)network.getInterface(fqc, this);
                        this.registerProvider(network.getDMSPrefix(), prov);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Object)("Network has not implemented the interface, DMS prefix is = " + network.getDMSPrefix()), (Throwable)e);
                    }
                }
            }
            if (network.hasInterface(fqc = OwAnnotationInfoProvider.class.getCanonicalName())) {
                try {
                    prov = (OwInfoProvider)network.getInterface(fqc, this);
                    this.registerProvider("annot_" + network.getDMSPrefix(), prov);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("Network has not implemented the annotation interface, DMS prefix is = " + network.getDMSPrefix()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public OwInfoProvider getInfoProvider(String context_p) {
        return this.registry.get(context_p);
    }

    @Override
    public void registerProvider(String context_p, OwInfoProvider pro_p) {
        this.registry.put(context_p, pro_p);
    }

    @Override
    public OwInfoProvider unregisterProvider(String context_p) {
        return this.registry.remove(context_p);
    }
}

