/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections;

import com.wewebu.ow.server.collections.OwCollectionIterable;
import com.wewebu.ow.server.collections.OwCollectionPageIterable;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwIterableAttributeBag;
import com.wewebu.ow.server.collections.impl.OwAbstractIterator;
import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;

public abstract class OwAbstractIterable<T>
extends OwIterableAttributeBag<T> {
    private final OwAbstractPageFetcher<T> pageFetcher;
    private final long skipCount;
    private OwAbstractIterator<T> iterator;

    protected OwAbstractIterable(long skipCount, OwAbstractPageFetcher<T> pageFetcher) {
        this.skipCount = skipCount;
        this.pageFetcher = pageFetcher;
    }

    @Override
    public long getTotalNumItems() {
        return this.getIterator().getTotalNumItems();
    }

    protected OwAbstractIterator<T> getIterator() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator;
    }

    protected OwAbstractPageFetcher<T> getPageFetcher() {
        return this.pageFetcher;
    }

    protected long getSkipCount() {
        return this.skipCount;
    }

    @Override
    public long getPageNumItems() {
        return this.getIterator().getPageNumItems();
    }

    @Override
    public boolean getHasMoreItems() {
        return this.getIterator().getHasMoreItems();
    }

    @Override
    public OwIterable<T> skipTo(long position) {
        return new OwCollectionIterable<T>(position, this.pageFetcher);
    }

    @Override
    public OwIterable<T> getPage() {
        return new OwCollectionPageIterable<T>(this.skipCount, this.pageFetcher);
    }

    @Override
    public OwIterable<T> getPage(int maxNumItems) {
        OwAbstractPageFetcher<T> newPageFetcher = this.pageFetcher.newCopy(maxNumItems);
        return new OwCollectionPageIterable<T>(this.skipCount, newPageFetcher);
    }

    protected abstract OwAbstractIterator<T> createIterator();
}

