/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections;

import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.util.Iterator;

public class OwIterableObjectCollectionConverter
extends OwStandardObjectCollection {
    private static final long serialVersionUID = 1L;

    public OwIterableObjectCollectionConverter(OwIterable<?> iterable, long skip) throws OwException {
        this(iterable, skip, -1);
    }

    public OwIterableObjectCollectionConverter(OwIterable<?> iterable, long skip, int maxItemsCount) throws OwException {
        OwIterable<?> page = null;
        page = iterable.skipTo(skip);
        Iterator<?> subIterator = page.iterator();
        try {
            for (int index = 0; subIterator.hasNext() && (maxItemsCount < 0 || maxItemsCount != index); ++index) {
                Object object = subIterator.next();
                this.add(object);
            }
            this.setAttribute("ow_size", this.size());
            this.setAttribute("ow_complete", subIterator.hasNext() ? Boolean.FALSE : Boolean.TRUE);
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Invalid iterable conversion request.", (Throwable)e);
        }
    }
}

