/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections.impl;

import com.wewebu.ow.server.collections.impl.OwAbstractIterator;
import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import java.util.List;

public class OwCollectionIterator<T>
extends OwAbstractIterator<T> {
    public OwCollectionIterator(long skipCount, OwAbstractPageFetcher<T> pageFetcher) {
        super(skipCount, pageFetcher);
    }

    @Override
    public boolean hasNext() {
        OwPage page = this.getCurrentPage();
        if (page == null) {
            return false;
        }
        List items = page.getItems();
        if (items != null && this.getSkipOffset() < items.size()) {
            return true;
        }
        if (!this.getHasMoreItems()) {
            return false;
        }
        long totalItems = this.getTotalNumItems();
        if (totalItems < 0L) {
            return true;
        }
        return this.getSkipCount() + (long)this.getSkipOffset() < totalItems;
    }

    @Override
    public T next() {
        OwPage page = this.getCurrentPage();
        if (page == null) {
            return null;
        }
        List items = page.getItems();
        if (items == null || items.isEmpty()) {
            return null;
        }
        if (this.getSkipOffset() == items.size()) {
            page = this.incrementPage();
            List list = items = page == null ? null : page.getItems();
        }
        if (items == null || items.isEmpty() || this.getSkipOffset() == items.size()) {
            return null;
        }
        return items.get(this.incrementSkipOffset());
    }
}

