/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.command;

import com.wewebu.ow.server.app.OwClipboardException;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.command.OwMultipleObjectsProcessCollector;
import com.wewebu.ow.server.command.OwProcessableObjectStrategy;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwCommand {
    private static final Logger LOG = OwLogCore.getLogger(OwCommand.class);
    private OwProcessableObjectStrategy m_processableObjectStrategy;
    protected OwMainAppContext m_appContext;
    protected OwMultipleObjectsProcessCollector m_collector;
    protected Collection m_objects;
    private boolean m_isExecuted;

    public OwCommand(OwObject object_p, OwMainAppContext appContext_p, OwProcessableObjectStrategy processableObjectStrategy_p) {
        LinkedList<OwObject> objects = new LinkedList<OwObject>();
        objects.add(object_p);
        this.initialize(objects, appContext_p, processableObjectStrategy_p);
    }

    public OwCommand(Collection objects_p, OwMainAppContext appContext_p) {
        this(objects_p, appContext_p, OwProcessableObjectStrategy.ALWAYS_PROCESSABLE_STRATEGY);
    }

    public OwCommand(Collection objects_p, OwMainAppContext appContext_p, OwProcessableObjectStrategy processableObjectStrategy_p) {
        this.initialize(objects_p, appContext_p, processableObjectStrategy_p);
    }

    private void initialize(Collection objects_p, OwMainAppContext appContext_p, OwProcessableObjectStrategy processableObjectStrategy_p) {
        this.m_objects = objects_p;
        this.m_appContext = appContext_p;
        this.m_collector = new OwMultipleObjectsProcessCollector();
        this.m_processableObjectStrategy = processableObjectStrategy_p;
        this.m_isExecuted = false;
    }

    public final void execute() {
        this.m_collector.clear();
        for (OwObject obj : this.m_objects) {
            OwMultipleObjectsProcessCollector.OwObjectCollectData collectData = null;
            try {
                collectData = this.m_collector.createCollectData(obj);
                if (!this.m_processableObjectStrategy.canBeProcessed(obj)) {
                    this.m_collector.addUnprocessedObjectData(collectData);
                    continue;
                }
                this.processObject(obj);
                this.m_collector.addProcessedObjectData(collectData);
            }
            catch (Exception e) {
                String localizedMessage = e.getLocalizedMessage();
                if ((localizedMessage == null || localizedMessage.equals("")) && ((localizedMessage = e.getMessage()) == null || localizedMessage.equals(""))) {
                    localizedMessage = e.toString();
                }
                this.m_collector.addProcessedObjectFailureMessages(localizedMessage);
                if (e instanceof OwClipboardException) {
                    LOG.debug((Object)localizedMessage, (Throwable)e);
                } else {
                    LOG.error((Object)localizedMessage, (Throwable)e);
                }
                if (collectData == null) continue;
                collectData.setFailureReason(e);
                this.m_collector.addFailedObjectData(collectData);
            }
        }
        this.m_isExecuted = true;
    }

    protected abstract void processObject(OwObject var1) throws Exception;

    public boolean hasErrors() {
        this.checkIfIsExecuted();
        return this.m_collector.hasErrors();
    }

    public String getAllErrorMessages() {
        this.checkIfIsExecuted();
        return this.m_collector.getAllErrorMessages();
    }

    public boolean hasProcessedObjects() {
        this.checkIfIsExecuted();
        return this.m_collector.hasProcessedObjects();
    }

    public List getProcessedObjectNames() {
        this.checkIfIsExecuted();
        return this.m_collector.getProcessedNames();
    }

    public List getProcessedObjects() {
        this.checkIfIsExecuted();
        return this.m_collector.getProcessedObjects();
    }

    public Set getProcessedDMSIDs() {
        this.checkIfIsExecuted();
        return this.m_collector.getProcessedDmsIds();
    }

    public List getAllErrorNames() {
        this.checkIfIsExecuted();
        return this.m_collector.getAllErrorNames();
    }

    public List getAllErrorObjects() {
        this.checkIfIsExecuted();
        return this.m_collector.getAllErrorObjects();
    }

    private void checkIfIsExecuted() {
        if (!this.m_isExecuted) {
            throw new RuntimeException("Command not executed! Please call method execute first!");
        }
    }

    public List getDisabledObjects() {
        this.checkIfIsExecuted();
        return this.m_collector.getDisabledObjects();
    }

    public boolean hasDisabledObjects() {
        this.checkIfIsExecuted();
        return this.m_collector.getDisabledObjects().size() > 0;
    }

    public List getDisabledObjectNames() {
        return this.m_collector.getDisabledObjectNames();
    }

    public List getFailedObjectsData() {
        this.checkIfIsExecuted();
        return this.m_collector.getFailedObjectsData();
    }
}

