/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyFormularView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwJspConfigurable;
import java.io.Writer;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwCreateObjectFormularDialog
extends OwStandardDialog
implements OwJspConfigurable {
    private static final Logger LOG = OwLogCore.getLogger(OwCreateObjectFormularDialog.class);
    protected OwObjectSkeleton m_sceletonObject;
    protected OwObjectPropertyFormularView m_PropertyView;
    private String m_strDmsID;
    protected OwObject m_folderObject;
    protected String m_strObjectClass;
    protected String m_strObjectClassParent;
    protected OwObjectClass m_folderClass;
    protected OwClientRefreshContext m_RefreshCtx;
    protected boolean m_fOpenObject;
    protected String m_strJspPage;
    protected Map m_ValuesMap;
    public static final int DIALOG_STATUS_NONE = 0;
    public static final int DIALOG_STATUS_OK = 1;
    public static final int DIALOG_STATUS_FAILED = 2;
    protected int m_dialogStatus = 0;
    private OwJspFormConfigurator m_jspConfigurator;

    public OwCreateObjectFormularDialog(OwObject folderObject_p, String strClassName_p, String strObjectClassParent_p, boolean fOpenObject_p, OwJspFormConfigurator strJspFormConfig_p) {
        this.m_folderObject = folderObject_p;
        this.m_strObjectClass = strClassName_p;
        this.m_fOpenObject = fOpenObject_p;
        this.m_strObjectClassParent = strObjectClassParent_p;
        this.setJspConfigurator(strJspFormConfig_p);
        this.setDocument(new OwDocument());
    }

    public int getStatus() {
        return this.m_dialogStatus;
    }

    public void setValues(Map properties_p) {
        this.m_ValuesMap = properties_p;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.getDocument().attach(this.getContext(), null);
        this.m_PropertyView = new OwObjectPropertyFormularView();
        this.addView(this.m_PropertyView, 2, null);
        this.m_PropertyView.setReadOnlyContext(1);
        this.m_PropertyView.setJspConfigurator(this.getJspConfigurator());
        if (this.m_strObjectClass == null) {
            String msg = "OwCreateObjectFormularDialog.init: Please define a ObjectClass in the plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_folderClass = ((OwMainAppContext)this.getContext()).getNetwork().getObjectClass(this.m_strObjectClass, this.m_folderObject.getResource());
        this.updateObjectClass();
    }

    @Override
    public void detach() {
        super.detach();
        this.getDocument().detach();
    }

    public OwObject getNewObject() throws Exception {
        if (null == this.m_strDmsID) {
            return null;
        }
        return ((OwMainAppContext)this.getContext()).getNetwork().getObjectFromDMSID(this.m_strDmsID, false);
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 2: {
                this.m_strDmsID = this.create();
                this.closeDialog();
                OwObject recordObject = this.getNewObject();
                if (this.m_fOpenObject) {
                    OwMasterDocument recordPlugin = OwMimeManager.getHandlerMasterPlugin((OwMainAppContext)this.getContext(), recordObject);
                    if (recordPlugin == null) {
                        String msg = "OwCreateObjectFormularDialog.onUpdate: Recordplugin Id must be specified if a record is created.";
                        LOG.fatal((Object)msg);
                        throw new OwConfigurationException(msg);
                    }
                    recordPlugin.dispatch(1, recordObject, null);
                }
                if (this.m_RefreshCtx == null) break;
                this.m_RefreshCtx.onClientRefreshContextUpdate(8, recordObject);
                this.m_RefreshCtx.onClientRefreshContextUpdate(4, recordObject);
            }
        }
    }

    public void setRefreshContext(OwClientRefreshContext pluginRefreshCtx_p) {
        this.m_RefreshCtx = pluginRefreshCtx_p;
    }

    protected String create() throws Exception {
        OwPropertyCollection docStandardPropertiesMap = this.m_sceletonObject.getEditableProperties(1);
        String docType = this.m_sceletonObject.getObjectClass().getClassName();
        String newDmsid = null;
        try {
            newDmsid = ((OwMainAppContext)this.getContext()).getNetwork().createNewObject(this.m_folderObject.getResource(), docType, docStandardPropertiesMap, null, null, this.m_folderObject, null, null);
        }
        catch (Exception e) {
            this.m_dialogStatus = 2;
            throw e;
        }
        this.m_dialogStatus = 1;
        return newDmsid;
    }

    private void updateObjectClass() throws Exception {
        this.m_sceletonObject = ((OwMainAppContext)this.getContext()).getNetwork().createObjectSkeleton(this.m_folderClass, this.m_folderObject.getResource());
        if (null != this.m_ValuesMap) {
            for (String strPropName : this.m_ValuesMap.keySet()) {
                try {
                    OwProperty skeletonProp = this.m_sceletonObject.getProperty(strPropName);
                    skeletonProp.setValue(this.m_ValuesMap.get(strPropName));
                }
                catch (OwObjectNotFoundException owObjectNotFoundException) {}
            }
        }
        this.m_PropertyView.setObjectRef(this.m_sceletonObject);
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("dmsdialogs/OwCreateObjectFormularDialog.jsp", w_p);
    }

    @Override
    public OwJspFormConfigurator getJspConfigurator() {
        return this.m_jspConfigurator;
    }

    @Override
    public void setJspConfigurator(OwJspFormConfigurator jspFormConfigurator_p) {
        this.m_jspConfigurator = jspFormConfigurator_p;
    }
}

