/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.wd.ui.conf.prop.OwPropertyInfo;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwGroupPropertiesConfiguration {
    private static final String GRUP_COLLAPSED_STATUS_ATTRIBUTE_NAME = "collapsed";
    private static final String GROUP_ID_ATTRIBUTE_NAME = "id";
    private static final String READONLY_ATTRIBUTE_NAME = "readonly";
    private static final String PROPERTY_GROUPS_ELEMENT_NAME = "PropertyGroups";
    private static final String GROUP_DISPLAY_NAME_ATTRIBUTE_NAME = "displayname";
    private static Logger LOG = OwLogCore.getLogger(OwGroupPropertiesConfiguration.class);
    private boolean m_isConfigured = false;
    private Map<String, OwPropertyGroup> m_propertyGroups = null;
    private Map<String, Boolean> m_readOnlyProperties;
    private LinkedList<String> m_allPropertyNames;

    public OwGroupPropertiesConfiguration(OwXMLUtil node_p, OwMainAppContext context_p) throws OwConfigurationException {
        try {
            String pluginId = node_p.getSafeTextValue(GROUP_ID_ATTRIBUTE_NAME, null);
            OwXMLUtil groupsUtil = node_p.getSubUtil(PROPERTY_GROUPS_ELEMENT_NAME);
            this.m_propertyGroups = new LinkedHashMap<String, OwPropertyGroup>();
            this.m_readOnlyProperties = new HashMap<String, Boolean>();
            this.m_allPropertyNames = new LinkedList();
            if (groupsUtil != null) {
                List safeNodeList = groupsUtil.getSafeNodeList();
                Iterator groupsIterator = safeNodeList.iterator();
                while (groupsIterator.hasNext()) {
                    OwStandardXMLUtil group = new OwStandardXMLUtil((Node)groupsIterator.next());
                    String groupId = group.getSafeStringAttributeValue(GROUP_ID_ATTRIBUTE_NAME, null);
                    String groupDisplayName = group.getSafeStringAttributeValue(GROUP_DISPLAY_NAME_ATTRIBUTE_NAME, null);
                    boolean isCollapsed = group.getSafeBooleanAttributeValue(GRUP_COLLAPSED_STATUS_ATTRIBUTE_NAME, false);
                    List properties = group.getSafeNodeList();
                    if (properties == null) continue;
                    LinkedList<OwPropertyInfo> propertyInfos = new LinkedList<OwPropertyInfo>();
                    Iterator it = properties.iterator();
                    while (it.hasNext()) {
                        OwStandardXMLUtil propertyConfig = new OwStandardXMLUtil((Node)it.next());
                        String propertyName = propertyConfig.getSafeTextValue(null);
                        boolean fReadOnly = propertyConfig.getSafeBooleanAttributeValue(READONLY_ATTRIBUTE_NAME, false);
                        if (null == propertyName) continue;
                        propertyInfos.add(new OwPropertyInfo(propertyName, fReadOnly));
                        if (fReadOnly) {
                            this.m_readOnlyProperties.put(propertyName, Boolean.TRUE);
                        }
                        this.m_allPropertyNames.add(propertyName);
                    }
                    OwPropertyGroup theGroup = new OwPropertyGroup(groupId, groupDisplayName, pluginId, propertyInfos, isCollapsed);
                    this.m_propertyGroups.put(theGroup.getGroupId(), theGroup);
                }
                this.m_isConfigured = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Configuration for property grouping could not be loaded. Reason: " + e.getMessage()), (Throwable)e);
            throw new OwConfigurationException(context_p.localize("app.OwConfiguration.groupproperties.cannotconfigure", "Configuration for property grouping could not be loaded."), (Throwable)e);
        }
    }

    public boolean isConfigured() {
        return this.m_isConfigured;
    }

    public List<OwPropertyGroup> getGroups() {
        return new LinkedList<OwPropertyGroup>(this.m_propertyGroups.values());
    }

    public OwPropertyGroup getGroupById(String groupId_p) {
        return this.m_propertyGroups.get(groupId_p);
    }

    public Map<String, Boolean> getReadOnlyProperties() {
        return this.m_readOnlyProperties;
    }

    public List<String> getAllPropertyNames() {
        return this.m_allPropertyNames;
    }

    public static class OwPropertyGroup
    implements org.alfresco.wd.ui.conf.prop.OwPropertyGroup<OwPropertyInfo> {
        private String m_groupId;
        private String m_groupDisplayName;
        private boolean m_isCollapsed = false;
        private List<OwPropertyInfo> m_properties;
        private String m_pluginId;

        public OwPropertyGroup(String groupId_p, String groupDisplayName_p, String pluginId_p, List<OwPropertyInfo> propertyInfos_p, boolean isCollapsed_p) {
            this.m_groupId = groupId_p;
            this.m_groupDisplayName = groupDisplayName_p;
            this.m_properties = propertyInfos_p;
            this.m_pluginId = pluginId_p;
            this.m_isCollapsed = isCollapsed_p;
        }

        @Override
        public String getGroupId() {
            return this.m_groupId;
        }

        @Override
        public List<OwPropertyInfo> getProperties() {
            return Collections.unmodifiableList(this.m_properties);
        }

        @Override
        public String getDisplayName(OwAppContext context_p) {
            return context_p.localize(this.getPluginId() + "." + this.m_groupId, this.m_groupDisplayName);
        }

        @Override
        public void setCollapsed(boolean isCollapsed_p) {
            this.m_isCollapsed = isCollapsed_p;
        }

        @Override
        public boolean isCollapsed() {
            return this.m_isCollapsed;
        }

        protected String getPluginId() {
            return this.m_pluginId;
        }
    }
}

